/*
 * Decompiled with CFR 0.152.
 */
package com.partypoints;

import com.google.inject.Inject;
import com.partypoints.PartyPointsConfig;
import com.partypoints.PartyPointsMembers;
import com.partypoints.PartyPointsPlugin;
import com.partypoints.data.PartyData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.party.PartyService;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.DragAndDropReorderPane;
import net.runelite.client.ui.components.PluginErrorPanel;

public class PartyPointsPanel
extends PluginPanel {
    private static final String BTN_CREATE_TEXT = "Create Party";
    private static final String BTN_LEAVE_TEXT = "Leave";
    private final PartyPointsPlugin plugin;
    private final PartyService party;
    private final PartyPointsConfig config;
    private final Map<Long, PartyPointsMembers> membersMap = new HashMap<Long, PartyPointsMembers>();
    private final JButton startButton = new JButton();
    private final JButton joinPartyButton = new JButton();
    private final JButton rejoinPartyButton = new JButton();
    private final JButton copyPartyIdButton = new JButton();
    private final JButton refreshPartyButton = new JButton();
    private final PluginErrorPanel noPartyPanel = new PluginErrorPanel();
    private final PluginErrorPanel emptyPartyPanel = new PluginErrorPanel();
    private final JComponent memberBoxPanel = new DragAndDropReorderPane();

    @Inject
    PartyPointsPanel(ClientThread clientThread, PartyPointsPlugin plugin, PartyPointsConfig config, PartyService party) {
        this.plugin = plugin;
        this.party = party;
        this.config = config;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        JPanel layoutPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(layoutPanel, 1);
        layoutPanel.setLayout(boxLayout);
        this.add(layoutPanel, "North");
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        topPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.insets = new Insets(0, 2, 4, 2);
        constraints.gridx = 0;
        constraints.gridy = 0;
        topPanel.add((Component)this.startButton, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        topPanel.add((Component)this.joinPartyButton, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        topPanel.add((Component)this.copyPartyIdButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        topPanel.add((Component)this.rejoinPartyButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        topPanel.add((Component)this.refreshPartyButton, constraints);
        layoutPanel.add(topPanel);
        layoutPanel.add(this.memberBoxPanel);
        this.startButton.setText(party.isInParty() ? BTN_LEAVE_TEXT : BTN_CREATE_TEXT);
        this.startButton.setFocusable(false);
        this.joinPartyButton.setText("Join party");
        this.joinPartyButton.setFocusable(false);
        this.rejoinPartyButton.setText("Join previous party");
        this.rejoinPartyButton.setFocusable(false);
        this.copyPartyIdButton.setText("Copy passphrase");
        this.copyPartyIdButton.setFocusable(false);
        this.refreshPartyButton.setText("Refresh the Overlay");
        this.refreshPartyButton.setFocusable(false);
        this.startButton.addActionListener(e -> {
            if (party.isInParty()) {
                int result = JOptionPane.showOptionDialog(this.startButton, "Are you sure you want to leave the party?", "Leave party?", 0, 2, null, new String[]{"Yes", "No"}, "No");
                if (result == 0) {
                    plugin.leaveParty();
                }
            } else {
                clientThread.invokeLater(() -> party.changeParty(party.generatePassphrase()));
            }
        });
        this.joinPartyButton.addActionListener(e -> {
            if (!party.isInParty()) {
                String s = (String)JOptionPane.showInputDialog(this.joinPartyButton, "Please enter the party passphrase:", "Party Passphrase", -1, null, null, "");
                if (s == null) {
                    return;
                }
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') continue;
                    JOptionPane.showMessageDialog(this.joinPartyButton, "Party passphrase must be a combination of alphanumeric or hyphen characters.", "Invalid party passphrase", 0);
                    return;
                }
                party.changeParty(s);
            }
        });
        this.rejoinPartyButton.addActionListener(e -> {
            if (!party.isInParty()) {
                party.changeParty(config.previousPartyId());
            }
        });
        this.copyPartyIdButton.addActionListener(e -> {
            if (party.isInParty()) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(party.getPartyPassphrase()), null);
            }
        });
        this.refreshPartyButton.addActionListener(e -> {
            if (party.isInParty()) {
                plugin.leaveParty();
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                party.changeParty(config.previousPartyId());
            }
        });
        this.noPartyPanel.setContent("Not in a party", "Create a party to begin");
        this.updateParty();
    }

    void updateParty() {
        this.remove((Component)this.noPartyPanel);
        this.remove((Component)this.emptyPartyPanel);
        this.startButton.setText(this.party.isInParty() ? BTN_LEAVE_TEXT : BTN_CREATE_TEXT);
        this.joinPartyButton.setVisible(!this.party.isInParty());
        this.rejoinPartyButton.setVisible(!this.party.isInParty());
        this.copyPartyIdButton.setVisible(this.party.isInParty());
        this.refreshPartyButton.setVisible(this.party.isInParty());
        if (!this.party.isInParty()) {
            this.add((Component)this.noPartyPanel);
        } else if (this.plugin.getPartyDataMap().size() <= 1) {
            this.emptyPartyPanel.setContent("Party Created", "Your Party Passphrase is: " + this.party.getPartyPassphrase() + ".");
            this.add((Component)this.emptyPartyPanel);
        }
    }

    void addMember(PartyData partyData) {
        if (!this.membersMap.containsKey(partyData.getMemberId())) {
            PartyPointsMembers partyMember = new PartyPointsMembers(this.plugin, this.config, this.memberBoxPanel, partyData, this.party);
            this.membersMap.put(partyData.getMemberId(), partyMember);
            this.memberBoxPanel.add(partyMember);
            this.memberBoxPanel.revalidate();
        }
        this.updateParty();
    }

    void removeAllMembers() {
        this.membersMap.forEach((key, value) -> this.memberBoxPanel.remove((Component)value));
        this.memberBoxPanel.revalidate();
        this.membersMap.clear();
        this.updateParty();
    }

    void removeMember(long memberId) {
        PartyPointsMembers members = this.membersMap.remove(memberId);
        if (members != null) {
            this.memberBoxPanel.remove(members);
            this.memberBoxPanel.revalidate();
        }
        this.updateParty();
    }

    void updateMember(long userId) {
        PartyPointsMembers members = this.membersMap.get(userId);
        if (members != null) {
            members.update(this.plugin);
        }
    }

    void updateAll() {
        this.membersMap.forEach((key, value) -> value.update(this.plugin));
    }
}

