/*
 * Decompiled with CFR 0.152.
 */
package com.partypoints;

import com.partypoints.PartyPointsConfig;
import com.partypoints.PartyPointsOverlay;
import com.partypoints.PartyPointsPlugin;
import com.partypoints.data.PartyData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.MouseDragEventForwarder;
import net.runelite.client.util.ImageUtil;

public class PartyPointsMembers
extends JPanel {
    private final PartyData memberPartyData;
    private final PartyService partyService;
    private final JLabel name = new JLabel();
    private final JLabel avatar = new JLabel();
    private final JLabel PP = new JLabel();
    private final PartyPointsConfig config;
    private boolean avatarSet;
    private PartyPointsPlugin plugin;

    PartyPointsMembers(PartyPointsPlugin plugin, PartyPointsConfig config, JComponent panel, PartyData memberPartyData, PartyService partyService) {
        this.plugin = plugin;
        this.config = config;
        this.memberPartyData = memberPartyData;
        this.partyService = partyService;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setBorder(new EmptyBorder(5, 5, 5, 5));
        Border border = BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR, 1);
        this.avatar.setBorder(border);
        this.avatar.setHorizontalAlignment(0);
        this.avatar.setVerticalAlignment(0);
        this.avatar.setPreferredSize(new Dimension(35, 35));
        JPanel headerPanel = new JPanel();
        headerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        headerPanel.setLayout(new BorderLayout());
        headerPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
        JPanel namesPanel = new JPanel();
        namesPanel.setLayout(new BorderLayout());
        namesPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
        namesPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
        JPanel PPPanel = new JPanel();
        PPPanel.setLayout(new BorderLayout());
        PPPanel.setBorder(new EmptyBorder(0, 0, 3, 0));
        PPPanel.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.name.setFont(FontManager.getRunescapeFont());
        this.name.putClientProperty("html.disable", Boolean.TRUE);
        this.PP.setFont(FontManager.getRunescapeFont());
        this.PP.putClientProperty("html.disable", Boolean.TRUE);
        namesPanel.add(this.name);
        PPPanel.add(this.PP);
        headerPanel.add((Component)this.avatar, "West");
        headerPanel.add((Component)namesPanel, "Center");
        headerPanel.add((Component)PPPanel, "East");
        container.add((Component)headerPanel, "North");
        MouseDragEventForwarder mouseDragEventForwarder = new MouseDragEventForwarder((Component)panel);
        container.addMouseListener((MouseListener)mouseDragEventForwarder);
        container.addMouseMotionListener((MouseMotionListener)mouseDragEventForwarder);
        this.add((Component)container, "North");
        this.update(plugin);
    }

    void update(PartyPointsPlugin plugin) {
        PartyPointsOverlay partyPointsOverlay = new PartyPointsOverlay(this.plugin, this.config);
        PartyMember member = this.partyService.getMemberById(this.memberPartyData.getMemberId());
        if (!this.avatarSet && member.getAvatar() != null) {
            ImageIcon icon = new ImageIcon(ImageUtil.resizeImage((BufferedImage)member.getAvatar(), (int)32, (int)32));
            icon.getImage().flush();
            this.avatar.setIcon(icon);
            this.avatarSet = true;
        }
        this.name.setForeground(member.isLoggedIn() ? Color.white : ColorScheme.DARKER_GRAY_COLOR);
        this.name.setText(member.getDisplayName());
        this.PP.setText(String.valueOf(this.memberPartyData.getPersonalPoints()));
        plugin.updateOverlay(member.getDisplayName(), this.memberPartyData.getPersonalPoints());
    }
}

