/*
 * Decompiled with CFR 0.152.
 */
package com.brooklyn.toblightup;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB Light Up", description="Removes the dark overlay from outside ToB", tags={"tob", "hub", "brooklyn", "theatre", "tob", "overlay", "blood"})
public class TobLightUpPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobLightUpPlugin.class);
    @Inject
    private Client client;
    private static final Set<Integer> VER_SINHAZA_REGIONS = ImmutableSet.of((Object)14386, (Object)14642);

    protected void startUp() throws Exception {
        this.hideDarkness(false);
    }

    protected void shutDown() throws Exception {
        this.hideDarkness(false);
    }

    private boolean isInVerSinhaza() {
        return VER_SINHAZA_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID());
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.hideDarkness(this.isInVerSinhaza());
    }

    protected void hideDarkness(boolean hide) {
        Widget darkness = this.client.getWidget(28, 1);
        if (darkness != null) {
            darkness.setHidden(hide);
        }
    }
}

