/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.ui.generic;

import com.logmaster.ui.generic.ComponentEventListener;
import com.logmaster.ui.generic.UIComponent;
import com.logmaster.ui.generic.UIGraphic;
import com.logmaster.ui.generic.UILabel;
import net.runelite.api.widgets.Widget;

public class UICheckBox
extends UIComponent {
    private static final int LABEL_COL_DEFAULT = 16750623;
    private static final int LABEL_COL_HOVER = 0xFFFFFF;
    private static final int LABEL_WIDTH = 89;
    private static final int LABEL_HEIGHT = 18;
    private static final int SPRITEID_CHECKBOX_UNCHECKED_STD = 1215;
    private static final int SPRITEID_CHECKBOX_CHECKED_STD = 1217;
    private static final int SPRITEID_CHECKBOX_UNCHECKED_HOV = 1218;
    private static final int SPRITEID_CHECKBOX_CHECKED_HOV = 1220;
    private static final int CHECKBOX_SIZE = 16;
    private static final String OPTION_TOGGLE = "Toggle";
    private UILabel label;
    private UIGraphic checkbox;
    private boolean enabled = false;
    private boolean hovering = false;
    private ComponentEventListener toggleListener;

    public UICheckBox(Widget boxIcon, Widget labelWidget) {
        super(boxIcon);
        this.label = new UILabel(labelWidget);
        this.label.setSize(89, 18);
        this.label.setColour(16750623);
        this.label.setOnHoverListener(this::onLabelHover);
        this.label.setOnLeaveListener(this::onLabelLeave);
        this.label.addAction(OPTION_TOGGLE, this::onCheckboxToggled);
        this.checkbox = new UIGraphic(boxIcon);
        this.checkbox.addAction(OPTION_TOGGLE, this::onCheckboxToggled);
        this.checkbox.setOnHoverListener(e -> this.onLabelHover(this.label));
        this.checkbox.setOnLeaveListener(e -> this.onLabelLeave(this.label));
        this.updateCheckboxSprite();
        this.setSize(16, 16);
    }

    private void onLabelHover(UIComponent src) {
        this.hovering = true;
        UILabel label = (UILabel)src;
        label.setColour(0xFFFFFF);
        this.updateCheckboxSprite();
    }

    private void onLabelLeave(UIComponent src) {
        this.hovering = false;
        UILabel label = (UILabel)src;
        label.setColour(16750623);
        this.updateCheckboxSprite();
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.label.setX(x);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.label.setY(y);
    }

    @Override
    public void setName(String name) {
        this.label.setName(name);
    }

    private void onCheckboxToggled() {
        this.setEnabled(!this.enabled);
        if (this.toggleListener != null) {
            this.toggleListener.onComponentEvent(this);
        }
    }

    private void updateCheckboxSprite() {
        int stdSprite = this.enabled ? 1217 : 1215;
        int hovSprite = this.enabled ? 1220 : 1218;
        this.getWidget().setSpriteId(this.hovering ? hovSprite : stdSprite);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateCheckboxSprite();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setToggleListener(ComponentEventListener toggleListener) {
        this.toggleListener = toggleListener;
    }
}

