/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.ui.component;

import com.logmaster.LogMasterConfig;
import com.logmaster.LogMasterPlugin;
import com.logmaster.domain.Task;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.ui.InterfaceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.util.AsyncBufferedImage;

@Singleton
public class TaskOverlay
extends Overlay {
    private static final Dimension EMPTY = new Dimension(0, 0);
    private static final int WIDTH_ADDITION = 51;
    private static final int MIN_HEIGHT = 46;
    private static final float OUTER_COLOR_OFFSET = 0.8f;
    private static final float INNER_COLOR_OFFSET = 1.2f;
    private static final float ALPHA_OFFSET = 1.4f;
    private static final int MAX_BYTE = 255;
    @Inject
    private LogMasterPlugin plugin;
    @Inject
    private LogMasterConfig config;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InterfaceManager interfaceManager;
    @Inject
    private SaveDataManager saveDataManager;

    public Dimension render(Graphics2D g) {
        try {
            Task currentTask = this.saveDataManager.currentTask();
            if (!this.config.displayCurrentTaskOverlay() || currentTask == null || this.interfaceManager.isDashboardOpen()) {
                return EMPTY;
            }
            AsyncBufferedImage icon = this.itemManager.getImage(currentTask.getItemID());
            String task = currentTask.getDescription();
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(task) + 51;
            int height = 46;
            Color border = this.outsideColor(this.runeLiteConfig.overlayBackgroundColor());
            g.setColor(this.runeLiteConfig.overlayBackgroundColor());
            g.fillRect(0, 0, width, height);
            g.setColor(border);
            g.drawRect(0, 0, width, height);
            int textX = width - fm.stringWidth(task) - 5;
            int textY = 30;
            g.setFont(g.getFont().deriveFont(16.0f));
            g.setColor(Color.BLACK);
            g.drawString(task, textX + 1, textY + 1);
            g.setColor(Color.WHITE);
            g.drawString(task, textX, textY);
            int iconWidth = icon.getWidth(null);
            int iconHeight = icon.getHeight(null);
            g.drawImage((Image)icon, 23 - iconWidth / 2, 23 - iconHeight / 2, iconWidth, iconHeight, null);
            return new Dimension(width, height);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return EMPTY;
        }
    }

    private Color outsideColor(Color base) {
        return new Color(Math.round((float)base.getRed() * 0.8f), Math.round((float)base.getGreen() * 0.8f), Math.round((float)base.getBlue() * 0.8f), Math.min(255, Math.round((float)base.getAlpha() * 1.4f)));
    }

    private Color innerColor(Color base) {
        return new Color(Math.min(255, Math.round((float)base.getRed() * 1.2f)), Math.min(255, Math.round((float)base.getGreen() * 1.2f)), Math.min(255, Math.round((float)base.getBlue() * 1.2f)), Math.min(255, Math.round((float)base.getAlpha() * 1.4f)));
    }
}

