/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.ui.component;

import com.logmaster.LogMasterPlugin;
import com.logmaster.domain.Task;
import com.logmaster.domain.TaskTier;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.task.TaskService;
import com.logmaster.ui.generic.UIButton;
import com.logmaster.ui.generic.UIGraphic;
import com.logmaster.ui.generic.UILabel;
import com.logmaster.ui.generic.UIPage;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskList
extends UIPage {
    private static final Logger log = LoggerFactory.getLogger(TaskList.class);
    private final int OFFSET_X = 10;
    private final int OFFSET_Y = 58;
    private final int CANVAS_WIDTH = 480;
    private final int CANVAS_HEIGHT = 252;
    private final int TASK_WIDTH = 300;
    private final int TASK_HEIGHT = 50;
    private final int TASK_ITEM_HEIGHT = 32;
    private final int TASK_ITEM_WIDTH = 36;
    private final int TASKS_PER_PAGE = 5;
    private final int UP_ARROW_SPRITE_ID = -20014;
    private final int DOWN_ARROW_SPRITE_ID = -20015;
    private final int ARROW_SPRITE_WIDTH = 39;
    private final int ARROW_SPRITE_HEIGHT = 20;
    private final int ARROW_Y_OFFSET = 40;
    private final Widget window;
    private final TaskService taskService;
    private final LogMasterPlugin plugin;
    private final ClientThread clientThread;
    private final SaveDataManager saveDataManager;
    private Rectangle bounds = new Rectangle();
    private List<UIGraphic> taskBackgrounds = new ArrayList<UIGraphic>();
    private List<UILabel> taskLabels = new ArrayList<UILabel>();
    private List<UIGraphic> taskImages = new ArrayList<UIGraphic>();
    private int topTaskIndex = 0;

    public TaskList(Widget window, TaskService taskService, LogMasterPlugin plugin, ClientThread clientThread, SaveDataManager saveDataManager) {
        this.window = window;
        this.taskService = taskService;
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.saveDataManager = saveDataManager;
        this.refreshTasks(0);
        this.updateBounds();
        Widget upWidget = window.createChild(-1, 5);
        UIButton upArrow = new UIButton(upWidget);
        upArrow.setSprites(-20014);
        upArrow.setSize(39, 20);
        upArrow.setPosition(436, 60);
        upArrow.addAction("Scroll up", () -> this.refreshTasks(-1));
        Widget downWidget = window.createChild(-1, 5);
        UIButton downArrow = new UIButton(downWidget);
        downArrow.setSprites(-20015);
        downArrow.setSize(39, 20);
        downArrow.setPosition(436, 80);
        downArrow.addAction("Scroll down", () -> this.refreshTasks(1));
        this.add(upArrow);
        this.add(downArrow);
    }

    public void refreshTasks(int dir) {
        TaskTier relevantTier = this.plugin.getSelectedTier();
        if (relevantTier == null) {
            relevantTier = TaskTier.MASTER;
        }
        if (this.topTaskIndex + dir < 0 || this.topTaskIndex + dir + 5 > this.taskService.getTaskList().getForTier(relevantTier).size()) {
            return;
        }
        this.topTaskIndex += dir;
        int POS_X = LogMasterPlugin.getCenterX(this.window, 300);
        int i = 0;
        for (Task task : this.getTasksToShow(relevantTier, this.topTaskIndex)) {
            UIGraphic taskImage;
            UILabel taskLabel;
            UIGraphic taskBg;
            int POS_Y = 58 + i * 50;
            if (this.taskBackgrounds.size() <= i) {
                taskBg = new UIGraphic(this.window.createChild(-1, 5));
                this.taskBackgrounds.add(taskBg);
                this.add(taskBg);
            } else {
                taskBg = this.taskBackgrounds.get(i);
            }
            taskBg.clearActions();
            taskBg.setSize(300, 50);
            taskBg.setPosition(POS_X, POS_Y);
            taskBg.getWidget().setPos(POS_X, POS_Y);
            TaskTier finalRelevantTier = relevantTier;
            taskBg.addAction("Mark", () -> this.plugin.completeTask(task.getId(), finalRelevantTier));
            if (this.saveDataManager.getSaveData().getProgress().get((Object)relevantTier).contains(task.getId())) {
                taskBg.setSprite(-20013);
            } else if (this.saveDataManager.getSaveData().getActiveTaskPointer() != null && this.saveDataManager.getSaveData().getActiveTaskPointer().getTaskTier() == relevantTier && this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getId() == task.getId()) {
                taskBg.setSprite(-20016);
            } else {
                taskBg.setSprite(-20012);
            }
            if (this.taskLabels.size() <= i) {
                taskLabel = new UILabel(this.window.createChild(-1, 4));
                this.add(taskLabel);
                this.taskLabels.add(taskLabel);
            } else {
                taskLabel = this.taskLabels.get(i);
            }
            taskLabel.getWidget().setTextColor(Color.WHITE.getRGB());
            taskLabel.getWidget().setTextShadowed(true);
            taskLabel.getWidget().setName(task.getDescription());
            taskLabel.setFont(496);
            taskLabel.setPosition(POS_X + 60, POS_Y);
            taskLabel.setSize(240, 50);
            taskLabel.setText(task.getDescription());
            if (this.taskImages.size() <= i) {
                taskImage = new UIGraphic(this.window.createChild(-1, 5));
                this.add(taskImage);
                this.taskImages.add(taskImage);
            } else {
                taskImage = this.taskImages.get(i);
            }
            taskImage.setPosition(POS_X + 12, POS_Y + 6);
            taskImage.getWidget().setBorderType(1);
            taskImage.getWidget().setItemQuantityMode(0);
            taskImage.setSize(36, 32);
            taskImage.setItem(task.getItemID());
            ++i;
        }
    }

    public void goToTop() {
        this.topTaskIndex = 0;
    }

    private List<Task> getTasksToShow(TaskTier relevantTier, int topTaskIndex) {
        ArrayList<Task> tasksToShow = new ArrayList<Task>();
        List<Task> taskList = this.taskService.getTaskList().getForTier(relevantTier);
        for (int i = 0; i < 5 && topTaskIndex + i <= taskList.size(); ++i) {
            tasksToShow.add(taskList.get(topTaskIndex + i));
        }
        return tasksToShow;
    }

    public void handleWheel(MouseWheelEvent event) {
        if (!this.isVisible() || !this.bounds.contains(event.getPoint())) {
            return;
        }
        event.consume();
        this.clientThread.invoke(() -> this.refreshTasks(event.getWheelRotation()));
    }

    public void updateBounds() {
        if (!this.isVisible()) {
            return;
        }
        Widget collectionLogWidget = this.window.getParent();
        Widget collectionLogWrapper = collectionLogWidget.getParent();
        int relativeX = collectionLogWrapper.getRelativeX();
        int relativeY = collectionLogWrapper.getRelativeY();
        this.bounds.setSize(480, 252);
        this.bounds.setLocation(15 + relativeX, 63 + relativeY);
    }
}

