/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.ui.component;

import com.logmaster.LogMasterConfig;
import com.logmaster.LogMasterPlugin;
import com.logmaster.domain.Task;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.task.TaskService;
import com.logmaster.ui.generic.UIButton;
import com.logmaster.ui.generic.UIGraphic;
import com.logmaster.ui.generic.UILabel;
import com.logmaster.ui.generic.UIPage;
import java.awt.Color;
import java.util.List;
import javax.swing.Timer;
import net.runelite.api.widgets.Widget;

public class TaskDashboard
extends UIPage {
    private final int DEFAULT_BUTTON_WIDTH = 140;
    private final int DEFAULT_BUTTON_HEIGHT = 30;
    private final int DEFAULT_TASK_DETAILS_WIDTH = 300;
    private final int DEFAULT_TASK_DETAILS_HEIGHT = 75;
    private final int GENERATE_TASK_SPRITE_ID = -20001;
    private final int COMPLETE_TASK_SPRITE_ID = -20000;
    private final int GENERATE_TASK_HOVER_SPRITE_ID = -20003;
    private final int COMPLETE_TASK_HOVER_SPRITE_ID = -20002;
    private final int GENERATE_TASK_DISABLED_SPRITE_ID = -20005;
    private final int COMPLETE_TASK_DISABLED_SPRITE_ID = -20004;
    private final int TASK_BACKGROUND_SPRITE_ID = -20006;
    private Widget window;
    private LogMasterPlugin plugin;
    private LogMasterConfig config;
    private final TaskService taskService;
    private final SaveDataManager saveDataManager;
    private UILabel title;
    private UILabel taskLabel;
    private UILabel percentCompletion;
    private UIGraphic taskImage;
    private UIGraphic taskBg;
    private UIButton completeTaskBtn;
    private UIButton generateTaskBtn;

    public TaskDashboard(LogMasterPlugin plugin, LogMasterConfig config, Widget window, TaskService taskService, SaveDataManager saveDataManager) {
        this.window = window;
        this.plugin = plugin;
        this.config = config;
        this.taskService = taskService;
        this.saveDataManager = saveDataManager;
        this.createTaskDetails();
        Widget titleWidget = window.createChild(-1, 4);
        this.title = new UILabel(titleWidget);
        this.title.setFont(646);
        this.title.setSize(500, 75);
        this.title.setPosition(LogMasterPlugin.getCenterX(window, 500), 60);
        this.title.setText("Current Task");
        Widget percentWidget = window.createChild(-1, 4);
        this.percentCompletion = new UILabel(percentWidget);
        this.percentCompletion.setFont(496);
        this.percentCompletion.setSize(500, 25);
        this.percentCompletion.setPosition(LogMasterPlugin.getCenterX(window, 500), 259);
        this.updatePercentages();
        Widget completeTaskWidget = window.createChild(-1, 5);
        this.completeTaskBtn = new UIButton(completeTaskWidget);
        this.completeTaskBtn.setSize(140, 30);
        this.completeTaskBtn.setPosition(LogMasterPlugin.getCenterX(window, 140) + 85, LogMasterPlugin.getCenterY(window, 30) + 80);
        this.completeTaskBtn.setSprites(-20000, -20002);
        Widget generateTaskWidget = window.createChild(-1, 5);
        this.generateTaskBtn = new UIButton(generateTaskWidget);
        this.generateTaskBtn.setSize(140, 30);
        this.generateTaskBtn.setPosition(LogMasterPlugin.getCenterX(window, 140) - 85, LogMasterPlugin.getCenterY(window, 30) + 80);
        this.generateTaskBtn.setSprites(-20001, -20003);
        this.add(this.title);
        this.add(this.taskBg);
        this.add(this.taskLabel);
        this.add(this.taskImage);
        this.add(this.completeTaskBtn);
        this.add(this.generateTaskBtn);
        this.add(this.percentCompletion);
    }

    private void createTaskDetails() {
        int POS_X = LogMasterPlugin.getCenterX(this.window, 300);
        int POS_Y = LogMasterPlugin.getCenterY(this.window, 75) + 15;
        Widget taskBgWidget = this.window.createChild(-1, 5);
        this.taskBg = new UIGraphic(taskBgWidget);
        this.taskBg.setSize(300, 75);
        this.taskBg.setPosition(POS_X, POS_Y);
        this.taskBg.setSprite(-20006);
        Widget label = this.window.createChild(-1, 4);
        label.setTextColor(Color.WHITE.getRGB());
        label.setTextShadowed(true);
        label.setName("Task Label");
        this.taskLabel = new UILabel(label);
        this.taskLabel.setFont(496);
        this.taskLabel.setPosition(POS_X + 60, POS_Y);
        this.taskLabel.setSize(240, 75);
        Widget taskImageWidget = this.window.createChild(-1, 5);
        this.taskImage = new UIGraphic(taskImageWidget);
        this.taskImage.setPosition(POS_X + 12, POS_Y + 21);
        this.taskImage.getWidget().setItemQuantityMode(0);
        this.taskImage.setSize(42, 36);
        this.taskImage.getWidget().setBorderType(1);
    }

    public void setTask(String desc, int taskItemID, List<Task> cyclingTasks) {
        if (cyclingTasks != null) {
            for (int i = 0; i < 250; ++i) {
                Task displayTask = cyclingTasks.get((int)Math.floor(Math.random() * (double)cyclingTasks.size()));
                double decay = 450.0 / (double)this.config.rollTime();
                int delay = (int)((double)this.config.rollTime() * 0.925 * Math.exp(-decay * (double)i));
                Timer fakeTaskTimer = new Timer(delay, ae -> {
                    this.taskLabel.setText(displayTask.getDescription());
                    this.taskImage.setItem(displayTask.getItemID());
                });
                fakeTaskTimer.setRepeats(false);
                fakeTaskTimer.setCoalesce(true);
                fakeTaskTimer.start();
            }
            Timer realTaskTimer = new Timer(this.config.rollTime(), ae -> {
                this.taskLabel.setText(desc);
                this.taskImage.setItem(taskItemID);
                this.enableCompleteTask();
            });
            realTaskTimer.setRepeats(false);
            realTaskTimer.setCoalesce(true);
            realTaskTimer.start();
        } else {
            this.taskLabel.setText(desc);
            this.taskImage.setItem(taskItemID);
            this.enableCompleteTask();
        }
    }

    public void updatePercentages() {
        Integer percentage;
        if (this.plugin != null && this.taskService.completionPercentages(this.saveDataManager.getSaveData()) != null && this.plugin.getCurrentTier() != null && (percentage = this.taskService.completionPercentages(this.saveDataManager.getSaveData()).get((Object)this.plugin.getCurrentTier())) != null) {
            this.percentCompletion.setText("<col=" + this.getCompletionColor(percentage.intValue()) + ">" + percentage + "%</col> " + this.plugin.getCurrentTier().displayName + " Completed");
        }
    }

    private String getCompletionColor(double percent) {
        int max = 255;
        int amount = (int)Math.round(percent % 50.0 / 50.0 * (double)max);
        if (percent == 100.0) {
            return "00ff00";
        }
        if (percent > 50.0) {
            int redValue = max - amount;
            return String.format("%02x", redValue) + "ff00";
        }
        if (percent == 50.0) {
            return "ffff00";
        }
        return "ff" + String.format("%02x", amount) + "00";
    }

    public void disableGenerateTask() {
        this.disableGenerateTask(true);
    }

    public void disableGenerateTask(boolean enableComplete) {
        this.generateTaskBtn.setSprites(-20005);
        this.generateTaskBtn.clearActions();
        this.generateTaskBtn.addAction("Disabled", this.plugin::playFailSound);
        if (enableComplete) {
            this.enableCompleteTask();
        }
    }

    public void enableGenerateTask() {
        this.generateTaskBtn.clearActions();
        this.generateTaskBtn.setSprites(-20001, -20003);
        this.generateTaskBtn.addAction("Generate task", this.plugin::generateTask);
        this.disableCompleteTask();
    }

    public void disableCompleteTask() {
        this.completeTaskBtn.setSprites(-20004);
        this.completeTaskBtn.clearActions();
        this.completeTaskBtn.addAction("Disabled", this.plugin::playFailSound);
    }

    public void enableCompleteTask() {
        this.completeTaskBtn.clearActions();
        this.completeTaskBtn.setSprites(-20000, -20002);
        this.completeTaskBtn.addAction("Complete", this.plugin::completeTask);
    }

    public Widget getWindow() {
        return this.window;
    }
}

