/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.ui;

import com.google.gson.Gson;
import com.logmaster.LogMasterConfig;
import com.logmaster.LogMasterPlugin;
import com.logmaster.domain.Task;
import com.logmaster.domain.TaskTier;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.task.TaskService;
import com.logmaster.ui.SpriteDefinition;
import com.logmaster.ui.component.TaskDashboard;
import com.logmaster.ui.component.TaskList;
import com.logmaster.ui.generic.UIButton;
import com.logmaster.ui.generic.UICheckBox;
import com.logmaster.ui.generic.UIComponent;
import com.logmaster.ui.generic.UIGraphic;
import com.logmaster.util.FileUtils;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.SpriteOverride;

@Singleton
public class InterfaceManager {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private LogMasterConfig config;
    @Inject
    private LogMasterPlugin plugin;
    @Inject
    private TaskService taskService;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private Gson gson;
    @Inject
    private SaveDataManager saveDataManager;
    private SpriteDefinition[] spriteDefinitions;
    private TaskDashboard taskDashboard;
    private TaskList taskList;
    private UICheckBox taskDashboardCheckbox;
    private List<UIButton> tabs;
    private UIButton taskListTab;
    private UIButton taskDashboardTab;

    public void initialise() {
        this.spriteDefinitions = FileUtils.loadDefinitionResource(SpriteDefinition[].class, "SpriteDef.json", this.gson);
        this.spriteManager.addSpriteOverrides((SpriteOverride[])this.spriteDefinitions);
    }

    public void updateAfterConfigChange() {
        this.hideTabs();
        this.updateTabs();
        if (this.config.hideBelow() == TaskTier.MASTER && this.saveDataManager.getSaveData().getSelectedTier() == TaskTier.MASTER && !this.taskDashboard.isVisible()) {
            this.taskListTab.setSprites(-20010);
        }
        if (this.taskDashboard != null && this.taskDashboardCheckbox.isEnabled()) {
            this.showTabs();
            if (this.saveDataManager.getSaveData().getSelectedTier() != null && Arrays.asList(TaskTier.values()).indexOf((Object)this.saveDataManager.getSaveData().getSelectedTier()) < Arrays.asList(TaskTier.values()).indexOf((Object)this.config.hideBelow())) {
                this.activateTaskDashboard();
            }
            this.taskDashboard.updatePercentages();
        }
    }

    public void handleCollectionLogOpen() {
        Widget window = this.client.getWidget(40697857);
        Widget dashboardTabWidget = window.createChild(-1, 5);
        this.taskDashboardTab = new UIButton(dashboardTabWidget);
        this.taskDashboardTab.setSprites(-20007, -20008);
        this.taskDashboardTab.setSize(95, 21);
        this.taskDashboardTab.setPosition(10, 36);
        this.taskDashboardTab.addAction("View <col=ff9040>Dashboard</col>", this::activateTaskDashboard);
        this.taskDashboardTab.setVisibility(false);
        this.tabs = new ArrayList<UIButton>();
        int currentTabX = 110;
        for (int i = 0; i < 5; ++i) {
            Widget tabWiget = window.createChild(-1, 5);
            UIButton tab = new UIButton(tabWiget);
            tab.setSize(66, 21);
            tab.setPosition(currentTabX, 36);
            tab.setVisibility(false);
            currentTabX += 71;
            this.tabs.add(tab);
        }
        Widget tabWiget = window.createChild(-1, 5);
        this.taskListTab = new UIButton(tabWiget);
        this.taskListTab.setSize(95, 21);
        this.taskListTab.setPosition(110, 36);
        this.taskListTab.setSprites(-20009, -20010);
        this.taskListTab.setVisibility(false);
        this.taskListTab.addAction("View <col=ff9040>Task List</col>", () -> {
            this.taskDashboardTab.setSprites(-20007, -20008);
            if (this.saveDataManager.getSaveData().getSelectedTier() != TaskTier.MASTER) {
                this.taskList.goToTop();
                this.saveDataManager.getSaveData().setSelectedTier(TaskTier.MASTER);
                this.saveDataManager.save();
            }
            this.updateTabs();
            this.taskListTab.setSprites(-20010);
            this.taskDashboard.setVisibility(false);
            this.taskList.refreshTasks(0);
            this.taskList.setVisibility(true);
        });
        Widget dividerWidget = window.createChild(-1, 5);
        UIGraphic divider = new UIGraphic(dividerWidget);
        divider.setSprite(-20011);
        divider.setSize(480, 1);
        divider.setPosition(10, 56);
        this.createTaskDashboard(window);
        this.createTaskList(window);
        this.createTaskCheckbox();
        this.updateTabs();
        this.taskDashboardCheckbox.setEnabled(false);
        this.taskDashboard.setVisibility(false);
    }

    public void handleCollectionLogClose() {
        this.taskDashboard.setVisibility(false);
        this.taskList.setVisibility(false);
        this.hideTabs();
        this.taskDashboardCheckbox.setEnabled(false);
    }

    public boolean isDashboardOpen() {
        return this.taskDashboard != null && this.taskDashboard.isVisible();
    }

    public void updateTaskListBounds() {
        if (this.taskList != null) {
            this.taskList.updateBounds();
        }
    }

    public void handleMouseWheel(MouseWheelEvent event) {
        if (this.taskList != null) {
            this.taskList.handleWheel(event);
        }
    }

    public void disableGenerateTaskButton() {
        this.taskDashboard.disableGenerateTask();
    }

    private void createTaskCheckbox() {
        Widget window = this.client.getWidget(40697857);
        if (window != null) {
            Widget toggleWidget = window.createChild(-1, 5);
            Widget labelWidget = window.createChild(-1, 4);
            this.taskDashboardCheckbox = new UICheckBox(toggleWidget, labelWidget);
            this.taskDashboardCheckbox.setPosition(360, 10);
            this.taskDashboardCheckbox.setName("Task Dashboard");
            this.taskDashboardCheckbox.setEnabled(false);
            this.taskDashboardCheckbox.setText("Task Dashboard");
            labelWidget.setPos(375, 10);
            this.taskDashboardCheckbox.setToggleListener(this::toggleTaskDashboard);
        }
    }

    private void updateTabs() {
        int tabIndex = 0;
        for (TaskTier tier : TaskTier.values()) {
            if (tabIndex <= 0 && tier != this.config.hideBelow()) continue;
            if (this.tabs == null) {
                return;
            }
            if (this.saveDataManager.getSaveData().getSelectedTier() == tier && !this.taskDashboard.isVisible()) {
                this.tabs.get(tabIndex).setSprites(tier.tabSpriteHoverId);
            } else {
                this.tabs.get(tabIndex).setSprites(tier.tabSpriteId, tier.tabSpriteHoverId);
            }
            int finalTabIndex = tabIndex;
            this.tabs.get(tabIndex).clearActions();
            this.tabs.get(tabIndex).setSize(66, 21);
            this.tabs.get(tabIndex).addAction(String.format("View <col=ff9040>%s Task List</col>", tier.displayName), () -> {
                this.taskDashboardTab.setSprites(-20007, -20008);
                if (this.saveDataManager.getSaveData().getSelectedTier() != tier) {
                    this.taskList.goToTop();
                    this.saveDataManager.getSaveData().setSelectedTier(tier);
                    this.saveDataManager.save();
                }
                this.updateTabs();
                this.tabs.get(finalTabIndex).setSprites(tier.tabSpriteHoverId);
                this.taskDashboard.setVisibility(false);
                this.taskList.refreshTasks(0);
                this.taskList.setVisibility(true);
            });
            ++tabIndex;
        }
    }

    private void createTaskDashboard(Widget window) {
        this.taskDashboard = new TaskDashboard(this.plugin, this.config, window, this.taskService, this.saveDataManager);
        this.taskDashboard.setVisibility(false);
    }

    private void createTaskList(Widget window) {
        this.taskList = new TaskList(window, this.taskService, this.plugin, this.clientThread, this.saveDataManager);
        this.taskList.setVisibility(false);
    }

    private void toggleTaskDashboard(UIComponent src) {
        if (this.taskDashboard == null) {
            return;
        }
        if (this.saveDataManager.getSaveData().getActiveTaskPointer() != null) {
            this.taskDashboard.setTask(this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getDescription(), this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getItemID(), null);
            this.taskDashboard.disableGenerateTask();
        } else {
            this.plugin.nullCurrentTask();
        }
        this.client.getWidget(40697858).setHidden(this.taskDashboardCheckbox.isEnabled());
        this.client.getWidget(40697936).setHidden(this.taskDashboardCheckbox.isEnabled());
        if (this.taskDashboardCheckbox.isEnabled()) {
            this.activateTaskDashboard();
        } else {
            this.taskDashboard.setVisibility(false);
            this.taskList.setVisibility(false);
            this.hideTabs();
        }
        this.client.playSoundEffect(2266);
    }

    private void hideTabs() {
        if (this.taskDashboardTab != null) {
            this.taskDashboardTab.setVisibility(false);
        }
        if (this.tabs != null) {
            this.tabs.forEach(t -> t.setVisibility(false));
        }
        if (this.taskListTab != null) {
            this.taskListTab.setVisibility(false);
        }
    }

    private void showTabs() {
        if (this.taskDashboardTab != null) {
            this.taskDashboardTab.setVisibility(true);
        }
        if (this.config.hideBelow() == TaskTier.MASTER) {
            this.taskListTab.setVisibility(true);
        } else {
            int tabIndex = 0;
            for (TaskTier tier : TaskTier.values()) {
                if (tabIndex <= 0 && tier != this.config.hideBelow()) continue;
                this.tabs.get(tabIndex).setVisibility(true);
                ++tabIndex;
            }
        }
    }

    private void activateTaskDashboard() {
        this.taskDashboardTab.setSprites(-20008);
        this.taskList.setVisibility(false);
        this.taskDashboard.setVisibility(true);
        this.taskListTab.setSprites(-20009, -20010);
        this.updateTabs();
        this.showTabs();
    }

    public void rollTask(String description, int itemID, List<Task> tasks) {
        this.taskDashboard.setTask(description, itemID, tasks);
        this.taskDashboard.disableGenerateTask(false);
        this.taskList.refreshTasks(0);
        this.taskDashboard.updatePercentages();
    }

    public void completeTask() {
        this.taskDashboard.updatePercentages();
        this.taskList.refreshTasks(0);
    }

    public void clearCurrentTask() {
        this.taskDashboard.setTask("No task.", -1, null);
        this.taskDashboard.enableGenerateTask();
    }
}

