/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.task;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.logmaster.LogMasterConfig;
import com.logmaster.domain.SaveData;
import com.logmaster.domain.Task;
import com.logmaster.domain.TaskTier;
import com.logmaster.domain.TieredTaskList;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.task.TaskListClient;
import com.logmaster.util.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.client.callback.ClientThread;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskService.class);
    private static final String DEF_FILE_TASKS = "default-tasks.json";
    @Inject
    private Gson gson;
    @Inject
    private LogMasterConfig config;
    @Inject
    private TaskListClient taskListClient;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SaveDataManager saveDataManager;
    private TieredTaskList localList;

    public TieredTaskList getTaskList() {
        if (this.localList == null) {
            this.localList = FileUtils.loadDefinitionResource(TieredTaskList.class, DEF_FILE_TASKS, this.gson);
        }
        this.loadTaskList();
        return this.localList;
    }

    public List<Task> getForTier(TaskTier tier) {
        return this.getTaskList().getForTier(tier);
    }

    public Map<TaskTier, Integer> completionPercentages(SaveData saveData) {
        HashMap<TaskTier, Integer> completionPercentages = new HashMap<TaskTier, Integer>();
        for (TaskTier tier : TaskTier.values()) {
            completionPercentages.put(tier, (int)Math.round((double)saveData.getProgress().get((Object)tier).size() / (double)this.getTaskList().getForTier(tier).size() * 100.0));
        }
        return completionPercentages;
    }

    private void loadTaskList() {
        if (this.config.loadRemoteTaskList()) {
            this.loadRemoteTaskList();
        } else {
            this.localList = FileUtils.loadDefinitionResource(TieredTaskList.class, DEF_FILE_TASKS, this.gson);
        }
    }

    private void loadRemoteTaskList() {
        log.debug("Loading remote task list");
        try {
            this.taskListClient.getTaskList(new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    if (call == null) {
                        throw new NullPointerException("call is marked non-null but is null");
                    }
                    if (e == null) {
                        throw new NullPointerException("e is marked non-null but is null");
                    }
                    log.error("Unable to load remote task list, will defer to the default task list", (Throwable)e);
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                    if (call == null) {
                        throw new NullPointerException("call is marked non-null but is null");
                    }
                    if (response == null) {
                        throw new NullPointerException("response is marked non-null but is null");
                    }
                    JsonObject tasksJson = TaskService.this.taskListClient.processResponse(response);
                    response.close();
                    if (tasksJson == null) {
                        log.error("Loaded null remote task list, will defer to the default task list");
                        return;
                    }
                    TieredTaskList tieredTaskList = (TieredTaskList)TaskService.this.gson.fromJson((JsonElement)tasksJson, TieredTaskList.class);
                    TaskService.this.clientThread.invoke(() -> TaskService.this.replaceTaskList(tieredTaskList));
                }
            });
        }
        catch (IOException e) {
            log.error("Unable to load remote task list, will defer to the default task list");
            this.localList = FileUtils.loadDefinitionResource(TieredTaskList.class, DEF_FILE_TASKS, this.gson);
        }
    }

    private void replaceTaskList(TieredTaskList taskList) {
        this.localList = taskList;
    }
}

