/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.persistence;

import com.google.gson.reflect.TypeToken;
import com.logmaster.domain.SaveData;
import com.logmaster.domain.Task;
import com.logmaster.domain.TaskPointer;
import com.logmaster.domain.TaskTier;
import java.io.File;
import java.util.HashSet;
import java.util.Scanner;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SaveDataManager {
    private static final Logger log = LoggerFactory.getLogger(SaveDataManager.class);
    private static final String DATA_FOLDER_NAME = "generate-task";
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    private SaveData saveData;

    public SaveData getSaveData() {
        this.saveData = this.loadRLProfileSaveData();
        if (this.saveData == null) {
            SaveData localSave = this.loadLocalPlayerSaveData();
            this.saveData = localSave != null ? localSave : this.initialiseSaveData();
        }
        return this.saveData;
    }

    public void save() {
        String json = RuneLiteAPI.GSON.toJson((Object)this.saveData);
        this.configManager.setRSProfileConfiguration("log-master", "save-data", (Object)json);
    }

    public Task currentTask() {
        if (this.getSaveData().getActiveTaskPointer() == null) {
            return null;
        }
        return this.getSaveData().getActiveTaskPointer().getTask();
    }

    private SaveData loadRLProfileSaveData() {
        String saveDataJson = (String)this.configManager.getRSProfileConfiguration("log-master", "save-data", String.class);
        if (saveDataJson == null) {
            return null;
        }
        try {
            return (SaveData)RuneLiteAPI.GSON.fromJson(saveDataJson, new TypeToken<SaveData>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SaveData loadLocalPlayerSaveData() {
        File playerFolder = new File(RuneLite.RUNELITE_DIR, DATA_FOLDER_NAME);
        if (!playerFolder.exists()) {
            return null;
        }
        File playerFile = new File(playerFolder, this.client.getAccountHash() + ".txt");
        if (!playerFile.exists()) {
            return null;
        }
        try {
            String json = new Scanner(playerFile).useDelimiter("\\Z").next();
            SaveData loaded = (SaveData)RuneLiteAPI.GSON.fromJson(json, new TypeToken<SaveData>(){}.getType());
            for (TaskTier loopTier : TaskTier.values()) {
                if (loaded.getProgress().containsKey((Object)loopTier)) continue;
                loaded.getProgress().put(loopTier, new HashSet());
            }
            if (!loaded.getCompletedTasks().isEmpty()) {
                loaded.getProgress().get((Object)TaskTier.MASTER).addAll(loaded.getCompletedTasks().keySet());
            }
            if (loaded.currentTask != null) {
                TaskPointer taskPointer = new TaskPointer();
                taskPointer.setTask(loaded.currentTask);
                taskPointer.setTaskTier(TaskTier.MASTER);
                loaded.setActiveTaskPointer(taskPointer);
                loaded.currentTask = null;
            }
            return loaded;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SaveData initialiseSaveData() {
        SaveData created = new SaveData();
        for (TaskTier loopTier : TaskTier.values()) {
            if (created.getProgress().containsKey((Object)loopTier)) continue;
            created.getProgress().put(loopTier, new HashSet());
        }
        return created;
    }
}

