/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster.chat;

import com.logmaster.LogMasterPlugin;
import com.logmaster.domain.Task;
import com.logmaster.domain.TaskTier;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.task.TaskService;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.IndexedSprite;
import net.runelite.api.ItemComposition;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.ImageUtil;

@Singleton
public class ChatProcessor {
    @Inject
    private TaskService taskService;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Client client;
    @Inject
    private SaveDataManager saveDataManager;
    @Inject
    private LogMasterPlugin plugin;
    private Map<Integer, Integer> chatSpriteMap = new HashMap<Integer, Integer>();

    private void populateChatSpriteMap() {
        HashSet itemIdsToLoad = new HashSet();
        for (TaskTier tier : TaskTier.values()) {
            itemIdsToLoad.addAll(this.taskService.getForTier(tier).stream().map(Task::getItemID).collect(Collectors.toList()));
        }
        ArrayList itemIdsToLoadOrdered = new ArrayList(itemIdsToLoad);
        IndexedSprite[] modIcons = this.client.getModIcons();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + itemIdsToLoadOrdered.size());
        int modIconIdx = modIcons.length;
        for (int i = 0; i < itemIdsToLoadOrdered.size(); ++i) {
            Integer itemId = (Integer)itemIdsToLoadOrdered.get(i);
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId.intValue());
            BufferedImage image = ImageUtil.resizeImage((BufferedImage)this.itemManager.getImage(itemComposition.getId()), (int)18, (int)16);
            IndexedSprite sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
            int spriteIndex = modIconIdx + i;
            newModIcons[spriteIndex] = sprite;
            this.chatSpriteMap.put(itemId, spriteIndex);
        }
        this.client.setModIcons(newModIcons);
    }

    public void getTaskCommandData(ChatMessage chatMessage, String message) {
        Integer percentage = this.taskService.completionPercentages(this.saveDataManager.getSaveData()).get((Object)this.plugin.getCurrentTier());
        ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Progress: ").append(ChatColorType.HIGHLIGHT).append(percentage + "% " + this.plugin.getCurrentTier().displayName);
        if (this.saveDataManager.getSaveData().getActiveTaskPointer() != null) {
            chatMessageBuilder.append(ChatColorType.NORMAL).append(" Current task: ").img(this.chatSpriteMap.getOrDefault(this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getItemID(), Integer.MIN_VALUE).intValue()).append(ChatColorType.HIGHLIGHT).append(this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getDescription());
        } else {
            chatMessageBuilder.append(ChatColorType.NORMAL).append(" No current task.");
        }
        String response = chatMessageBuilder.build();
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.client.refreshChat();
    }
}

