/*
 * Decompiled with CFR 0.152.
 */
package com.logmaster;

import com.google.inject.Provides;
import com.logmaster.LogMasterConfig;
import com.logmaster.domain.Task;
import com.logmaster.domain.TaskPointer;
import com.logmaster.domain.TaskTier;
import com.logmaster.persistence.SaveDataManager;
import com.logmaster.task.TaskService;
import com.logmaster.ui.InterfaceManager;
import com.logmaster.ui.component.TaskOverlay;
import java.awt.event.MouseWheelEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Collection Log Master")
public class LogMasterPlugin
extends Plugin
implements MouseWheelListener {
    private static final Logger log = LoggerFactory.getLogger(LogMasterPlugin.class);
    private static final String TASK_CHAT_COMMAND = "!tasker";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private LogMasterConfig config;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    protected TaskOverlay taskOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private TaskService taskService;
    @Inject
    private SaveDataManager saveDataManager;
    @Inject
    private InterfaceManager interfaceManager;
    @Inject
    private ItemManager itemManager;
    private Map<Integer, Integer> chatSpriteMap = new HashMap<Integer, Integer>();
    private File playerFile;

    protected void startUp() throws Exception {
        this.mouseManager.registerMouseWheelListener((MouseWheelListener)this);
        this.interfaceManager.initialise();
        this.taskOverlay.setResizable(true);
        this.overlayManager.add((Overlay)this.taskOverlay);
        this.taskService.getTaskList();
    }

    protected void shutDown() throws Exception {
        this.mouseManager.unregisterMouseWheelListener((MouseWheelListener)this);
        this.overlayManager.remove((Overlay)this.taskOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("log-master")) {
            return;
        }
        this.interfaceManager.updateAfterConfigChange();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.saveDataManager.getSaveData();
        } else if (gameStateChanged.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.saveDataManager.save();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == 621) {
            this.interfaceManager.handleCollectionLogOpen();
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed e) {
        if (e.getGroupId() == 621) {
            this.interfaceManager.handleCollectionLogClose();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.interfaceManager.updateTaskListBounds();
    }

    public MouseWheelEvent mouseWheelMoved(MouseWheelEvent event) {
        this.interfaceManager.handleMouseWheel(event);
        return event;
    }

    public void generateTask() {
        if (this.saveDataManager.getSaveData().currentTask != null || this.taskService.getTaskList() == null) {
            this.interfaceManager.disableGenerateTaskButton();
            return;
        }
        this.client.playSoundEffect(2266);
        List<Task> uniqueTasks = this.findAvailableTasks();
        if (uniqueTasks.size() <= 0) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "No more tasks left. Looks like you win?", "");
            this.playFailSound();
            return;
        }
        int index = (int)Math.floor(Math.random() * (double)uniqueTasks.size());
        TaskPointer newTaskPointer = new TaskPointer();
        newTaskPointer.setTask(uniqueTasks.get(index));
        newTaskPointer.setTaskTier(this.getCurrentTier());
        this.saveDataManager.getSaveData().setActiveTaskPointer(newTaskPointer);
        this.saveDataManager.save();
        this.interfaceManager.rollTask(this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getDescription(), this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getItemID(), this.config.rollPastCompleted() ? this.taskService.getForTier(this.getCurrentTier()) : uniqueTasks);
        log.debug("Task generated: " + this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getDescription());
        this.saveDataManager.save();
    }

    public void completeTask() {
        this.completeTask(this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getId(), this.saveDataManager.getSaveData().getActiveTaskPointer().getTaskTier());
    }

    public void completeTask(int taskID, TaskTier tier) {
        this.client.playSoundEffect(2266);
        if (this.saveDataManager.getSaveData().getProgress().get((Object)tier).contains(taskID)) {
            this.saveDataManager.getSaveData().getProgress().get((Object)tier).remove(taskID);
        } else {
            this.addCompletedTask(taskID, tier);
            if (this.saveDataManager.getSaveData().getActiveTaskPointer() != null && taskID == this.saveDataManager.getSaveData().getActiveTaskPointer().getTask().getId()) {
                this.nullCurrentTask();
            }
        }
        this.saveDataManager.save();
        this.interfaceManager.completeTask();
    }

    public void nullCurrentTask() {
        this.saveDataManager.getSaveData().setActiveTaskPointer(null);
        this.saveDataManager.save();
        this.interfaceManager.clearCurrentTask();
    }

    public static int getCenterX(Widget window, int width) {
        return window.getWidth() / 2 - width / 2;
    }

    public static int getCenterY(Widget window, int height) {
        return window.getHeight() / 2 - height / 2;
    }

    public void addCompletedTask(int taskID, TaskTier tier) {
        this.saveDataManager.getSaveData().getProgress().get((Object)tier).add(taskID);
        this.saveDataManager.save();
    }

    public TaskTier getCurrentTier() {
        if (this.saveDataManager.getSaveData().getProgress().get((Object)TaskTier.EASY).size() < this.taskService.getTaskList().getEasy().size() && !Arrays.asList(TaskTier.MEDIUM, TaskTier.HARD, TaskTier.ELITE, TaskTier.MASTER).contains((Object)this.config.hideBelow())) {
            return TaskTier.EASY;
        }
        if (this.saveDataManager.getSaveData().getProgress().get((Object)TaskTier.MEDIUM).size() < this.taskService.getTaskList().getMedium().size() && !Arrays.asList(TaskTier.HARD, TaskTier.ELITE, TaskTier.MASTER).contains((Object)this.config.hideBelow())) {
            return TaskTier.MEDIUM;
        }
        if (this.saveDataManager.getSaveData().getProgress().get((Object)TaskTier.HARD).size() < this.taskService.getTaskList().getHard().size() && !Arrays.asList(TaskTier.ELITE, TaskTier.MASTER).contains((Object)this.config.hideBelow())) {
            return TaskTier.HARD;
        }
        if (this.saveDataManager.getSaveData().getProgress().get((Object)TaskTier.ELITE).size() < this.taskService.getTaskList().getElite().size() && TaskTier.MASTER != this.config.hideBelow()) {
            return TaskTier.ELITE;
        }
        return TaskTier.MASTER;
    }

    public TaskTier getSelectedTier() {
        return this.saveDataManager.getSaveData().getSelectedTier();
    }

    public List<Task> findAvailableTasks() {
        return this.taskService.getTaskList().getForTier(this.getCurrentTier()).stream().filter(t -> !this.saveDataManager.getSaveData().getProgress().get((Object)this.getCurrentTier()).contains(t.getId())).collect(Collectors.toList());
    }

    public void playFailSound() {
        this.client.playSoundEffect(2277);
    }

    @Provides
    LogMasterConfig provideConfig(ConfigManager configManager) {
        return (LogMasterConfig)configManager.getConfig(LogMasterConfig.class);
    }
}

