/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates.trackers;

import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.chatsuccessrates.ChatSuccessRatesTracker;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Player;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.Subscribe;

public class LightingLogs
extends ChatSuccessRatesTracker {
    private static final int IDLE = -1;
    private static final int FIREMAKING = 733;
    private static final int FIREMAKING_DURATION = 4;
    private static final int FIREMAKING_DURATION_FIRST = 3;
    private static final int FIREMAKING_CHAT_MESSAGE_OFFSET = 1;
    private static final String FIREMAKING_CHAT_MESSAGE = "The fire catches and the logs begin to burn.";
    private int lastId;
    private int lastTick;
    private int lastLevel;
    private int lastSuccesses;
    private int lastFailures;

    @Override
    public ChatSuccessRatesSkill getSkill() {
        return ChatSuccessRatesSkill.FIREMAKING;
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.client == null || this.plugin == null) {
            return;
        }
        Actor actor = event.getActor();
        Player player = this.client.getLocalPlayer();
        if (player == null || !player.equals(actor)) {
            return;
        }
        int id = actor.getAnimation();
        int tick = this.client.getTickCount();
        int lvl = this.client.getBoostedSkillLevel(this.getSkill().getSkill());
        int deltaTick = tick - this.lastTick;
        if (id == -1 && this.lastId == -1 && deltaTick == 4) {
            this.lastLevel = lvl;
            this.lastSuccesses = 1;
            this.lastFailures = 0;
        } else if (id == -1 && this.lastId == 733 && deltaTick >= 3) {
            if ((deltaTick - 3) % 4 == 0) {
                int fails = (deltaTick - 3) / 4;
                this.lastLevel = lvl;
                this.lastSuccesses = 1;
                this.lastFailures = fails;
            } else if (deltaTick % 4 == 0) {
                int fails = deltaTick / 4;
                this.lastLevel = lvl;
                this.lastSuccesses = 1;
                this.lastFailures = fails;
            }
        }
        this.lastId = id;
        this.lastTick = tick;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        int deltaTick = this.client.getTickCount() - this.lastTick;
        if (deltaTick == 1 && ChatMessageType.SPAM.equals((Object)event.getType()) && FIREMAKING_CHAT_MESSAGE.equals(event.getMessage())) {
            this.update(this.lastLevel, this.lastSuccesses, this.lastFailures);
        }
    }
}

