/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates.trackers;

import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.chatsuccessrates.ChatSuccessRatesTracker;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class FiringPottery
extends ChatSuccessRatesTracker {
    private final String item;

    private String getMessageSuccess() {
        return "You remove the " + this.item + " from the oven.";
    }

    private String getMessageFailure() {
        return "The " + this.item + " cracks in the oven.";
    }

    @Override
    public ChatSuccessRatesSkill getSkill() {
        return ChatSuccessRatesSkill.CRAFTING;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!ChatMessageType.SPAM.equals((Object)event.getType())) {
            return;
        }
        String message = event.getMessage();
        int level = this.client.getBoostedSkillLevel(this.getSkill().getSkill());
        if (this.getMessageSuccess().equals(message)) {
            this.update(level, 1, 0);
        } else if (this.getMessageFailure().equals(message)) {
            this.update(level, 0, 1);
        }
    }

    @Override
    public String getTrackerName() {
        return "Firing" + StringUtils.deleteWhitespace((String)WordUtils.capitalize((String)this.item));
    }

    public FiringPottery(String item) {
        this.item = item;
    }
}

