/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates.trackers;

import com.chatsuccessrates.ChatSuccessRatesPlugin;
import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.chatsuccessrates.ChatSuccessRatesTracker;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.eventbus.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class CatchingPetfish
extends ChatSuccessRatesTracker {
    public static final String TYPE_BLUE = "Bluefish";
    public static final String TYPE_GREEN = "Greenfish";
    public static final String TYPE_SPINE = "Spinefish";
    private final String type;

    private String getMessageSuccess(String type) {
        return "...and you catch a Tiny " + type + "!";
    }

    private Set<String> getMessagesFailure() {
        HashSet<String> failures = new HashSet<String>();
        for (String type : new String[]{TYPE_BLUE, TYPE_GREEN, TYPE_SPINE}) {
            if (type.equals(this.type)) continue;
            failures.add(this.getMessageSuccess(type));
        }
        return failures;
    }

    @Override
    public ChatSuccessRatesSkill getSkill() {
        return ChatSuccessRatesSkill.FISHING;
    }

    @Override
    public Color getColor() {
        switch (this.type) {
            default: {
                return new Color(27, 165, 227);
            }
            case "Greenfish": {
                return new Color(0, 255, 0);
            }
            case "Spinefish": 
        }
        return new Color(255, 150, 0);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        int level;
        if (!ChatSuccessRatesPlugin.COLLAPSIBLE_MESSAGETYPES.contains(event.getType())) {
            return;
        }
        String message = event.getMessage();
        int n = level = this.config != null && this.config.useBoostedLevel() ? this.client.getBoostedSkillLevel(this.getSkill().getSkill()) : this.client.getRealSkillLevel(this.getSkill().getSkill());
        if (this.getMessageSuccess(this.type).equals(message)) {
            this.update(level, 1, 0);
        } else if (this.getMessagesFailure().contains(message)) {
            this.update(level, 0, 1);
        }
    }

    @Override
    public String getTrackerName() {
        return "CatchingTiny" + StringUtils.deleteWhitespace((String)WordUtils.capitalize((String)this.type)) + "Pets";
    }

    public CatchingPetfish(String type) {
        this.type = type;
    }
}

