/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates.trackers;

import com.chatsuccessrates.ChatSuccessRatesPlugin;
import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.chatsuccessrates.ChatSuccessRatesTracker;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;

public class BendingNails
extends ChatSuccessRatesTracker {
    private static final String NAIL_SUCCESS = "You use a nail.";
    private static final String NAIL_FAILURE = "You accidentally bend a nail.";
    private final int nailType;
    private int nailQuantity = 0;
    private String message = null;
    private int messageTick;

    public BendingNails(int nailType) {
        this.nailType = nailType;
        this.updateNailQuantity();
    }

    @Override
    public ChatSuccessRatesSkill getSkill() {
        return ChatSuccessRatesSkill.CONSTRUCTION;
    }

    @Override
    public String getTrackerName() {
        String PREFIX = "Bending";
        String SUFFIX = "Nails";
        switch (this.nailType) {
            case 4819: {
                return "BendingBronzeNails";
            }
            case 4820: {
                return "BendingIronNails";
            }
            case 1539: {
                return "BendingSteelNails";
            }
            case 4821: {
                return "BendingBlackNails";
            }
            case 4822: {
                return "BendingMithrilNails";
            }
            case 4823: {
                return "BendingAdamantiteNails";
            }
            case 4824: {
                return "BendingRuneNails";
            }
        }
        return "BendingUnknownNails";
    }

    private int crystalSawBoost() {
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory != null && inventory.contains(9625)) {
            return 3;
        }
        return 0;
    }

    private int updateNailQuantity() {
        if (this.client == null) {
            return 0;
        }
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null || !inventory.contains(this.nailType)) {
            return 0;
        }
        int quantity = 0;
        for (Item item : inventory.getItems()) {
            if (item.getId() == this.nailType && (quantity = item.getQuantity()) != Integer.MAX_VALUE) break;
        }
        int diff = quantity - this.nailQuantity;
        this.nailQuantity = quantity;
        return diff;
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!ChatSuccessRatesPlugin.COLLAPSIBLE_MESSAGETYPES.contains(event.getType())) {
            return;
        }
        this.message = event.getMessage();
        this.messageTick = this.client.getTickCount();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        if (this.updateNailQuantity() <= -1 && this.messageTick == this.client.getTickCount()) {
            int level = this.client.getBoostedSkillLevel(this.getSkill().getSkill()) + this.crystalSawBoost();
            if (NAIL_SUCCESS.equals(this.message)) {
                this.update(level, 1, 0);
            } else if (NAIL_FAILURE.equals(this.message)) {
                this.update(level, 0, 1);
            }
        }
    }
}

