/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates;

import com.chatsuccessrates.ChatSuccessRatesBar;
import com.chatsuccessrates.ChatSuccessRatesConfig;
import com.chatsuccessrates.ChatSuccessRatesPlugin;
import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.SkillColor;
import org.apache.commons.lang3.StringUtils;

public abstract class ChatSuccessRatesTracker
implements Comparable<ChatSuccessRatesTracker> {
    private static final String CONFIG_DELIM = "_";
    public Client client;
    public ChatSuccessRatesConfig config;
    public ChatSuccessRatesPlugin plugin;
    private ConfigManager configManager;
    private EventBus eventBus;
    private Gson gson;
    private Map<Integer, Integer[]> levelRates = new HashMap<Integer, Integer[]>();
    private Map<Integer, ChatSuccessRatesBar> trackerBars = new HashMap<Integer, ChatSuccessRatesBar>();

    public List<ChatSuccessRatesBar> getTrackerBars() {
        ArrayList<ChatSuccessRatesBar> bars = new ArrayList<ChatSuccessRatesBar>(this.trackerBars.values());
        bars.sort(null);
        return bars;
    }

    public abstract ChatSuccessRatesSkill getSkill();

    public Color getColor() {
        return ChatSuccessRatesSkill.CUSTOM.equals((Object)this.getSkill()) ? Color.RED : SkillColor.find((Skill)this.getSkill().getSkill()).getColor();
    }

    public void register(EventBus eventBus, Client client, ChatSuccessRatesConfig config, ChatSuccessRatesPlugin plugin, ConfigManager configManager, Gson gson) {
        this.eventBus = eventBus;
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.configManager = configManager;
        this.gson = gson;
        eventBus.register((Object)this);
    }

    public void unregister() {
        this.eventBus.unregister((Object)this);
    }

    public void update(int lvl, int successes, int fails) {
        ChatSuccessRatesBar bar = this.trackerBars.get(lvl);
        if (bar == null) {
            SwingUtilities.invokeLater(() -> {
                ChatSuccessRatesBar newBar = new ChatSuccessRatesBar(lvl, this.getColor());
                this.trackerBars.put(lvl, newBar);
                newBar.update(successes, fails);
                if (this.plugin != null) {
                    this.plugin.rebuildPanel();
                }
            });
        } else {
            bar.update(successes, fails);
            if (this.plugin != null) {
                this.plugin.updatePanel();
            }
        }
        this.updateTrackerData(lvl, successes, fails);
        this.saveTrackerData();
    }

    public void updateTrackerData(int level, int successes, int failures) {
        int previousSuccesses = 0;
        int previousFailures = 0;
        if (this.levelRates.containsKey(level)) {
            Integer[] data = this.levelRates.get(level);
            previousSuccesses = data[0];
            previousFailures = data[1];
        }
        this.levelRates.put(level, new Integer[]{previousSuccesses + successes, previousFailures + failures});
    }

    public void loadTrackerData() {
        String key = this.getSkill() + CONFIG_DELIM + this.getTrackerName();
        String json = this.configManager.getConfiguration("chatsuccessrates", key);
        if (Strings.isNullOrEmpty((String)json)) {
            return;
        }
        this.levelRates = (Map)this.gson.fromJson(json, new TypeToken<Map<Integer, Integer[]>>(){}.getType());
    }

    private void saveTrackerData() {
        String key = this.getSkill() + CONFIG_DELIM + this.getTrackerName();
        if (this.levelRates == null || this.levelRates.isEmpty()) {
            this.configManager.unsetConfiguration("chatsuccessrates", key);
            return;
        }
        this.configManager.setConfiguration("chatsuccessrates", key, this.gson.toJson(this.levelRates));
    }

    public void reset() {
        this.levelRates.clear();
        this.trackerBars.clear();
        this.saveTrackerData();
        if (this.plugin != null) {
            this.plugin.rebuildPanel();
        }
    }

    public String getTrackerName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)this.getTrackerName()), (String)" ").toLowerCase());
    }

    @Override
    public int compareTo(ChatSuccessRatesTracker other) {
        return this.toString().compareTo(other.toString());
    }

    public Map<Integer, Integer[]> getLevelRates() {
        return this.levelRates;
    }

    public void setTrackerBars(Map<Integer, ChatSuccessRatesBar> trackerBars) {
        this.trackerBars = trackerBars;
    }
}

