/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates;

import com.chatsuccessrates.ChatSuccessRatesAction;
import com.chatsuccessrates.ChatSuccessRatesBar;
import com.chatsuccessrates.ChatSuccessRatesConfig;
import com.chatsuccessrates.ChatSuccessRatesPlugin;
import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.chatsuccessrates.ChatSuccessRatesTracker;
import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;

class ChatSuccessRatesPluginPanel
extends PluginPanel {
    private final JPanel successRatesPanel = new JPanel();
    private final JComboBox<ChatSuccessRatesSkill> skillSelection = new JComboBox();
    private final JComboBox<ChatSuccessRatesTracker> trackerSelection = new JComboBox();
    private final ChatSuccessRatesConfig config;
    private final ChatSuccessRatesPlugin plugin;
    private final Client client;
    private final ConfigManager configManager;
    private final Gson gson;
    private final EventBus eventBus;
    private Map<ChatSuccessRatesSkill, List<ChatSuccessRatesTracker>> trackers = new HashMap<ChatSuccessRatesSkill, List<ChatSuccessRatesTracker>>();

    public ChatSuccessRatesPluginPanel(ChatSuccessRatesConfig config, ChatSuccessRatesPlugin plugin, Client client, ConfigManager configManager, Gson gson, EventBus eventBus) {
        JLabel[] headerLabels;
        this.config = config;
        this.plugin = plugin;
        this.client = client;
        this.configManager = configManager;
        this.gson = gson;
        this.eventBus = eventBus;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel title = new JLabel("Chat Success Rates");
        title.setForeground(Color.WHITE);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setBorder(new EmptyBorder(1, 3, 10, 0));
        titlePanel.add((Component)title, "West");
        JPanel settingsPanel = new JPanel(new BorderLayout());
        settingsPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        JButton deleteButton = new JButton("Reset data");
        JButton exportButton = new JButton("Export to clipboard");
        deleteButton.setPreferredSize(new Dimension(85, 25));
        exportButton.setPreferredSize(new Dimension(128, 25));
        deleteButton.setForeground(Color.WHITE);
        exportButton.setForeground(Color.WHITE);
        deleteButton.setFont(FontManager.getRunescapeSmallFont());
        exportButton.setFont(FontManager.getRunescapeSmallFont());
        deleteButton.addActionListener(actionEvent -> {
            int confirm = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to permanently delete the data associated with this tracker?", "Warning", 2);
            if (confirm == 0) {
                if (this.trackerSelection.getSelectedItem() == null) {
                    return;
                }
                ChatSuccessRatesTracker tracker = (ChatSuccessRatesTracker)this.trackerSelection.getSelectedItem();
                tracker.reset();
            }
        });
        exportButton.addActionListener(actionEvent -> {
            if (this.trackerSelection.getSelectedItem() == null) {
                return;
            }
            ChatSuccessRatesTracker tracker = (ChatSuccessRatesTracker)this.trackerSelection.getSelectedItem();
            StringBuilder text = new StringBuilder(tracker.toString() + ":\nLevel\tSuccesses\tFailures");
            for (ChatSuccessRatesBar bar : tracker.getTrackerBars()) {
                text.append(text.length() > 0 ? "\n" : "").append(bar.toString());
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text.toString()), null);
        });
        settingsPanel.add((Component)deleteButton, "West");
        settingsPanel.add((Component)exportButton, "East");
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        for (JLabel label : headerLabels = new JLabel[]{new JLabel("Successes"), new JLabel("Level"), new JLabel("Failures")}) {
            label.setForeground(Color.WHITE);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(1);
            label.setFont(FontManager.getRunescapeSmallFont());
            label.setPreferredSize(new Dimension(225 / headerLabels.length, 10));
        }
        headerPanel.add((Component)headerLabels[0], "West");
        headerPanel.add((Component)headerLabels[1], "Center");
        headerPanel.add((Component)headerLabels[2], "East");
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 1));
        optionPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.successRatesPanel.setLayout(new BoxLayout(this.successRatesPanel, 1));
        this.successRatesPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.skillSelection.setRenderer((ListCellRenderer<ChatSuccessRatesSkill>)new ComboBoxListRenderer());
        this.trackerSelection.setRenderer((ListCellRenderer<ChatSuccessRatesTracker>)new ComboBoxListRenderer());
        this.loadTrackers();
        this.skillSelection.addActionListener(e -> {
            if (this.skillSelection.getSelectedItem() != null) {
                ChatSuccessRatesSkill skill = (ChatSuccessRatesSkill)((Object)((Object)this.skillSelection.getSelectedItem()));
                this.trackerSelection.removeAllItems();
                for (ChatSuccessRatesTracker tracker : this.trackers.get((Object)skill)) {
                    this.trackerSelection.addItem(tracker);
                }
            }
        });
        this.trackerSelection.addActionListener(e -> this.displaySelectedTracker());
        this.skillSelection.setSelectedIndex(this.skillSelection.getItemCount() > config.indexSkill() ? config.indexSkill() : 0);
        this.trackerSelection.setSelectedIndex(this.trackerSelection.getItemCount() > config.indexTracker() ? config.indexTracker() : 0);
        optionPanel.add(titlePanel);
        optionPanel.add(this.skillSelection);
        optionPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        optionPanel.add(this.trackerSelection);
        optionPanel.add(settingsPanel);
        optionPanel.add(headerPanel);
        this.add(optionPanel, "North");
        this.add(this.successRatesPanel, "Center");
    }

    private void loadTrackers() {
        ChatSuccessRatesAction[] allTrackers;
        for (ChatSuccessRatesAction action : allTrackers = ChatSuccessRatesAction.values()) {
            ChatSuccessRatesTracker tracker = action.getTracker();
            tracker.register(this.eventBus, this.client, this.config, this.plugin, this.configManager, this.gson);
            tracker.loadTrackerData();
            HashMap<Integer, ChatSuccessRatesBar> trackerBars = new HashMap<Integer, ChatSuccessRatesBar>();
            for (Map.Entry<Integer, Integer[]> levelRate : tracker.getLevelRates().entrySet()) {
                ChatSuccessRatesBar bar = new ChatSuccessRatesBar(levelRate.getKey(), tracker.getColor());
                bar.update(levelRate.getValue()[0], levelRate.getValue()[1]);
                trackerBars.put(levelRate.getKey(), bar);
            }
            tracker.setTrackerBars(trackerBars);
            List<ChatSuccessRatesTracker> skillTrackers = new ArrayList<ChatSuccessRatesTracker>();
            if (this.trackers.containsKey((Object)tracker.getSkill())) {
                skillTrackers = this.trackers.get((Object)tracker.getSkill());
            }
            skillTrackers.add(tracker);
            skillTrackers.sort(null);
            this.trackers.put(tracker.getSkill(), skillTrackers);
        }
        ArrayList<ChatSuccessRatesSkill> skills = new ArrayList<ChatSuccessRatesSkill>(this.trackers.keySet());
        skills.sort(Comparator.comparing(Enum::ordinal));
        this.skillSelection.removeAllItems();
        for (ChatSuccessRatesSkill skill : skills) {
            this.skillSelection.addItem(skill);
        }
    }

    public void displaySelectedTracker() {
        this.config.indexSkill(this.skillSelection.getSelectedIndex());
        this.config.indexTracker(this.trackerSelection.getSelectedIndex());
        if (this.trackerSelection.getSelectedItem() == null) {
            return;
        }
        ChatSuccessRatesTracker tracker = (ChatSuccessRatesTracker)this.trackerSelection.getSelectedItem();
        this.successRatesPanel.removeAll();
        for (ChatSuccessRatesBar bar : tracker.getTrackerBars()) {
            this.successRatesPanel.add(bar);
        }
        this.repaint();
        this.revalidate();
    }

    public Map<ChatSuccessRatesSkill, List<ChatSuccessRatesTracker>> getTrackers() {
        return this.trackers;
    }
}

