/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates;

import com.chatsuccessrates.ChatSuccessRatesConfig;
import com.chatsuccessrates.ChatSuccessRatesPluginPanel;
import com.chatsuccessrates.ChatSuccessRatesSkill;
import com.chatsuccessrates.ChatSuccessRatesTracker;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provides;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Chat Success Rates", description="Track and display skilling success rates", tags={"skilling", "level", "success", "failure", "rate", "tracking", "counter", "distribution"})
public class ChatSuccessRatesPlugin
extends Plugin {
    public static final Set<ChatMessageType> COLLAPSIBLE_MESSAGETYPES = ImmutableSet.of((Object)ChatMessageType.GAMEMESSAGE, (Object)ChatMessageType.SPAM);
    public static final String CONFIG_GROUP = "chatsuccessrates";
    private static final String DUPLICATE_PREFIX = " (";
    private static final String DUPLICATE_SUFFIX = ")";
    private static final String LEVEL_DELIMITER = ": ";
    private static final String COPY_TO_CLIPBOARD_OPTION = "Copy";
    private static final String COPY_TO_CLIPBOARD_TARGET = "Chat success rates";
    private final LinkedHashMap<String, Duplicate> duplicateChatCache = new LinkedHashMap<String, Duplicate>(){
        private static final int MAX_ENTRIES = 100;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Duplicate> eldest) {
            return this.size() > 100;
        }
    };
    private NavigationButton navigationButton;
    private ChatSuccessRatesPluginPanel pluginPanel;
    @Inject
    private Gson gson;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ChatSuccessRatesConfig config;

    @Provides
    ChatSuccessRatesConfig providesConfig(ConfigManager configManager) {
        return (ChatSuccessRatesConfig)configManager.getConfig(ChatSuccessRatesConfig.class);
    }

    protected void startUp() throws Exception {
        this.client.refreshChat();
        this.pluginPanel = new ChatSuccessRatesPluginPanel(this.config, this, this.client, this.configManager, this.gson, this.eventBus);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"chat_success_rates_icon.png");
        this.navigationButton = NavigationButton.builder().tooltip("Chat Success Rates").icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() throws Exception {
        for (ChatSuccessRatesSkill skill : this.pluginPanel.getTrackers().keySet()) {
            for (ChatSuccessRatesTracker tracker : this.pluginPanel.getTrackers().get((Object)skill)) {
                tracker.unregister();
            }
        }
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.pluginPanel = null;
        this.navigationButton = null;
        this.duplicateChatCache.clear();
        this.client.refreshChat();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        this.client.refreshChat();
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        boolean blockMessage;
        if (!"chatFilterCheck".equals(event.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int messageId = intStack[intStackSize - 1];
        String message = stringStack[stringStackSize - 1];
        Duplicate duplicate = this.duplicateChatCache.get(message);
        if (duplicate == null) {
            return;
        }
        boolean bl = blockMessage = messageId < duplicate.messageId;
        if (blockMessage) {
            intStack[intStackSize - 3] = 0;
        } else if (duplicate.count > 1) {
            stringStack[stringStackSize - 1] = message + DUPLICATE_PREFIX + duplicate.count + DUPLICATE_SUFFIX;
        }
    }

    @Subscribe(priority=-2.0f)
    public void onChatMessage(ChatMessage event) {
        String message = event.getMessage();
        if (this.isTrackedMessage(message, event.getType())) {
            message = this.formatMessage(message);
            event.getMessageNode().setValue(message);
            Duplicate duplicate = (Duplicate)this.duplicateChatCache.remove(message);
            if (duplicate == null) {
                duplicate = new Duplicate();
            }
            ++duplicate.count;
            duplicate.messageId = event.getMessageNode().getId();
            this.duplicateChatCache.put(message, duplicate);
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        Widget chatboxMessageLines = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGE_LINES);
        if (this.duplicateChatCache.isEmpty() || chatboxMessageLines == null || !chatboxMessageLines.getBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            return;
        }
        this.client.createMenuEntry(1).setOption(COPY_TO_CLIPBOARD_OPTION).setTarget(COPY_TO_CLIPBOARD_TARGET).setType(MenuAction.RUNELITE).onClick(e -> {
            StringSelection stringSelection = new StringSelection(this.chatSuccessRatesSummary());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        });
    }

    private String chatSuccessRatesSummary() {
        StringBuilder summary = new StringBuilder();
        for (String key : this.duplicateChatCache.keySet()) {
            summary.append(summary.length() > 0 ? "\n" : "").append(key).append(DUPLICATE_PREFIX).append(this.duplicateChatCache.get((Object)key).count).append(DUPLICATE_SUFFIX);
        }
        return summary.toString();
    }

    private boolean isTrackedMessage(String message, ChatMessageType type) {
        return COLLAPSIBLE_MESSAGETYPES.contains(type) && (!this.config.messageSuccess().isEmpty() && message.equals(this.config.messageSuccess()) || !this.config.messageFailure().isEmpty() && message.equals(this.config.messageFailure()));
    }

    private String formatMessage(String message) {
        if (this.config.addLevelPrefix()) {
            ChatSuccessRatesSkill skill = this.config.levelPrefix();
            int level = ChatSuccessRatesSkill.CUSTOM.equals((Object)skill) ? this.client.getTotalLevel() : (this.config.useBoostedLevel() ? this.client.getBoostedSkillLevel(skill.getSkill()) : this.client.getRealSkillLevel(skill.getSkill()));
            message = level + LEVEL_DELIMITER + (String)message;
        }
        return message;
    }

    public void updatePanel() {
        this.pluginPanel.repaint();
        this.pluginPanel.revalidate();
    }

    public void rebuildPanel() {
        this.pluginPanel.displaySelectedTracker();
    }

    private static class Duplicate {
        int messageId;
        int count;

        private Duplicate() {
        }
    }
}

