/*
 * Decompiled with CFR 0.152.
 */
package com.chatsuccessrates;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.components.ProgressBar;

class ChatSuccessRatesBar
extends JPanel
implements Comparable<ChatSuccessRatesBar> {
    private int successes;
    private int failures;
    private final int level;
    private final ProgressBar progressBar = new ProgressBar();

    ChatSuccessRatesBar(int level, Color color) {
        this.level = level;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.progressBar.setBackground(new Color(61, 56, 49));
        this.progressBar.setForeground(color);
        this.progressBar.setCenterLabel("" + level);
        this.updateInfo();
        this.add((Component)this.progressBar);
    }

    private void updateInfo() {
        this.progressBar.setMaximumValue(this.getTotal());
        this.progressBar.setValue(this.successes);
        this.progressBar.setLeftLabel("" + this.successes);
        this.progressBar.setRightLabel("" + this.failures);
        this.progressBar.setToolTipText("<html>Level: " + this.level + "<br>Successes: " + String.format("%.2f", this.getSuccessPercentage()) + " %<br>Failures: " + String.format("%.2f", this.getFailurePercentage()) + " %</html>");
        this.setVisible(!this.isEmpty());
    }

    private boolean isEmpty() {
        return this.getTotal() <= 0;
    }

    private int getTotal() {
        return this.successes + this.failures;
    }

    private double getSuccessPercentage() {
        return 100.0 * (double)this.successes / (double)this.getTotal();
    }

    private double getFailurePercentage() {
        return 100.0 * (double)this.failures / (double)this.getTotal();
    }

    public void update(int deltaSuccesses, int deltaFailures) {
        this.successes += deltaSuccesses;
        this.failures += deltaFailures;
        this.updateInfo();
    }

    @Override
    public String toString() {
        return this.level + "\t" + this.successes + "\t" + this.failures;
    }

    @Override
    public int compareTo(ChatSuccessRatesBar other) {
        return Integer.compare(this.level, other.level);
    }
}

