/*
 * Decompiled with CFR 0.152.
 */
package com.code.overlay;

import com.code.BoredConfig;
import com.code.BoredPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class BoredOverlay
extends Overlay {
    private final Client client;
    private final PanelComponent panelComponent = new PanelComponent();
    @Inject
    BoredConfig config;

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String overlayTitle = "Current task:";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(Color.GREEN).build());
        this.panelComponent.setPreferredSize(new Dimension(graphics.getFontMetrics().stringWidth(overlayTitle) + 200, 80));
        this.panelComponent.getChildren().add(LineComponent.builder().right(String.valueOf(BoredPanel.points.getText())).left(BoredPanel.explain.getText()).build());
        if (this.config.overlay()) {
            return this.panelComponent.render(graphics);
        }
        return null;
    }

    @Inject
    private BoredOverlay(Client client) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.client = client;
    }
}

