/*
 * Decompiled with CFR 0.152.
 */
package com.code;

import com.code.BoredConfig;
import com.code.BoredPanel;
import com.code.DefineSkill;
import com.code.SkillMap;
import com.code.overlay.BoredOverlay;
import com.google.inject.Provides;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Skills generator", description="A plug-in that gives you tasks to do. An excellent plug-in when you have nothing to do.", tags={"whattodo", "idk", "bored", "Generator", "generator", "skills", "boredom", "SKILLING", "PVM", "PKING", "training", "tasks"})
public class BoredPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BoredPlugin.class);
    public static Image ICON;
    private BoredPanel panel;
    private NavigationButton navButton;
    long preXp = 0L;
    long loginXp = 0L;
    public static long xpDrop;
    public static long counter;
    public static long toGo;
    public static String skillValue;
    public static String preTxt;
    private static GameStateChanged gameState;
    @Inject
    public Client client;
    @Inject
    SkillMap map;
    @Inject
    private BoredConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BoredOverlay overlay;
    private final HotkeyListener setGenerateListener = new HotkeyListener(() -> this.config.generateHotKey()){

        public void keyPressed(KeyEvent e) {
            if (BoredPlugin.this.config.generateHotKey().matches(e)) {
                BoredPlugin.this.panel.generateAction();
            }
        }
    };

    protected void startUp() {
        BufferedImage panelIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/img.png");
        this.panel = (BoredPanel)((Object)this.injector.getInstance(BoredPanel.class));
        ICON = new ImageIcon(panelIcon).getImage();
        this.navButton = NavigationButton.builder().tooltip("Skills Generator").icon(panelIcon).priority(4).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.overlayManager.add((Overlay)this.overlay);
        this.keyManager.registerKeyListener((KeyListener)this.setGenerateListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.config.panel()) {
            this.clientToolbar.addNavigation(this.navButton);
        } else {
            this.clientToolbar.removeNavigation(this.navButton);
        }
    }

    @Subscribe
    private void onGameTick(GameTick tick) {
        long skillExperience = this.client.getSkillExperience(DefineSkill.defineSkill(BoredPanel.text.getText()));
        this.preXp = this.loginXp;
        if (this.loginXp != 0L && skillExperience - this.preXp <= 0L) {
            return;
        }
        if (this.loginXp != 0L) {
            xpDrop = skillExperience - this.preXp;
            this.loginXp = this.preXp = skillExperience;
        } else {
            this.loginXp = this.client.getSkillExperience(DefineSkill.defineSkill(BoredPanel.text.getText()));
        }
        skillValue = BoredPanel.skillTask;
        System.out.println("prexp " + this.preXp + "\nloginxp :" + this.loginXp);
        if (this.preXp >= this.loginXp || this.preXp == -1L) {
            if (skillValue != null && xpDrop == (long)SkillMap.skillMap.get(skillValue).intValue()) {
                toGo = (long)BoredPanel.randomNumber - ++counter;
                BoredPanel.explain.setText(preTxt + "\n(you only have " + toGo + " to go!)");
            } else if (skillValue != null && SkillMap.skillMap.get(skillValue).intValue() != this.client.getSkillExperience(DefineSkill.defineSkill(BoredPanel.text.getText()))) {
                if (skillValue.equalsIgnoreCase("Wintertodt")) {
                    int winterTodtXp = 5000;
                    for (int i = 0; i < 50; ++i) {
                        if (xpDrop != (long)(winterTodtXp += 100)) continue;
                        toGo = (long)BoredPanel.randomNumber - ++counter;
                        BoredPanel.explain.setText(preTxt + "\n(you only have " + toGo + " to go!)");
                        break;
                    }
                }
                this.checkHalfXp();
            }
        }
        if (toGo == 0L) {
            this.panel.completed();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) throws Exception {
        switch (event.getGameState()) {
            case LOGGED_IN: {
                this.loginXp = this.client.getSkillExperience(DefineSkill.defineSkill(BoredPanel.text.getText()));
                this.startUp();
            }
            case HOPPING: 
            case LOGGING_IN: 
            case LOGIN_SCREEN: {
                this.loginXp = 0L;
            }
        }
    }

    private void checkHalfXp() {
        if (skillValue.equalsIgnoreCase("Copper/Tin ore") || skillValue.equalsIgnoreCase("Trout/Salmon")) {
            System.out.println("trout and salmon");
            toGo = (long)BoredPanel.randomNumber - ++counter;
            BoredPanel.explain.setText(preTxt + "\n(you only have " + toGo + " to go!)");
        }
        if (skillValue.equalsIgnoreCase("Oak logs") || skillValue.equalsIgnoreCase("Willow logs") || skillValue.equalsIgnoreCase("Fruit stalls") || skillValue.equalsIgnoreCase("Air Battlestaves") || skillValue.equalsIgnoreCase("Super Restore") || skillValue.equalsIgnoreCase("Prayer Potions") || skillValue.equalsIgnoreCase("Magic long bows") || skillValue.equalsIgnoreCase("Gold bars (at the blast furnace)")) {
            toGo = (long)(BoredPanel.randomNumber + 1) - ++counter;
            BoredPanel.explain.setText(preTxt + "\n(you only have " + toGo + " to go!)");
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.setGenerateListener);
    }

    @Provides
    BoredConfig provideConfig(ConfigManager configManager) {
        return (BoredConfig)configManager.getConfig(BoredConfig.class);
    }

    static {
        xpDrop = 0L;
        counter = 0L;
        toGo = BoredPanel.randomNumber;
        skillValue = BoredPanel.skillTask;
    }
}

