/*
 * Decompiled with CFR 0.152.
 */
package com.hotkeyablemenuswaps;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.GameEventManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;

public class GroundItemsStuff {
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private GameEventManager gameEventManager;
    @Inject
    private EventBus eventBus;
    public final Table<WorldPoint, Integer, GroundItem> collectedGroundItems = HashBasedTable.create();
    public LoadingCache<NamedQuantity, Boolean> highlightedItems;
    public LoadingCache<NamedQuantity, Boolean> hiddenItems;

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.collectedGroundItems.clear();
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        GroundItem groundItem = this.buildGroundItem(tile, item);
        GroundItem existing = (GroundItem)this.collectedGroundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (existing != null) {
            existing.setQuantity(existing.getQuantity() + groundItem.getQuantity());
        } else {
            this.collectedGroundItems.put((Object)tile.getWorldLocation(), (Object)item.getId(), (Object)groundItem);
        }
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        Tile tile = itemDespawned.getTile();
        GroundItem groundItem = (GroundItem)this.collectedGroundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (groundItem == null) {
            return;
        }
        if (groundItem.getQuantity() <= item.getQuantity()) {
            this.collectedGroundItems.remove((Object)tile.getWorldLocation(), (Object)item.getId());
        } else {
            groundItem.setQuantity(groundItem.getQuantity() - item.getQuantity());
            groundItem.setSpawnTime(null);
        }
    }

    @Subscribe
    public void onItemQuantityChanged(ItemQuantityChanged itemQuantityChanged) {
        TileItem item = itemQuantityChanged.getItem();
        Tile tile = itemQuantityChanged.getTile();
        int oldQuantity = itemQuantityChanged.getOldQuantity();
        int newQuantity = itemQuantityChanged.getNewQuantity();
        int diff = newQuantity - oldQuantity;
        GroundItem groundItem = (GroundItem)this.collectedGroundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (groundItem != null) {
            groundItem.setQuantity(groundItem.getQuantity() + diff);
        }
    }

    private GroundItem buildGroundItem(Tile tile, TileItem item) {
        int itemId = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemId;
        int alchPrice = itemComposition.getHaPrice();
        GroundItem groundItem = GroundItem.builder().id(itemId).location(tile.getWorldLocation()).itemId(realItemId).quantity(item.getQuantity()).name(itemComposition.getName()).haPrice(alchPrice).height(tile.getItemLayer().getHeight()).tradeable(itemComposition.isTradeable()).spawnTime(Instant.now()).stackable(itemComposition.isStackable()).build();
        if (realItemId == 617) {
            groundItem.setHaPrice(1);
            groundItem.setGePrice(1);
        } else {
            groundItem.setGePrice(this.itemManager.getItemPrice(realItemId));
        }
        return groundItem;
    }

    public void reloadGroundItemPluginLists(boolean highlightedList, boolean hiddenList, boolean listsChanged) {
        if (highlightedList && this.highlightedItems == null || hiddenList && this.hiddenItems == null) {
            this.gameEventManager.simulateGameEvents((Object)this);
            this.eventBus.register((Object)this);
        } else if (!highlightedList && !hiddenList) {
            this.eventBus.unregister((Object)this);
            this.collectedGroundItems.clear();
        }
        if (highlightedList) {
            if (this.highlightedItems == null || listsChanged) {
                List highlightedItemsList = Text.fromCSV((String)this.configManager.getConfiguration("grounditems", "highlightedItems"));
                this.highlightedItems = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new WildcardMatchLoader(highlightedItemsList));
            }
        } else {
            this.highlightedItems = null;
        }
        if (hiddenList) {
            if (this.hiddenItems == null || listsChanged) {
                List hiddenItemsList = Text.fromCSV((String)this.configManager.getConfiguration("grounditems", "hiddenItems"));
                this.hiddenItems = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new WildcardMatchLoader(hiddenItemsList));
            }
        } else {
            this.hiddenItems = null;
        }
    }

    static final class ItemThreshold {
        private final String itemName;
        private final int quantity;
        private final Inequality inequality;

        static ItemThreshold fromConfigEntry(String entry) {
            if (Strings.isNullOrEmpty((String)entry)) {
                return null;
            }
            Inequality operator = Inequality.MORE_THAN;
            int qty = 0;
            for (int i = entry.length() - 1; i >= 0; --i) {
                char c = entry.charAt(i);
                if (c >= '0' && c <= '9' || Character.isWhitespace(c)) continue;
                switch (c) {
                    case '<': {
                        operator = Inequality.LESS_THAN;
                    }
                    case '>': {
                        if (i + 1 >= entry.length()) break;
                        try {
                            qty = Integer.parseInt(entry.substring(i + 1).trim());
                        }
                        catch (NumberFormatException e) {
                            qty = 0;
                            operator = Inequality.MORE_THAN;
                        }
                        entry = entry.substring(0, i);
                    }
                }
                break;
            }
            return new ItemThreshold(entry.trim(), qty, operator);
        }

        boolean quantityHolds(int itemCount) {
            if (this.inequality == Inequality.LESS_THAN) {
                return itemCount < this.quantity;
            }
            return itemCount > this.quantity;
        }

        public ItemThreshold(String itemName, int quantity, Inequality inequality) {
            this.itemName = itemName;
            this.quantity = quantity;
            this.inequality = inequality;
        }

        public String getItemName() {
            return this.itemName;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public Inequality getInequality() {
            return this.inequality;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemThreshold)) {
                return false;
            }
            ItemThreshold other = (ItemThreshold)o;
            String this$itemName = this.getItemName();
            String other$itemName = other.getItemName();
            if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
                return false;
            }
            if (this.getQuantity() != other.getQuantity()) {
                return false;
            }
            Inequality this$inequality = this.getInequality();
            Inequality other$inequality = other.getInequality();
            return !(this$inequality == null ? other$inequality != null : !((Object)((Object)this$inequality)).equals((Object)other$inequality));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $itemName = this.getItemName();
            result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
            result = result * 59 + this.getQuantity();
            Inequality $inequality = this.getInequality();
            result = result * 59 + ($inequality == null ? 43 : ((Object)((Object)$inequality)).hashCode());
            return result;
        }

        public String toString() {
            return "GroundItemsStuff.ItemThreshold(itemName=" + this.getItemName() + ", quantity=" + this.getQuantity() + ", inequality=" + this.getInequality() + ")";
        }

        static enum Inequality {
            LESS_THAN,
            MORE_THAN;

        }
    }

    class WildcardMatchLoader
    extends CacheLoader<NamedQuantity, Boolean> {
        private final List<ItemThreshold> itemThresholds;

        WildcardMatchLoader(List<String> configEntries) {
            this.itemThresholds = configEntries.stream().map(ItemThreshold::fromConfigEntry).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public Boolean load(@Nonnull NamedQuantity key) {
            if (Strings.isNullOrEmpty((String)key.getName())) {
                return false;
            }
            String filteredName = key.getName().trim();
            for (ItemThreshold entry : this.itemThresholds) {
                if (!WildcardMatcher.matches((String)entry.getItemName(), (String)filteredName) || !entry.quantityHolds(key.getQuantity())) continue;
                return true;
            }
            return false;
        }
    }

    public static final class NamedQuantity {
        private final String name;
        private final int quantity;

        NamedQuantity(GroundItem groundItem) {
            this(groundItem.getName(), groundItem.getQuantity());
        }

        public String getName() {
            return this.name;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedQuantity)) {
                return false;
            }
            NamedQuantity other = (NamedQuantity)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getQuantity() == other.getQuantity();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + this.getQuantity();
            return result;
        }

        public String toString() {
            return "GroundItemsStuff.NamedQuantity(name=" + this.getName() + ", quantity=" + this.getQuantity() + ")";
        }

        public NamedQuantity(String name, int quantity) {
            this.name = name;
            this.quantity = quantity;
        }
    }

    static class GroundItem {
        private int id;
        private int itemId;
        private String name;
        private int quantity;
        private WorldPoint location;
        private int height;
        private int haPrice;
        private int gePrice;
        private int offset;
        private boolean tradeable;
        @Nullable
        private Instant spawnTime;
        private boolean stackable;

        int getHaPrice() {
            return this.haPrice * this.quantity;
        }

        int getGePrice() {
            return this.gePrice * this.quantity;
        }

        GroundItem(int id, int itemId, String name, int quantity, WorldPoint location, int height, int haPrice, int gePrice, int offset, boolean tradeable, @Nullable Instant spawnTime, boolean stackable) {
            this.id = id;
            this.itemId = itemId;
            this.name = name;
            this.quantity = quantity;
            this.location = location;
            this.height = height;
            this.haPrice = haPrice;
            this.gePrice = gePrice;
            this.offset = offset;
            this.tradeable = tradeable;
            this.spawnTime = spawnTime;
            this.stackable = stackable;
        }

        public static GroundItemBuilder builder() {
            return new GroundItemBuilder();
        }

        public int getId() {
            return this.id;
        }

        public int getItemId() {
            return this.itemId;
        }

        public String getName() {
            return this.name;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public WorldPoint getLocation() {
            return this.location;
        }

        public int getHeight() {
            return this.height;
        }

        public int getOffset() {
            return this.offset;
        }

        public boolean isTradeable() {
            return this.tradeable;
        }

        @Nullable
        public Instant getSpawnTime() {
            return this.spawnTime;
        }

        public boolean isStackable() {
            return this.stackable;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setItemId(int itemId) {
            this.itemId = itemId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        public void setLocation(WorldPoint location) {
            this.location = location;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setHaPrice(int haPrice) {
            this.haPrice = haPrice;
        }

        public void setGePrice(int gePrice) {
            this.gePrice = gePrice;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public void setTradeable(boolean tradeable) {
            this.tradeable = tradeable;
        }

        public void setSpawnTime(@Nullable Instant spawnTime) {
            this.spawnTime = spawnTime;
        }

        public void setStackable(boolean stackable) {
            this.stackable = stackable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroundItem)) {
                return false;
            }
            GroundItem other = (GroundItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getItemId() != other.getItemId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getQuantity() != other.getQuantity()) {
                return false;
            }
            WorldPoint this$location = this.getLocation();
            WorldPoint other$location = other.getLocation();
            if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getHaPrice() != other.getHaPrice()) {
                return false;
            }
            if (this.getGePrice() != other.getGePrice()) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            if (this.isTradeable() != other.isTradeable()) {
                return false;
            }
            Instant this$spawnTime = this.getSpawnTime();
            Instant other$spawnTime = other.getSpawnTime();
            if (this$spawnTime == null ? other$spawnTime != null : !((Object)this$spawnTime).equals(other$spawnTime)) {
                return false;
            }
            return this.isStackable() == other.isStackable();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroundItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            result = result * 59 + this.getItemId();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + this.getQuantity();
            WorldPoint $location = this.getLocation();
            result = result * 59 + ($location == null ? 43 : $location.hashCode());
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getHaPrice();
            result = result * 59 + this.getGePrice();
            result = result * 59 + this.getOffset();
            result = result * 59 + (this.isTradeable() ? 79 : 97);
            Instant $spawnTime = this.getSpawnTime();
            result = result * 59 + ($spawnTime == null ? 43 : ((Object)$spawnTime).hashCode());
            result = result * 59 + (this.isStackable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "GroundItemsStuff.GroundItem(id=" + this.getId() + ", itemId=" + this.getItemId() + ", name=" + this.getName() + ", quantity=" + this.getQuantity() + ", location=" + this.getLocation() + ", height=" + this.getHeight() + ", haPrice=" + this.getHaPrice() + ", gePrice=" + this.getGePrice() + ", offset=" + this.getOffset() + ", tradeable=" + this.isTradeable() + ", spawnTime=" + this.getSpawnTime() + ", stackable=" + this.isStackable() + ")";
        }

        public static class GroundItemBuilder {
            private int id;
            private int itemId;
            private String name;
            private int quantity;
            private WorldPoint location;
            private int height;
            private int haPrice;
            private int gePrice;
            private int offset;
            private boolean tradeable;
            private Instant spawnTime;
            private boolean stackable;

            GroundItemBuilder() {
            }

            public GroundItemBuilder id(int id) {
                this.id = id;
                return this;
            }

            public GroundItemBuilder itemId(int itemId) {
                this.itemId = itemId;
                return this;
            }

            public GroundItemBuilder name(String name) {
                this.name = name;
                return this;
            }

            public GroundItemBuilder quantity(int quantity) {
                this.quantity = quantity;
                return this;
            }

            public GroundItemBuilder location(WorldPoint location) {
                this.location = location;
                return this;
            }

            public GroundItemBuilder height(int height) {
                this.height = height;
                return this;
            }

            public GroundItemBuilder haPrice(int haPrice) {
                this.haPrice = haPrice;
                return this;
            }

            public GroundItemBuilder gePrice(int gePrice) {
                this.gePrice = gePrice;
                return this;
            }

            public GroundItemBuilder offset(int offset) {
                this.offset = offset;
                return this;
            }

            public GroundItemBuilder tradeable(boolean tradeable) {
                this.tradeable = tradeable;
                return this;
            }

            public GroundItemBuilder spawnTime(@Nullable Instant spawnTime) {
                this.spawnTime = spawnTime;
                return this;
            }

            public GroundItemBuilder stackable(boolean stackable) {
                this.stackable = stackable;
                return this;
            }

            public GroundItem build() {
                return new GroundItem(this.id, this.itemId, this.name, this.quantity, this.location, this.height, this.haPrice, this.gePrice, this.offset, this.tradeable, this.spawnTime, this.stackable);
            }

            public String toString() {
                return "GroundItemsStuff.GroundItem.GroundItemBuilder(id=" + this.id + ", itemId=" + this.itemId + ", name=" + this.name + ", quantity=" + this.quantity + ", location=" + this.location + ", height=" + this.height + ", haPrice=" + this.haPrice + ", gePrice=" + this.gePrice + ", offset=" + this.offset + ", tradeable=" + this.tradeable + ", spawnTime=" + this.spawnTime + ", stackable=" + this.stackable + ")";
            }
        }
    }
}

