/*
 * Decompiled with CFR 0.152.
 */
package com.hotkeyablemenuswaps;

import com.hotkeyablemenuswaps.HotkeyableMenuSwapsConfig;
import java.util.function.Function;
import net.runelite.api.MenuAction;
import net.runelite.client.config.Keybind;
import net.runelite.client.plugins.menuentryswapper.ShiftDepositMode;
import net.runelite.client.plugins.menuentryswapper.ShiftWithdrawMode;

enum BankSwapMode {
    OFF(ShiftDepositMode.OFF, ShiftWithdrawMode.OFF, config -> Keybind.NOT_SET),
    SWAP_1(ShiftDepositMode.DEPOSIT_1, ShiftWithdrawMode.WITHDRAW_1, HotkeyableMenuSwapsConfig::getBankSwap1Hotkey),
    SWAP_5(ShiftDepositMode.DEPOSIT_5, ShiftWithdrawMode.WITHDRAW_5, HotkeyableMenuSwapsConfig::getBankSwap5Hotkey),
    SWAP_10(ShiftDepositMode.DEPOSIT_10, ShiftWithdrawMode.WITHDRAW_10, HotkeyableMenuSwapsConfig::getBankSwap10Hotkey),
    SWAP_X(ShiftDepositMode.DEPOSIT_X, ShiftWithdrawMode.WITHDRAW_X, HotkeyableMenuSwapsConfig::getBankSwapXHotkey),
    SWAP_SET_X(7, 6, 5, 6, MenuAction.CC_OP_LOW_PRIORITY, 6, 5, HotkeyableMenuSwapsConfig::getBankSwapSetXHotkey),
    SWAP_ALL(ShiftDepositMode.DEPOSIT_ALL, ShiftWithdrawMode.WITHDRAW_ALL, HotkeyableMenuSwapsConfig::getBankSwapAllHotkey),
    SWAP_ALL_BUT_1(-1, -1, -1, -1, ShiftWithdrawMode.WITHDRAW_ALL_BUT_1.getMenuAction(), ShiftWithdrawMode.WITHDRAW_ALL_BUT_1.getIdentifier(), ShiftWithdrawMode.WITHDRAW_ALL_BUT_1.getIdentifierChambersStorageUnit(), HotkeyableMenuSwapsConfig::getBankSwapAllBut1Hotkey),
    SWAP_EXTRA_OP(ShiftDepositMode.EXTRA_OP.getIdentifier(), ShiftDepositMode.EXTRA_OP.getIdentifierDepositBox(), ShiftDepositMode.EXTRA_OP.getIdentifierChambersStorageUnit(), ShiftDepositMode.EXTRA_OP.getIdentifierGroupStorage(), null, -1, -1, HotkeyableMenuSwapsConfig::getBankSwapExtraOpHotkey);

    private final int depositIdentifier;
    private final int depositIdentifierDepositBox;
    private final int depositIdentifierChambersStorageUnit;
    private final int depositIdentifierGroupStorage;
    private final MenuAction withdrawMenuAction;
    private final int withdrawIdentifier;
    private final int withdrawIdentifierChambersStorageUnit;
    private final Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction;

    private BankSwapMode(ShiftDepositMode depositMode, ShiftWithdrawMode withdrawMode, Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction) {
        this.depositIdentifier = depositMode.getIdentifier();
        this.depositIdentifierDepositBox = depositMode.getIdentifierDepositBox();
        this.depositIdentifierChambersStorageUnit = depositMode.getIdentifierChambersStorageUnit();
        this.depositIdentifierGroupStorage = depositMode.getIdentifierGroupStorage();
        this.withdrawMenuAction = withdrawMode.getMenuAction();
        this.withdrawIdentifier = withdrawMode.getIdentifier();
        this.withdrawIdentifierChambersStorageUnit = withdrawMode.getIdentifierChambersStorageUnit();
        this.keybindFunction = keybindFunction;
    }

    public Keybind getKeybind(HotkeyableMenuSwapsConfig config) {
        return this.keybindFunction.apply(config);
    }

    public int getDepositIdentifier() {
        return this.depositIdentifier;
    }

    public int getDepositIdentifierDepositBox() {
        return this.depositIdentifierDepositBox;
    }

    public int getDepositIdentifierChambersStorageUnit() {
        return this.depositIdentifierChambersStorageUnit;
    }

    public int getDepositIdentifierGroupStorage() {
        return this.depositIdentifierGroupStorage;
    }

    public MenuAction getWithdrawMenuAction() {
        return this.withdrawMenuAction;
    }

    public int getWithdrawIdentifier() {
        return this.withdrawIdentifier;
    }

    public int getWithdrawIdentifierChambersStorageUnit() {
        return this.withdrawIdentifierChambersStorageUnit;
    }

    public Function<HotkeyableMenuSwapsConfig, Keybind> getKeybindFunction() {
        return this.keybindFunction;
    }

    private BankSwapMode(int depositIdentifier, int depositIdentifierDepositBox, int depositIdentifierChambersStorageUnit, int depositIdentifierGroupStorage, MenuAction withdrawMenuAction, int withdrawIdentifier, int withdrawIdentifierChambersStorageUnit, Function<HotkeyableMenuSwapsConfig, Keybind> keybindFunction) {
        this.depositIdentifier = depositIdentifier;
        this.depositIdentifierDepositBox = depositIdentifierDepositBox;
        this.depositIdentifierChambersStorageUnit = depositIdentifierChambersStorageUnit;
        this.depositIdentifierGroupStorage = depositIdentifierGroupStorage;
        this.withdrawMenuAction = withdrawMenuAction;
        this.withdrawIdentifier = withdrawIdentifier;
        this.withdrawIdentifierChambersStorageUnit = withdrawIdentifierChambersStorageUnit;
        this.keybindFunction = keybindFunction;
    }
}

