/*
 * Decompiled with CFR 0.152.
 */
package com.healthnotifications;

import com.google.inject.Provides;
import com.healthnotifications.HealthNotificationsConfig;
import com.healthnotifications.HealthNotificationsOverlay;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Health Notifications", description="Visual Notifications for Health", tags={"health", "hitpoints", "hp", "notifications"})
public class HealthNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HealthNotificationsPlugin.class);
    private boolean shouldNotifyHitpoints = true;
    private boolean shouldNotifyPrayer = true;
    @Inject
    private Client client;
    @Inject
    private HealthNotificationsConfig config;
    @Inject
    private HealthNotificationsOverlay hitpointOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Notifier notifier;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.hitpointOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.hitpointOverlay);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.isClientReady()) {
            return;
        }
        if (!this.config.disableHitpointNotifications()) {
            if (this.shouldNotifyHitpoints && this.hitpointTotalBelowThreshold()) {
                this.notifier.notify("Your hitpoints are below " + this.config.getHitpointThreshold());
                this.shouldNotifyHitpoints = false;
            } else if (!this.hitpointTotalBelowThreshold()) {
                this.shouldNotifyHitpoints = true;
            }
        }
        if (!this.config.disablePrayerNotifications()) {
            if (this.shouldNotifyPrayer && this.prayerTotalBelowThreshold()) {
                this.notifier.notify("Your prayer points are below " + this.config.getPrayerThreshold());
                this.shouldNotifyPrayer = false;
            } else if (!this.hitpointTotalBelowThreshold()) {
                this.shouldNotifyPrayer = true;
            }
        }
    }

    @Provides
    HealthNotificationsConfig provideConfig(ConfigManager configManager) {
        return (HealthNotificationsConfig)configManager.getConfig(HealthNotificationsConfig.class);
    }

    public boolean shouldRenderOverlay() {
        if (!this.isClientReady()) {
            return false;
        }
        if (!this.config.disableComboOverlay() && this.hitpointTotalBelowThreshold() && this.prayerTotalBelowThreshold()) {
            return true;
        }
        if (!this.config.disableHitpointOverlay() && this.hitpointTotalBelowThreshold()) {
            return true;
        }
        return !this.config.disablePrayerOverlay() && this.prayerTotalBelowThreshold();
    }

    public Color getOverlayColor() {
        if (!this.config.disableComboOverlay() && this.hitpointTotalBelowThreshold() && this.prayerTotalBelowThreshold()) {
            return this.config.getComboOverlayColor();
        }
        if (!this.config.disableHitpointOverlay() && this.hitpointTotalBelowThreshold()) {
            return this.config.getHitpointOverlayColor();
        }
        if (!this.config.disablePrayerOverlay() && this.prayerTotalBelowThreshold()) {
            return this.config.getPrayerOverlayColor();
        }
        return new Color(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public boolean hitpointTotalBelowThreshold() {
        return this.isClientReady() && this.client.getBoostedSkillLevel(Skill.HITPOINTS) < this.config.getHitpointThreshold();
    }

    public boolean prayerTotalBelowThreshold() {
        return this.isClientReady() && this.client.getBoostedSkillLevel(Skill.PRAYER) < this.config.getPrayerThreshold();
    }

    public boolean isClientReady() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null;
    }
}

