/*
 * Decompiled with CFR 0.152.
 */
package com.healthnotifications;

import com.healthnotifications.HealthNotificationsConfig;
import com.healthnotifications.HealthNotificationsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class HealthNotificationsOverlay
extends Overlay {
    private final Client client;
    private final HealthNotificationsPlugin plugin;
    private final HealthNotificationsConfig config;

    @Inject
    private HealthNotificationsOverlay(Client client, HealthNotificationsPlugin plugin, HealthNotificationsConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.shouldRenderOverlay()) {
            Color color = graphics.getColor();
            graphics.setColor(this.plugin.getOverlayColor());
            graphics.fill(new Rectangle(this.client.getCanvas().getSize()));
            graphics.setColor(color);
        }
        return null;
    }
}

