/*
 * Decompiled with CFR 0.152.
 */
package com.ClanFightPerformanceTracker;

import com.ClanFightPerformanceTracker.ClanFightPerformanceTrackerConfig;
import com.ClanFightPerformanceTracker.ClanFightPerformanceTrackerPlugin;
import com.google.inject.Inject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.LineComponent;

public class PerformanceOverlay
extends OverlayPanel {
    private static final DecimalFormat DPS_FORMAT = new DecimalFormat("#0.0");
    private final ClanFightPerformanceTrackerPlugin plugin;
    private final ClanFightPerformanceTrackerConfig config;
    private final Client client;

    @Inject
    private PerformanceOverlay(ClanFightPerformanceTrackerPlugin plugin, ClanFightPerformanceTrackerConfig config, Client client) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.setPriority(OverlayPriority.LOW);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.panelComponent.setWrap(true);
        this.panelComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Performance overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showDPS()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("DPS:").right(DPS_FORMAT.format(this.plugin.getUserDPS().getDps())).build());
        }
        if (this.config.showDamageDealt()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Damage Dealt:").right(String.valueOf(this.plugin.getUserDPS().getDamage())).build());
        }
        if (this.config.showDamageTaken()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Damage Taken:").right(String.valueOf(this.plugin.getDamageTaken())).build());
        }
        if (this.config.showKDR()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Kills: " + this.plugin.getKillCount()).right(" Deaths: " + this.plugin.getDeaths()).build());
        }
        if (this.config.showSnares() && this.plugin.isRegularSpellbook()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Snares: ").right(this.plugin.getSuccessfulSnares() + " / " + this.plugin.getSnares()).build());
        }
        if (this.config.showTankTime()) {
            if (this.plugin.tanking) {
                String tankTime = String.valueOf(this.plugin.getTimer(this.plugin.tankStartTime));
                this.panelComponent.getChildren().add(LineComponent.builder().left("Avg tank: ").right(this.plugin.getAverageTankTime() + "(" + tankTime + ")").build());
            } else {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Avg tank: ").right(this.plugin.getAverageTankTime() + " (" + this.plugin.lastTankTime + ")").build());
            }
        }
        if (this.config.showReturnTime()) {
            if (this.plugin.returning) {
                String returnTime = String.valueOf(this.plugin.getTimer(this.plugin.returnStartTime));
                this.panelComponent.getChildren().add(LineComponent.builder().left("Avg return: ").right(this.plugin.getAverageReturnTime() + "(" + returnTime + ")").build());
            } else {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Avg return: ").right(this.plugin.getAverageReturnTime() + " (" + this.plugin.lastReturnTime + ")").build());
            }
        }
        if (this.config.showMaxHits()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Max hits: ").right(String.valueOf(this.plugin.getMaxHits())).build());
        }
        return super.render(graphics);
    }
}

