/*
 * Decompiled with CFR 0.152.
 */
package com.ClanFightPerformanceTracker;

import com.ClanFightPerformanceTracker.ClanFightPerformanceTrackerConfig;
import com.ClanFightPerformanceTracker.DpsMember;
import com.ClanFightPerformanceTracker.PerformanceOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Hitsplat;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Clan Fight Performance Tracker")
public class ClanFightPerformanceTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ClanFightPerformanceTrackerPlugin.class);
    private static final DecimalFormat DPS_FORMAT = new DecimalFormat("#0.0");
    private final DpsMember userDPS = new DpsMember("user");
    boolean returning = false;
    boolean tanking = false;
    boolean shouldStartDPS = false;
    ArrayList<String> killMessages = new ArrayList<String>(Arrays.asList("thinking challenging you", "was no match for you.", "didn't stand a chance against you.", "What an embarrassing performance by", "A humiliating defeat for", "You were clearly a better fighter than", "RIP ", "Can anyone defeat you? Certainly not ", "You have defeated ", "A certain crouching-over-face animation would be suitable for", "were an orange, you'd be the juicer", "was no match for your awesome awesomeness", "With a crushing blow you finish", "falls before your might", "You have stomped", "You have cleaned the floor", "nuff said", "Be proud of yourself", "into tiny pieces and sat on them"));
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PerformanceOverlay overlay;
    @Inject
    private ClanFightPerformanceTrackerConfig config;
    private Integer lootKills = 0;
    private Integer startingKills = 0;
    private Integer endingKills = 0;
    private int chatMessageKDR = 0;
    private boolean usingRSKDR = true;
    private boolean startingSet = false;
    private Integer deaths = 0;
    private Integer damageTaken = 0;
    long tankStartTime = 0L;
    String lastTankTime = "NA";
    private List<Integer> tankTimes = new LinkedList<Integer>();
    private int hitsplatCount = 0;
    private int tankStartTick = 0;
    private int interactingCount = 0;
    private String averageTankTime = "NA";
    private List<Integer> returnTimes = new LinkedList<Integer>();
    long returnStartTime = 0L;
    String lastReturnTime = "NA";
    private int returnStartTick = 0;
    private String averageReturnTime = "NA";
    private int maxHits = 0;
    private int snareTick = 0;
    private int snares = 0;
    private int successfulSnares = 0;
    private final Map<Skill, Integer> previousSkillExpTable = new EnumMap<Skill, Integer>(Skill.class);
    private static final Set<Integer> CLAN_WARS_ARENAS = ImmutableSet.of((Object)13130, (Object)13131, (Object)13386, (Object)13387, (Object)12621, (Object)12622, (Object[])new Integer[]{12623, 13647, 13646, 13645, 13644, 13133, 13134, 13135, 13643, 13642, 13641, 13898});

    @Provides
    ClanFightPerformanceTrackerConfig provideConfig(ConfigManager configManager) {
        return (ClanFightPerformanceTrackerConfig)configManager.getConfig(ClanFightPerformanceTrackerConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.reset();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    public void reset() {
        this.lootKills = 0;
        this.endingKills = this.startingKills = this.endingKills;
        this.startingSet = false;
        this.chatMessageKDR = 0;
        this.deaths = 0;
        this.damageTaken = 0;
        this.tankStartTime = 0L;
        this.lastTankTime = "NA";
        this.tankTimes.clear();
        this.hitsplatCount = 0;
        this.tankStartTick = 0;
        this.averageTankTime = "NA";
        this.returnTimes.clear();
        this.returnStartTime = 0L;
        this.lastReturnTime = "NA";
        this.returnStartTick = 0;
        this.averageReturnTime = "NA";
        this.maxHits = 0;
        this.snareTick = 0;
        this.snares = 0;
        this.successfulSnares = 0;
        this.userDPS.reset();
        this.returning = false;
        this.tanking = false;
        this.shouldStartDPS = false;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Actor actor = hitsplatApplied.getActor();
        if (!(actor instanceof Player)) {
            return;
        }
        if (actor == this.client.getLocalPlayer()) {
            if (!this.client.getWorldType().contains(WorldType.PVP) && this.client.getVarbitValue(5963) == 0 && !this.isAtCWA()) {
                return;
            }
            if (this.client.getVarbitValue(4605) == 0) {
                return;
            }
            this.damageTaken = this.damageTaken + hitsplatApplied.getHitsplat().getAmount();
            ++this.hitsplatCount;
            if (this.hitsplatCount >= 4 && this.tankStartTick == 0 && this.interactingCount >= 3) {
                this.tankStartTick = this.client.getTickCount();
                this.tankStartTime = System.currentTimeMillis();
                this.tanking = true;
            } else if (this.hitsplatCount < 4) {
                this.tankStartTick = 0;
                this.tanking = false;
            }
            return;
        }
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (hitsplat.isMine()) {
            if (hitsplat.getHitsplatType() == 43) {
                ++this.maxHits;
            }
            this.shouldStartDPS = true;
            int hit = hitsplat.getAmount();
            this.userDPS.addDamage(hit);
            if (this.userDPS.isPaused()) {
                this.userDPS.unpause();
            }
            if (this.snareTick != 0 && hit < 3 && this.client.getTickCount() < this.snareTick + 5 && this.isRegularSpellbook()) {
                ++this.snares;
                ++this.successfulSnares;
                this.snareTick = 0;
            } else if (this.snareTick != 0 && hit > 2) {
                this.snareTick = 0;
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        if (interactingChanged.getTarget() == this.client.getLocalPlayer() && interactingChanged.getSource() instanceof Player) {
            ++this.interactingCount;
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        int xpChange;
        Skill skill = statChanged.getSkill();
        int xp = statChanged.getXp();
        Integer previous = this.previousSkillExpTable.put(skill, xp);
        if (skill == Skill.MAGIC && 59 < (xpChange = xp - previous) && xpChange < 66 && this.isRegularSpellbook()) {
            this.snareTick = this.client.getTickCount();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        for (String s : this.killMessages) {
            if (!event.getMessage().contains(s)) continue;
            ++this.chatMessageKDR;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        int hp = this.client.getLocalPlayer().getHealthRatio();
        if (hp == -1) {
            this.hitsplatCount = 0;
            this.interactingCount = 0;
            if (this.tankStartTick != 0) {
                int tankTime = this.client.getTickCount() - this.tankStartTick;
                this.lastTankTime = String.valueOf(this.getTimer(this.tankStartTime));
                this.tankTimes.add(tankTime);
                this.averageTankTime = this.calcAverageTankTime();
            }
            this.tankStartTick = 0;
            this.tanking = false;
        }
        if (this.snareTick != 0 && this.client.getTickCount() == this.snareTick + 4 && this.isRegularSpellbook()) {
            ++this.snares;
            this.snareTick = 0;
        }
        if (this.usingRSKDR && this.client.getVarbitValue(8376) != 0) {
            this.endingKills = this.client.getVarbitValue(8376);
        }
        if (this.usingRSKDR && !this.startingSet && this.client.getVarbitValue(8376) != 0 && this.startingKills == 0) {
            this.startingKills = this.client.getVarbitValue(8376);
            this.startingSet = true;
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarbitId() == 8376 && this.startingKills == 0 && this.usingRSKDR && this.client.getVarbitValue(8376) != 0) {
            this.startingKills = this.client.getVarbitValue(8376);
        }
        if (event.getVarbitId() == 4143) {
            this.usingRSKDR = this.client.getVarbitValue(4143) != 0 && !this.nonRegularWorld(this.client.getWorldType());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if ((this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getGameState() == GameState.CONNECTION_LOST || this.client.getGameState() == GameState.HOPPING) && this.shouldStartDPS) {
            this.userDPS.pause();
        }
        this.usingRSKDR = (this.client.getGameState() != GameState.LOGGED_IN || this.client.getVarbitValue(4143) != 0) && !this.nonRegularWorld(this.client.getWorldType());
    }

    public boolean isRegularSpellbook() {
        return this.client.getVarbitValue(4070) == 0;
    }

    private boolean nonRegularWorld(EnumSet<WorldType> worldType) {
        return worldType.contains(WorldType.PVP) || worldType.contains(WorldType.BOUNTY) || worldType.contains(WorldType.HIGH_RISK) || worldType.contains(WorldType.DEADMAN) || worldType.contains(WorldType.SEASONAL) || worldType.contains(WorldType.TOURNAMENT_WORLD);
    }

    public boolean isAtCWA() {
        int[] mapRegions = this.client.getMapRegions();
        for (int region : CLAN_WARS_ARENAS) {
            if (!ArrayUtils.contains((int[])mapRegions, (int)region)) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        if (playerLootReceived.getPlayer().isClanMember() || playerLootReceived.getPlayer().isFriendsChatMember()) {
            return;
        }
        Integer n = this.lootKills;
        Integer n2 = this.lootKills = Integer.valueOf(this.lootKills + 1);
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Actor actor = actorDeath.getActor();
        if (actor == this.client.getLocalPlayer()) {
            if (this.returnStartTick != 0 && this.client.getTickCount() <= this.returnStartTick + 10) {
                return;
            }
            if (this.tankStartTick != 0) {
                int tankTime = this.client.getTickCount() - this.tankStartTick;
                this.lastTankTime = String.valueOf(this.getTimer(this.tankStartTime));
                this.tankTimes.add(tankTime);
                this.averageTankTime = this.calcAverageTankTime();
            }
            Integer n = this.deaths;
            Integer n2 = this.deaths = Integer.valueOf(this.deaths + 1);
            this.returnStartTick = this.client.getTickCount();
            this.returnStartTime = System.currentTimeMillis();
            this.returning = true;
            this.tanking = false;
            this.hitsplatCount = 0;
            this.tankStartTick = 0;
            this.userDPS.pause();
        }
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned playerSpawned) {
        int localClanMembersCount = 0;
        if (this.returning && this.client.getTickCount() > this.returnStartTick + 9) {
            if (!this.client.getWorldType().contains(WorldType.PVP) && this.client.getVarbitValue(5963) == 0) {
                return;
            }
            if (this.client.getWorldType().contains(WorldType.PVP) && this.client.getVarbitValue(4605) == 0) {
                return;
            }
            for (Player player : this.client.getPlayers()) {
                if (player.isFriendsChatMember() || player.isClanMember()) {
                    ++localClanMembersCount;
                }
                if (localClanMembersCount <= 10) continue;
                this.returning = false;
                int returnTime = this.client.getTickCount() - this.returnStartTick;
                this.lastReturnTime = String.valueOf(this.getTimer(this.returnStartTime));
                this.returnTimes.add(returnTime);
                this.averageReturnTime = this.calcAverageReturnTime();
                return;
            }
        }
    }

    String calcAverageTankTime() {
        int totalTankTime = 0;
        for (Integer tankTime : this.tankTimes) {
            totalTankTime += tankTime.intValue();
        }
        return DPS_FORMAT.format((double)(totalTankTime / this.tankTimes.size()) * 0.6) + "s";
    }

    String calcAverageReturnTime() {
        int totalReturnTime = 0;
        for (Integer returnTime : this.returnTimes) {
            totalReturnTime += returnTime.intValue();
        }
        return DPS_FORMAT.format((double)(totalReturnTime / this.returnTimes.size()) * 0.6) + "s";
    }

    int getKillCount() {
        if (this.usingRSKDR) {
            return this.endingKills - this.startingKills;
        }
        if (this.chatMessageKDR != 0) {
            return this.chatMessageKDR;
        }
        return this.lootKills;
    }

    int getTimer(long startTime) {
        return (int)((System.currentTimeMillis() - startTime) / 1000L);
    }

    DpsMember getUserDPS() {
        return this.userDPS;
    }

    Integer getDeaths() {
        return this.deaths;
    }

    Integer getDamageTaken() {
        return this.damageTaken;
    }

    String getAverageTankTime() {
        return this.averageTankTime;
    }

    String getAverageReturnTime() {
        return this.averageReturnTime;
    }

    int getMaxHits() {
        return this.maxHits;
    }

    int getSnares() {
        return this.snares;
    }

    int getSuccessfulSnares() {
        return this.successfulSnares;
    }
}

