/*
 * Decompiled with CFR 0.152.
 */
package fking.work.vmtracker;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Volcanic Mine Stability Tracker", description="Tracks the mine stability changes and displays them on the hud.")
public class VolcanicMineTrackerPlugin
extends Plugin {
    private static final int VARBIT_STABILITY = 5938;
    private static final int VARBIT_GAME_STATE = 5941;
    private static final int PROC_VOLCANIC_MINE_SET_OTHERINFO = 2022;
    private static final int HUD_COMPONENT = 611;
    private static final int HUD_STABILITY_COMPONENT = 11;
    private static final int GAME_STATE_IN_LOBBY = 1;
    private static final int GAME_STATE_IN_GAME = 2;
    private static final int STARTING_STABILITY = 50;
    private static final int STABILITY_CHANGE_HISTORY_SIZE = 2;
    private final int[] stabilityChangeHistory = new int[2];
    @Inject
    private Client client;
    private int changeHistorySize = 0;
    private int lastMineStability;

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 2022) {
            return;
        }
        int gameState = this.client.getVarbitValue(5941);
        if (gameState == 1) {
            this.lastMineStability = 50;
            this.changeHistorySize = 0;
        }
        int stability = this.client.getVarbitValue(5938);
        int delta = stability - this.lastMineStability;
        this.lastMineStability = stability;
        if (delta != 0) {
            this.pushStabilityChangeHistory(delta);
        }
        this.updateHudText();
    }

    private void updateHudText() {
        if (this.changeHistorySize <= 0) {
            return;
        }
        Widget widget = this.client.getWidget(611, 11);
        if (widget != null) {
            Object text = widget.getText();
            text = (String)text + " (" + this.buildStabilityHistoryText() + ")";
            widget.setText((String)text);
        }
    }

    private String buildStabilityHistoryText() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.changeHistorySize; ++i) {
            int delta = this.stabilityChangeHistory[i];
            if (delta >= 0) {
                builder.append("<col=00ff00>").append(delta).append("</col>");
            } else {
                builder.append("<col=ff0000>").append(delta).append("</col>");
            }
            if (i == this.changeHistorySize - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private void pushStabilityChangeHistory(int delta) {
        System.arraycopy(this.stabilityChangeHistory, 0, this.stabilityChangeHistory, 1, this.stabilityChangeHistory.length - 1);
        this.stabilityChangeHistory[0] = delta;
        if (this.changeHistorySize < 2) {
            ++this.changeHistorySize;
        }
    }
}

