/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.RainbowRaveConfig;
import java.awt.Color;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowRaveTileIndicatorsPlugin {
    private static final Logger log = LoggerFactory.getLogger(RainbowRaveTileIndicatorsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private RainbowRaveConfig rainbowRaveConfig;
    private WorldPoint lastPlayerPosition = new WorldPoint(0, 0, 0);
    private int lastTickPlayerMoved = 0;
    private long lastTimePlayerStoppedMoving = 0L;
    boolean recolorFill;
    boolean highlightDestinationTile;
    Color highlightDestinationColor;
    Color destinationTileFillColor;
    double destinationTileBorderWidth;
    boolean highlightHoveredTile;
    Color highlightHoveredColor;
    Color hoveredTileFillColor;
    double hoveredTileBorderWidth;
    boolean highlightCurrentTile;
    Color highlightCurrentColor;
    Color currentTileFillColor;
    double currentTileBorderWidth;
    boolean trueTileFadeout;
    int trueTileFadeoutTime;
    boolean destinationTileCornersOnly;
    boolean hoveredTileCornersOnly;
    boolean currentTileCornersOnly;
    int hoveredTileCornerSize;
    int destinationTileCornerSize;
    int currentTileCornerSize;

    protected void startUp() {
        this.loadConfig();
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.loadConfig();
    }

    protected void shutDown() {
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (e.getGroup().equals("cornertileindicators") || e.getGroup().equals("tileindicators") || e.getGroup().equals("rainbow_rave")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        boolean cornerTileIndicatorsInstalled = this.configManager.getConfiguration("runelite", "externalPlugins").contains("corner-tile-indicators");
        String group = cornerTileIndicatorsInstalled && this.rainbowRaveConfig.preferCornerTileIndicatorsConfig() ? "cornertileindicators" : "tileindicators";
        this.recolorFill = this.rainbowRaveConfig.recolorTileIndicatorFill();
        this.highlightDestinationTile = (Boolean)this.configManager.getConfiguration(group, "highlightDestinationTile", Boolean.TYPE);
        this.highlightDestinationColor = (Color)this.configManager.getConfiguration(group, "highlightDestinationColor", Color.class);
        this.destinationTileFillColor = (Color)this.configManager.getConfiguration(group, "destinationTileFillColor", Color.class);
        this.destinationTileBorderWidth = (Double)this.configManager.getConfiguration(group, "destinationTileBorderWidth", Double.TYPE);
        this.highlightHoveredTile = (Boolean)this.configManager.getConfiguration(group, "highlightHoveredTile", Boolean.TYPE);
        this.highlightHoveredColor = (Color)this.configManager.getConfiguration(group, "highlightHoveredColor", Color.class);
        this.hoveredTileFillColor = (Color)this.configManager.getConfiguration(group, "hoveredTileFillColor", Color.class);
        this.hoveredTileBorderWidth = (Double)this.configManager.getConfiguration(group, "hoveredTileBorderWidth", Double.TYPE);
        this.highlightCurrentTile = (Boolean)this.configManager.getConfiguration(group, "highlightCurrentTile", Boolean.TYPE);
        this.highlightCurrentColor = (Color)this.configManager.getConfiguration(group, "highlightCurrentColor", Color.class);
        this.currentTileFillColor = (Color)this.configManager.getConfiguration(group, "currentTileFillColor", Color.class);
        this.currentTileBorderWidth = (Double)this.configManager.getConfiguration(group, "currentTileBorderWidth", Double.TYPE);
        if ("cornertileindicators".equals(group)) {
            this.trueTileFadeout = (Boolean)this.configManager.getConfiguration(group, "trueTileFadeout", Boolean.TYPE);
            this.trueTileFadeoutTime = (Integer)this.configManager.getConfiguration(group, "trueTileFadeoutTime", Integer.TYPE);
            this.destinationTileCornersOnly = (Boolean)this.configManager.getConfiguration(group, "destinationTileCornersOnly", Boolean.TYPE);
            this.hoveredTileCornersOnly = (Boolean)this.configManager.getConfiguration(group, "hoveredTileCornersOnly", Boolean.TYPE);
            this.currentTileCornersOnly = (Boolean)this.configManager.getConfiguration(group, "currentTileCornersOnly", Boolean.TYPE);
            this.hoveredTileCornerSize = (Integer)this.configManager.getConfiguration(group, "hoveredTileCornerSize", Integer.TYPE);
            this.destinationTileCornerSize = (Integer)this.configManager.getConfiguration(group, "destinationTileCornerSize", Integer.TYPE);
            this.currentTileCornerSize = (Integer)this.configManager.getConfiguration(group, "currentTileCornerSize", Integer.TYPE);
        } else {
            this.trueTileFadeout = false;
            this.destinationTileCornersOnly = false;
            this.hoveredTileCornersOnly = false;
            this.currentTileCornersOnly = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
        if (!playerPos.equals((Object)this.lastPlayerPosition)) {
            this.lastTickPlayerMoved = this.client.getTickCount();
        } else if (this.lastTickPlayerMoved + 1 == this.client.getTickCount()) {
            this.lastTimePlayerStoppedMoving = System.currentTimeMillis();
        }
        this.lastPlayerPosition = playerPos;
    }

    public WorldPoint getLastPlayerPosition() {
        return this.lastPlayerPosition;
    }

    public int getLastTickPlayerMoved() {
        return this.lastTickPlayerMoved;
    }

    public long getLastTimePlayerStoppedMoving() {
        return this.lastTimePlayerStoppedMoving;
    }
}

