/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.RainbowRavePlugin;
import com.rainbowrave.RainbowRaveTileIndicatorsPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

public class RainbowRaveTileIndicatorsOverlay
extends Overlay {
    private final Client client;
    private final RainbowRaveTileIndicatorsPlugin plugin;
    private final RainbowRavePlugin rainbowRavePlugin;

    public RainbowRaveTileIndicatorsOverlay(Client client, RainbowRaveTileIndicatorsPlugin plugin, RainbowRavePlugin rainbowRavePlugin) {
        this.client = client;
        this.plugin = plugin;
        this.rainbowRavePlugin = rainbowRavePlugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.highlightHoveredTile && this.client.getSelectedSceneTile() != null) {
            this.renderTile(graphics, this.client.getSelectedSceneTile().getLocalLocation(), this.plugin.highlightHoveredColor, this.plugin.hoveredTileBorderWidth, this.plugin.hoveredTileFillColor, this.plugin.hoveredTileCornersOnly, this.plugin.hoveredTileCornerSize);
        }
        if (this.plugin.highlightDestinationTile) {
            this.renderTile(graphics, this.client.getLocalDestinationLocation(), this.plugin.highlightDestinationColor, this.plugin.destinationTileBorderWidth, this.plugin.destinationTileFillColor, this.plugin.destinationTileCornersOnly, this.plugin.destinationTileCornerSize);
        }
        if (this.plugin.highlightCurrentTile) {
            Color fillColor;
            LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.plugin.getLastPlayerPosition());
            if (playerPosLocal == null) {
                return null;
            }
            Color rainbowColor = this.rainbowRavePlugin.getColor(0);
            Color color = ColorUtil.colorWithAlpha((Color)rainbowColor, (int)this.plugin.highlightCurrentColor.getAlpha());
            Color color2 = fillColor = this.plugin.recolorFill ? ColorUtil.colorWithAlpha((Color)rainbowColor, (int)this.plugin.currentTileFillColor.getAlpha()) : this.plugin.currentTileFillColor;
            if (!this.plugin.trueTileFadeout || this.client.getTickCount() - this.plugin.getLastTickPlayerMoved() <= 1) {
                this.renderTile(graphics, playerPosLocal, color, this.plugin.currentTileBorderWidth, fillColor, this.plugin.currentTileCornersOnly, this.plugin.currentTileCornerSize);
            } else {
                long timeSinceLastMove = System.currentTimeMillis() - this.plugin.getLastTimePlayerStoppedMoving();
                int fadeoutTime = this.plugin.trueTileFadeoutTime - 600;
                if (fadeoutTime != 0 && timeSinceLastMove < (long)fadeoutTime) {
                    double opacity = 1.0 - Math.pow((double)timeSinceLastMove / (double)fadeoutTime, 2.0);
                    this.renderTile(graphics, playerPosLocal, ColorUtil.colorWithAlpha((Color)color, (int)((int)(opacity * (double)color.getAlpha()))), this.plugin.currentTileBorderWidth, ColorUtil.colorWithAlpha((Color)fillColor, (int)((int)(opacity * (double)fillColor.getAlpha()))), this.plugin.currentTileCornersOnly, this.plugin.currentTileCornerSize);
                }
            }
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color, double borderWidth, Color fillColor, boolean cornersOnly, int divisor) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)dest);
        if (poly == null) {
            return;
        }
        if (cornersOnly) {
            RainbowRaveTileIndicatorsOverlay.renderPolygonCorners(graphics, poly, color, fillColor, new BasicStroke((float)borderWidth), divisor);
        } else {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Color)fillColor, (Stroke)new BasicStroke((float)borderWidth));
        }
    }

    public static void renderPolygonCorners(Graphics2D graphics, Polygon poly, Color color, Color fillColor, Stroke borderStroke, int divisor) {
        graphics.setColor(color);
        Stroke originalStroke = graphics.getStroke();
        graphics.setStroke(borderStroke);
        for (int i = 0; i < poly.npoints; ++i) {
            int ptx = poly.xpoints[i];
            int pty = poly.ypoints[i];
            int prev = i - 1 < 0 ? poly.npoints - 1 : i - 1;
            int next = i + 1 > poly.npoints - 1 ? 0 : i + 1;
            int ptxN = (poly.xpoints[next] - ptx) / divisor + ptx;
            int ptyN = (poly.ypoints[next] - pty) / divisor + pty;
            int ptxP = (poly.xpoints[prev] - ptx) / divisor + ptx;
            int ptyP = (poly.ypoints[prev] - pty) / divisor + pty;
            graphics.drawLine(ptx, pty, ptxN, ptyN);
            graphics.drawLine(ptx, pty, ptxP, ptyP);
        }
        graphics.setColor(fillColor);
        graphics.fill(poly);
        graphics.setStroke(originalStroke);
    }
}

