/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.inject.Provides;
import com.rainbowrave.Lootbeam;
import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRaveGroundItemsOverlay;
import com.rainbowrave.RainbowRaveGroundItemsPlugin;
import com.rainbowrave.RainbowRaveGroundMarkerOverlay;
import com.rainbowrave.RainbowRaveGroundMarkerPlugin;
import com.rainbowrave.RainbowRaveInventoryTagsOverlay;
import com.rainbowrave.RainbowRaveMouseTrailOverlay;
import com.rainbowrave.RainbowRaveMouseTrailPlugin;
import com.rainbowrave.RainbowRaveNpcIndicatorsPlugin;
import com.rainbowrave.RainbowRaveNpcSceneOverlay;
import com.rainbowrave.RainbowRaveObjectIndicatorsOverlay;
import com.rainbowrave.RainbowRaveObjectIndicatorsPlugin;
import com.rainbowrave.RainbowRaveTileIndicatorsOverlay;
import com.rainbowrave.RainbowRaveTileIndicatorsPlugin;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GraphicsObject;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependencies;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.GroundItemsPlugin;
import net.runelite.client.plugins.groundmarkers.GroundMarkerConfig;
import net.runelite.client.plugins.groundmarkers.GroundMarkerPlugin;
import net.runelite.client.plugins.inventorytags.InventoryTagsConfig;
import net.runelite.client.plugins.inventorytags.InventoryTagsPlugin;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsConfig;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsPlugin;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsConfig;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsPlugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Rainbow Rave", tags={"loot, beam, ground, item, tile, indicator, npc, object, inventory, tag"})
@PluginDependencies(value={@PluginDependency(value=NpcIndicatorsPlugin.class), @PluginDependency(value=GroundMarkerPlugin.class), @PluginDependency(value=ObjectIndicatorsPlugin.class), @PluginDependency(value=InventoryTagsPlugin.class), @PluginDependency(value=GroundItemsPlugin.class)})
public class RainbowRavePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RainbowRavePlugin.class);
    public static final String GROUP = "rainbow_rave";
    @Inject
    private Client client;
    @Inject
    private RainbowRaveConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ModelOutlineRenderer modelOutlineRenderer;
    @Inject
    private NpcIndicatorsConfig npcIndicatorsConfig;
    @Inject
    private RainbowRaveNpcIndicatorsPlugin rainbowRaveNpcIndicatorsPlugin;
    private RainbowRaveNpcSceneOverlay rainbowRaveNpcSceneOverlay;
    @Inject
    private GroundMarkerConfig groundMarkerConfig;
    @Inject
    private RainbowRaveGroundMarkerPlugin rainbowRaveGroundMarkerPlugin;
    private RainbowRaveGroundMarkerOverlay rainbowRaveGroundMarkerOverlay;
    @Inject
    private ObjectIndicatorsConfig objectIndicatorsConfig;
    @Inject
    private RainbowRaveObjectIndicatorsPlugin rainbowRaveObjectIndicatorsPlugin;
    private RainbowRaveObjectIndicatorsOverlay rainbowRaveObjectIndicatorsOverlay;
    private RainbowRaveInventoryTagsOverlay rainbowRaveInventoryTagsOverlay;
    @Inject
    private InventoryTagsConfig inventoryTagsConfig;
    @Inject
    private GroundItemsConfig groundItemsConfig;
    @Inject
    private RainbowRaveGroundItemsPlugin rainbowRaveGroundItemsPlugin;
    private RainbowRaveGroundItemsOverlay rainbowRaveGroundItemsOverlay;
    @Inject
    private RainbowRaveTileIndicatorsPlugin rainbowRaveTileIndicatorsPlugin;
    private RainbowRaveTileIndicatorsOverlay rainbowRaveTileIndicatorsOverlay;
    @Inject
    private RainbowRaveMouseTrailPlugin rainbowRaveMouseTrailPlugin;
    private RainbowRaveMouseTrailOverlay rainbowRaveMouseTrailOverlay;
    @Inject
    private EventBus eventBus;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientThread clientThread;
    private Function<NPC, RainbowRaveNpcIndicatorsPlugin.HighlightedNpc> highlighterPredicate;
    private static final List<Integer> scytheTrailIds = Arrays.asList(478, 506, 1172);

    protected void startUp() {
        if (this.rainbowRaveGroundMarkerOverlay == null) {
            this.rainbowRaveGroundMarkerOverlay = new RainbowRaveGroundMarkerOverlay(this.client, this.groundMarkerConfig, this.rainbowRaveGroundMarkerPlugin, this, this.config);
        }
        this.rainbowRaveGroundMarkerPlugin.startUp();
        this.overlayManager.add((Overlay)this.rainbowRaveGroundMarkerOverlay);
        this.eventBus.register((Object)this.rainbowRaveGroundMarkerPlugin);
        if (this.rainbowRaveObjectIndicatorsOverlay == null) {
            this.rainbowRaveObjectIndicatorsOverlay = new RainbowRaveObjectIndicatorsOverlay(this.client, this.objectIndicatorsConfig, this.rainbowRaveObjectIndicatorsPlugin, this.modelOutlineRenderer, this, this.config);
        }
        this.rainbowRaveObjectIndicatorsPlugin.startUp();
        this.overlayManager.add((Overlay)this.rainbowRaveObjectIndicatorsOverlay);
        this.eventBus.register((Object)this.rainbowRaveObjectIndicatorsPlugin);
        if (this.rainbowRaveNpcSceneOverlay == null) {
            this.rainbowRaveNpcSceneOverlay = new RainbowRaveNpcSceneOverlay(this.client, this.npcIndicatorsConfig, this.rainbowRaveNpcIndicatorsPlugin, this.modelOutlineRenderer, this, this.config);
        }
        this.updateNpcHighlighterWithConfigSettings();
        this.rainbowRaveNpcIndicatorsPlugin.startUp();
        this.overlayManager.add((Overlay)this.rainbowRaveNpcSceneOverlay);
        this.eventBus.register((Object)this.rainbowRaveNpcIndicatorsPlugin);
        if (this.rainbowRaveInventoryTagsOverlay == null) {
            this.rainbowRaveInventoryTagsOverlay = new RainbowRaveInventoryTagsOverlay(this.itemManager, this, this.inventoryTagsConfig, this.config, this.configManager);
        }
        this.overlayManager.add((Overlay)this.rainbowRaveInventoryTagsOverlay);
        if (this.rainbowRaveGroundItemsOverlay == null) {
            this.rainbowRaveGroundItemsOverlay = new RainbowRaveGroundItemsOverlay(this.client, this.rainbowRaveGroundItemsPlugin, this.groundItemsConfig);
        }
        this.overlayManager.add((Overlay)this.rainbowRaveGroundItemsOverlay);
        this.rainbowRaveGroundItemsPlugin.startUp();
        this.eventBus.register((Object)this.rainbowRaveGroundItemsPlugin);
        if (this.config.recolorTileIndicators()) {
            this.startRRTIPlugin();
        }
        if (this.rainbowRaveMouseTrailOverlay == null) {
            this.rainbowRaveMouseTrailOverlay = new RainbowRaveMouseTrailOverlay(this, this.rainbowRaveMouseTrailPlugin, this.config);
        }
        this.overlayManager.add((Overlay)this.rainbowRaveMouseTrailOverlay);
        this.rainbowRaveMouseTrailPlugin.startUp();
        this.eventBus.register((Object)this.rainbowRaveMouseTrailPlugin);
        this.migrateConfig();
    }

    private void migrateConfig() {
        String previousSmoothWaves = this.configManager.getConfiguration(GROUP, "smoothWaves");
        if (previousSmoothWaves != null) {
            if (Boolean.valueOf(previousSmoothWaves).booleanValue()) {
                this.configManager.setConfiguration(GROUP, "groundMarkerColorMode", (Object)RainbowRaveConfig.GroundMarkerColorMode.WAVES);
            }
            this.configManager.unsetConfiguration(GROUP, "smoothWaves");
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned e) {
        this.rainbowRaveGroundItemsPlugin.onItemSpawned(e);
    }

    protected void shutDown() {
        this.rainbowRaveGroundMarkerPlugin.shutDown();
        this.overlayManager.remove((Overlay)this.rainbowRaveGroundMarkerOverlay);
        this.eventBus.unregister((Object)this.rainbowRaveGroundMarkerPlugin);
        this.rainbowRaveObjectIndicatorsPlugin.shutDown();
        this.overlayManager.remove((Overlay)this.rainbowRaveObjectIndicatorsOverlay);
        this.eventBus.unregister((Object)this.rainbowRaveObjectIndicatorsPlugin);
        this.rainbowRaveNpcIndicatorsPlugin.shutDown();
        this.overlayManager.remove((Overlay)this.rainbowRaveNpcSceneOverlay);
        this.eventBus.unregister((Object)this.rainbowRaveNpcIndicatorsPlugin);
        this.overlayManager.remove((Overlay)this.rainbowRaveInventoryTagsOverlay);
        this.overlayManager.remove((Overlay)this.rainbowRaveGroundItemsOverlay);
        this.rainbowRaveGroundItemsPlugin.shutDown();
        this.eventBus.unregister((Object)this.rainbowRaveGroundItemsPlugin);
        this.stopRRTIPlugin();
        this.overlayManager.remove((Overlay)this.rainbowRaveMouseTrailOverlay);
        this.rainbowRaveMouseTrailPlugin.shutDown();
        this.eventBus.unregister((Object)this.rainbowRaveMouseTrailPlugin);
    }

    @Provides
    RainbowRaveConfig provideConfig(ConfigManager configManager) {
        return (RainbowRaveConfig)configManager.getConfig(RainbowRaveConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("runelite")) {
            this.checkAndPushOverlayToFront(configChanged, "grounditemsplugin", this.rainbowRaveGroundItemsOverlay);
            this.checkAndPushOverlayToFront(configChanged, "groundmarkerplugin", this.rainbowRaveGroundMarkerOverlay);
            this.checkAndPushOverlayToFront(configChanged, "inventorytagsplugin", (Overlay)this.rainbowRaveInventoryTagsOverlay);
            this.checkAndPushOverlayToFront(configChanged, "npcindicatorsplugin", this.rainbowRaveNpcSceneOverlay);
            this.checkAndPushOverlayToFront(configChanged, "objectindicatorsplugin", this.rainbowRaveObjectIndicatorsOverlay);
            this.checkAndPushOverlayToFront(configChanged, "brushmarkerplugin", this.rainbowRaveGroundMarkerOverlay);
            if (this.config.recolorTileIndicators()) {
                this.checkAndPushOverlayToFront(configChanged, "tileindicatorsplugin", this.rainbowRaveTileIndicatorsOverlay);
            }
        } else if (configChanged.getGroup().equals(GROUP)) {
            if (configChanged.getKey().equals("whichNpcsToHighlight")) {
                this.updateNpcHighlighterWithConfigSettings();
            } else if (configChanged.getKey().equals("recolorTileIndicators")) {
                if (this.config.recolorTileIndicators()) {
                    this.startRRTIPlugin();
                } else {
                    this.stopRRTIPlugin();
                }
            }
        }
    }

    private void stopRRTIPlugin() {
        this.overlayManager.remove((Overlay)this.rainbowRaveTileIndicatorsOverlay);
        this.rainbowRaveTileIndicatorsPlugin.shutDown();
        this.eventBus.unregister((Object)this.rainbowRaveTileIndicatorsPlugin);
    }

    private void startRRTIPlugin() {
        if (this.rainbowRaveTileIndicatorsOverlay == null) {
            this.rainbowRaveTileIndicatorsOverlay = new RainbowRaveTileIndicatorsOverlay(this.client, this.rainbowRaveTileIndicatorsPlugin, this);
        }
        this.overlayManager.add((Overlay)this.rainbowRaveTileIndicatorsOverlay);
        this.rainbowRaveTileIndicatorsPlugin.startUp();
        this.eventBus.register((Object)this.rainbowRaveTileIndicatorsPlugin);
    }

    private void checkAndPushOverlayToFront(ConfigChanged configChanged, String key, Overlay overlay) {
        if (configChanged.getKey().equals(key) && configChanged.getNewValue().equalsIgnoreCase("true")) {
            this.clientThread.invokeLater(() -> {
                this.overlayManager.remove(overlay);
                this.overlayManager.add(overlay);
            });
        }
    }

    private void updateNpcHighlighterWithConfigSettings() {
        Function<NPC, RainbowRaveNpcIndicatorsPlugin.HighlightedNpc> f;
        if (this.config.whichNpcsToHighlight() == RainbowRaveConfig.NpcsToHighlight.ALL) {
            f = npc -> this.rainbowRaveNpcIndicatorsPlugin.highlightedNpc((NPC)npc);
            this.rainbowRaveNpcSceneOverlay.enable(true);
        } else if (this.config.whichNpcsToHighlight() == RainbowRaveConfig.NpcsToHighlight.SAME) {
            f = npc -> null;
            this.rainbowRaveNpcSceneOverlay.enable(true);
        } else if (this.config.whichNpcsToHighlight() == RainbowRaveConfig.NpcsToHighlight.NONE) {
            f = npc -> null;
            this.rainbowRaveNpcSceneOverlay.enable(false);
        } else {
            return;
        }
        if (this.highlighterPredicate != null) {
            this.rainbowRaveNpcIndicatorsPlugin.unregisterHighlighter(this.highlighterPredicate);
        }
        this.highlighterPredicate = f;
        this.rainbowRaveNpcIndicatorsPlugin.registerHighlighter(this.highlighterPredicate);
        this.rainbowRaveNpcIndicatorsPlugin.rebuild();
    }

    public Color getColor(int hashCode) {
        return this.getColor(hashCode, this.client.getGameCycle(), this.config.syncColor(), this.config.colorSpeed());
    }

    public Color getColor(int hashCode, int gameCycle, boolean syncColor, int colorSpeed) {
        if (syncColor) {
            hashCode = 0;
        }
        int clientTicks = colorSpeed / 20;
        return this.config.theme().getColor((float)((hashCode + gameCycle) % clientTicks) / (float)clientTicks);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (this.config.dukeRave()) {
            for (NPC npc : this.client.getNpcs()) {
                if (npc.getId() < 12199 || npc.getId() > 12201) continue;
                this.recolorAllFaces(npc.getModel(), this.getColor((int)npc.getHash()));
            }
        }
        if (this.config.recolorLootBeams()) {
            boolean colorHighlightedItems = this.config.colorHighlightedGroundItems();
            int tierOrdinal = this.config.whichGroundItemsToColor().highlightTierRelativeOrdinal;
            for (Lootbeam value : this.rainbowRaveGroundItemsPlugin.lootbeams.values()) {
                if (!(value.tier == null ? colorHighlightedItems : value.tier.ordinal() >= tierOrdinal)) continue;
                this.recolorAllFaces(value.runeLiteObject.getModel(), this.getColor(value.runeLiteObject.getLocation().hashCode()));
            }
        }
        if (this.config.recolorScytheSwings()) {
            for (GraphicsObject graphicsObject : this.client.getGraphicsObjects()) {
                if (!scytheTrailIds.contains(graphicsObject.getId()) && (graphicsObject.getId() < 1231 || graphicsObject.getId() > 1235) && (graphicsObject.getId() < 1891 || graphicsObject.getId() > 1898)) continue;
                this.recolorAllFaces(graphicsObject.getModel(), this.getColor(graphicsObject.getLocation().hashCode()));
            }
        }
    }

    private int colorToRs2hsb(Color color) {
        float[] hsbVals = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbVals[2] = hsbVals[2] - Math.min(hsbVals[1], hsbVals[2] / 2.0f);
        int encode_hue = (int)(hsbVals[0] * 63.0f);
        int encode_saturation = (int)(hsbVals[1] * 7.0f);
        int encode_brightness = (int)(hsbVals[2] * 127.0f);
        return (encode_hue << 10) + (encode_saturation << 7) + encode_brightness;
    }

    private void recolorAllFaces(Model model, Color color) {
        int i;
        if (model == null || color == null) {
            return;
        }
        int rs2hsb = this.colorToRs2hsb(color);
        int[] faceColors1 = model.getFaceColors1();
        int[] faceColors2 = model.getFaceColors2();
        int[] faceColors3 = model.getFaceColors3();
        for (i = 0; i < faceColors1.length; ++i) {
            faceColors1[i] = rs2hsb;
        }
        for (i = 0; i < faceColors2.length; ++i) {
            faceColors2[i] = rs2hsb;
        }
        for (i = 0; i < faceColors3.length; ++i) {
            faceColors3[i] = rs2hsb;
        }
    }
}

