/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.rainbowrave.ColorTileObject;
import com.rainbowrave.ObjectPoint;
import com.rainbowrave.RainbowRaveConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GroundObject;
import net.runelite.api.MenuAction;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsConfig;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowRaveObjectIndicatorsPlugin {
    private static final Logger log = LoggerFactory.getLogger(RainbowRaveObjectIndicatorsPlugin.class);
    private static final String CONFIG_GROUP = "objectindicators";
    private static final String MARK = "Mark object";
    private static final String UNMARK = "Unmark object";
    private final List<ColorTileObject> objects = new ArrayList<ColorTileObject>();
    private final List<ColorTileObject> allObjects = new ArrayList<ColorTileObject>();
    private final Map<Integer, Set<ObjectPoint>> points = new HashMap<Integer, Set<ObjectPoint>>();
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ObjectIndicatorsConfig config;
    @Inject
    private Gson gson;
    @Inject
    private RainbowRaveConfig rainbowRaveConfig;
    @Inject
    private ClientThread clientThread;

    protected void startUp() {
    }

    protected void shutDown() {
        this.points.clear();
        this.objects.clear();
        this.allObjects.clear();
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getWallObject());
        this.allObjects.removeIf(o -> o.getTileObject() == event.getWallObject());
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getGameObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getDecorativeObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getGameObject());
        this.allObjects.removeIf(o -> o.getTileObject() == event.getGameObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getDecorativeObject());
        this.allObjects.removeIf(o -> o.getTileObject() == event.getDecorativeObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.checkObjectPoints((TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.objects.removeIf(o -> o.getTileObject() == event.getGroundObject());
        this.allObjects.removeIf(o -> o.getTileObject() == event.getGroundObject());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOADING) {
            this.points.clear();
            for (int regionId : this.client.getMapRegions()) {
                Set<ObjectPoint> regionPoints = this.loadPoints(regionId);
                if (regionPoints == null) continue;
                this.points.put(regionId, regionPoints);
            }
        }
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN && gameStateChanged.getGameState() != GameState.CONNECTION_LOST) {
            this.allObjects.clear();
            this.objects.clear();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE || !event.getMenuOption().equals(MARK) && !event.getMenuOption().equals(UNMARK)) {
            return;
        }
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int x = event.getParam0();
        int y = event.getParam1();
        int z = this.client.getPlane();
        Tile tile = tiles[z][x][y];
        TileObject object = this.findTileObject(tile, event.getId());
        if (object == null) {
            return;
        }
        ObjectComposition objectDefinition = this.getObjectComposition(object.getId());
        String name = objectDefinition.getName();
        if (Strings.isNullOrEmpty((String)name) || name.equals("null")) {
            return;
        }
        this.markObject(objectDefinition, name, object);
    }

    private void checkObjectPoints(TileObject object) {
        String name;
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)object.getLocalLocation(), (int)object.getPlane());
        Set<ObjectPoint> objectPoints = this.points.get(worldPoint.getRegionID());
        if (objectPoints == null && this.rainbowRaveConfig.whichObjectsToHighlight() != RainbowRaveConfig.ObjectsToHighlight.ALL) {
            return;
        }
        ObjectComposition objectComposition = this.client.getObjectDefinition(object.getId());
        if (objectComposition.getImpostorIds() == null && (Strings.isNullOrEmpty((String)(name = objectComposition.getName())) || name.equals("null"))) {
            return;
        }
        boolean found = false;
        if (objectPoints != null) {
            for (ObjectPoint objectPoint : objectPoints) {
                if (worldPoint.getRegionX() != objectPoint.getRegionX() || worldPoint.getRegionY() != objectPoint.getRegionY() || worldPoint.getPlane() != objectPoint.getZ() || objectPoint.getId() != object.getId()) continue;
                log.debug("Marking object {} due to matching {}", (Object)object, (Object)objectPoint);
                this.objects.add(new ColorTileObject(object, objectComposition, objectPoint.getName(), objectPoint.getColor()));
                found = true;
                break;
            }
        }
        if (!found && this.rainbowRaveConfig.whichObjectsToHighlight() == RainbowRaveConfig.ObjectsToHighlight.ALL) {
            this.allObjects.add(new ColorTileObject(object, objectComposition, "name", Color.WHITE));
            return;
        }
    }

    private TileObject findTileObject(Tile tile, int id) {
        if (tile == null) {
            return null;
        }
        GameObject[] tileGameObjects = tile.getGameObjects();
        DecorativeObject tileDecorativeObject = tile.getDecorativeObject();
        WallObject tileWallObject = tile.getWallObject();
        GroundObject groundObject = tile.getGroundObject();
        if (this.objectIdEquals((TileObject)tileWallObject, id)) {
            return tileWallObject;
        }
        if (this.objectIdEquals((TileObject)tileDecorativeObject, id)) {
            return tileDecorativeObject;
        }
        if (this.objectIdEquals((TileObject)groundObject, id)) {
            return groundObject;
        }
        for (GameObject object : tileGameObjects) {
            if (!this.objectIdEquals((TileObject)object, id)) continue;
            return object;
        }
        return null;
    }

    private boolean objectIdEquals(TileObject tileObject, int id) {
        if (tileObject == null) {
            return false;
        }
        if (tileObject.getId() == id) {
            return true;
        }
        ObjectComposition comp = this.client.getObjectDefinition(tileObject.getId());
        if (comp.getImpostorIds() != null) {
            for (int impostorId : comp.getImpostorIds()) {
                if (impostorId != id) continue;
                return true;
            }
        }
        return false;
    }

    private void markObject(ObjectComposition objectComposition, String name, TileObject object) {
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)object.getLocalLocation());
        int regionId = worldPoint.getRegionID();
        Color color = this.config.markerColor();
        ObjectPoint point = new ObjectPoint(object.getId(), name, regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane(), color);
        Set objectPoints = this.points.computeIfAbsent(regionId, k -> new HashSet());
        if (this.objects.removeIf(o -> o.getTileObject() == object)) {
            if (!objectPoints.removeIf(op -> (op.getId() == -1 || op.getId() == object.getId() || op.getName().equals(objectComposition.getName())) && op.getRegionX() == worldPoint.getRegionX() && op.getRegionY() == worldPoint.getRegionY() && op.getZ() == worldPoint.getPlane())) {
                log.warn("unable to find object point for unmarked object {}", (Object)object.getId());
            }
            log.debug("Unmarking object: {}", (Object)point);
            this.allObjects.add(new ColorTileObject(object, objectComposition, "name", Color.WHITE));
        } else {
            objectPoints.add(point);
            ColorTileObject o2 = new ColorTileObject(object, this.client.getObjectDefinition(object.getId()), name, color);
            this.objects.add(o2);
            this.allObjects.removeIf(allO -> allO.getTileObject().equals(o2.getTileObject()));
            log.debug("Marking object: {}", (Object)point);
        }
    }

    private Set<ObjectPoint> loadPoints(int id) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, "region_" + id);
        if (Strings.isNullOrEmpty((String)json)) {
            return null;
        }
        Set points = (Set)this.gson.fromJson(json, new TypeToken<Set<ObjectPoint>>(){}.getType());
        return points.stream().filter(point -> !point.getName().equals("null")).collect(Collectors.toSet());
    }

    @Nullable
    private ObjectComposition getObjectComposition(int id) {
        ObjectComposition objectComposition = this.client.getObjectDefinition(id);
        return objectComposition.getImpostorIds() == null ? objectComposition : objectComposition.getImpostor();
    }

    public List<ColorTileObject> getObjects() {
        if (this.rainbowRaveConfig.whichObjectsToHighlight() == RainbowRaveConfig.ObjectsToHighlight.NONE) {
            return Collections.emptyList();
        }
        if (this.rainbowRaveConfig.whichObjectsToHighlight() == RainbowRaveConfig.ObjectsToHighlight.SAME) {
            return this.objects;
        }
        ArrayList<ColorTileObject> combinedObjects = new ArrayList<ColorTileObject>(this.allObjects);
        combinedObjects.addAll(this.objects);
        return combinedObjects;
    }
}

