/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.common.base.Strings;
import com.rainbowrave.ColorTileObject;
import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRaveObjectIndicatorsPlugin;
import com.rainbowrave.RainbowRavePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.ObjectComposition;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.client.plugins.objectindicators.ObjectIndicatorsConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;

class RainbowRaveObjectIndicatorsOverlay
extends Overlay {
    private final Client client;
    private final ObjectIndicatorsConfig config;
    private final RainbowRaveObjectIndicatorsPlugin plugin;
    private final RainbowRaveConfig rainbowRaveConfig;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private final RainbowRavePlugin rainbowRavePlugin;

    public RainbowRaveObjectIndicatorsOverlay(Client client, ObjectIndicatorsConfig config, RainbowRaveObjectIndicatorsPlugin plugin, ModelOutlineRenderer modelOutlineRenderer, RainbowRavePlugin rainbowRavePlugin, RainbowRaveConfig rainbowRaveConfig) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.rainbowRaveConfig = rainbowRaveConfig;
        this.rainbowRavePlugin = rainbowRavePlugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        BasicStroke stroke = new BasicStroke((float)this.config.borderWidth());
        for (ColorTileObject colorTileObject : this.plugin.getObjects()) {
            ObjectComposition composition;
            TileObject object = colorTileObject.getTileObject();
            Color color = this.rainbowRavePlugin.getColor(colorTileObject.hashCode());
            if (object.getPlane() != this.client.getPlane() || (composition = colorTileObject.getComposition()).getImpostorIds() != null && ((composition = composition.getImpostor()) == null || Strings.isNullOrEmpty((String)composition.getName()) || "null".equals(composition.getName()) || !composition.getName().equals(colorTileObject.getName()))) continue;
            if (color == null) {
                color = this.config.markerColor();
            }
            if (this.config.highlightHull()) {
                this.renderConvexHull(graphics, object, color, stroke);
            }
            if (!this.config.highlightOutline()) continue;
            this.modelOutlineRenderer.drawOutline(object, (int)this.config.borderWidth(), color, this.config.outlineFeather());
        }
        return null;
    }

    private void renderConvexHull(Graphics2D graphics, TileObject object, Color color, Stroke stroke) {
        Shape polygon;
        Shape polygon2 = null;
        if (object instanceof GameObject) {
            polygon = ((GameObject)object).getConvexHull();
        } else if (object instanceof WallObject) {
            polygon = ((WallObject)object).getConvexHull();
            polygon2 = ((WallObject)object).getConvexHull2();
        } else if (object instanceof DecorativeObject) {
            polygon = ((DecorativeObject)object).getConvexHull();
            polygon2 = ((DecorativeObject)object).getConvexHull2();
        } else {
            polygon = object instanceof GroundObject ? ((GroundObject)object).getConvexHull() : object.getCanvasTilePoly();
        }
        if (polygon != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon, (Color)color, (Stroke)stroke);
        }
        if (polygon2 != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)polygon2, (Color)color, (Stroke)stroke);
        }
    }
}

