/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.MemorizedNpc;
import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRaveNpcIndicatorsPlugin;
import com.rainbowrave.RainbowRavePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Locale;
import net.runelite.api.Client;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import net.runelite.client.util.Text;

public class RainbowRaveNpcSceneOverlay
extends Overlay {
    private static final Color TEXT_COLOR = Color.WHITE;
    private static final NumberFormat TIME_LEFT_FORMATTER = DecimalFormat.getInstance(Locale.US);
    private final Client client;
    private final NpcIndicatorsConfig config;
    private final RainbowRaveNpcIndicatorsPlugin plugin;
    private final RainbowRaveConfig rainbowRaveConfig;
    private final ModelOutlineRenderer modelOutlineRenderer;
    private final RainbowRavePlugin rainbowRavePlugin;
    private boolean enabled = true;

    RainbowRaveNpcSceneOverlay(Client client, NpcIndicatorsConfig config, RainbowRaveNpcIndicatorsPlugin plugin, ModelOutlineRenderer modelOutlineRenderer, RainbowRavePlugin rainbowRavePlugin, RainbowRaveConfig rainbowRaveConfig) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.rainbowRavePlugin = rainbowRavePlugin;
        this.rainbowRaveConfig = rainbowRaveConfig;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.enabled) {
            if (this.config.showRespawnTimer()) {
                this.plugin.getDeadNpcsToDisplay().forEach((id, npc) -> this.renderNpcRespawn((MemorizedNpc)npc, graphics));
            }
            for (RainbowRaveNpcIndicatorsPlugin.HighlightedNpc highlightedNpc : this.plugin.getHighlightedNpcs().values()) {
                this.renderNpcOverlay(graphics, highlightedNpc, null);
            }
        }
        if (this.rainbowRaveConfig.highlightSelf() || this.rainbowRaveConfig.highlightOthers()) {
            if (this.rainbowRaveConfig.highlightSelf()) {
                this.renderNpcOverlay(graphics, this.plugin.highlightedPlayer(), this.client.getLocalPlayer());
            }
            if (this.rainbowRaveConfig.highlightOthers()) {
                for (Player player : this.client.getPlayers()) {
                    if (player == this.client.getLocalPlayer()) continue;
                    this.renderNpcOverlay(graphics, this.plugin.highlightedPlayer(), player);
                }
            }
        }
        return null;
    }

    private void renderNpcRespawn(MemorizedNpc npc, Graphics2D graphics) {
        if (npc.getPossibleRespawnLocations().isEmpty()) {
            return;
        }
        WorldPoint respawnLocation = npc.getPossibleRespawnLocations().get(0);
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (int)respawnLocation.getX(), (int)respawnLocation.getY());
        if (lp == null) {
            return;
        }
        LocalPoint centerLp = new LocalPoint(lp.getX() + 128 * (npc.getNpcSize() - 1) / 2, lp.getY() + 128 * (npc.getNpcSize() - 1) / 2);
        Polygon poly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)centerLp, (int)npc.getNpcSize());
        this.renderPoly(graphics, this.config.highlightColor(), this.config.fillColor(), poly);
        Instant now = Instant.now();
        double baseTick = (double)(npc.getDiedOnTick() + npc.getRespawnTime() - this.client.getTickCount()) * 0.6;
        double sinceLast = (double)(now.toEpochMilli() - this.plugin.getLastTickUpdate().toEpochMilli()) / 1000.0;
        double timeLeft = Math.max(0.0, baseTick - sinceLast);
        String timeLeftStr = TIME_LEFT_FORMATTER.format(timeLeft);
        int textWidth = graphics.getFontMetrics().stringWidth(timeLeftStr);
        int textHeight = graphics.getFontMetrics().getAscent();
        Point canvasPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)centerLp, (int)respawnLocation.getPlane());
        if (canvasPoint != null) {
            Point canvasCenterPoint = new Point(canvasPoint.getX() - textWidth / 2, canvasPoint.getY() + textHeight / 2);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasCenterPoint, (String)timeLeftStr, (Color)TEXT_COLOR);
        }
    }

    private void renderNpcOverlay(Graphics2D graphics, RainbowRaveNpcIndicatorsPlugin.HighlightedNpc highlightedNpc, Player player) {
        String npcName;
        Point textLocation;
        LocalPoint lp;
        LocalPoint lp2;
        Player actor;
        NPCComposition npcComposition = null;
        if (player == null) {
            actor = highlightedNpc.getNpc();
            npcComposition = highlightedNpc.getNpc().getTransformedComposition();
            if (npcComposition == null || !npcComposition.isInteractible() || actor.isDead() && this.config.ignoreDeadNpcs()) {
                return;
            }
        } else {
            actor = player;
        }
        Color borderColor = this.rainbowRavePlugin.getColor(actor.hashCode());
        Color fillColor = this.rainbowRavePlugin.getColor(actor.hashCode());
        fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), this.config.fillColor().getAlpha());
        if (highlightedNpc.isHull()) {
            Shape objectClickbox = actor.getConvexHull();
            this.renderPoly(graphics, borderColor, fillColor, objectClickbox);
        }
        if (highlightedNpc.isTile()) {
            int size = npcComposition == null ? 1 : npcComposition.getSize();
            lp2 = actor.getLocalLocation();
            Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)lp2, (int)size);
            this.renderPoly(graphics, borderColor, fillColor, tilePoly);
        }
        if (highlightedNpc.isTrueTile() && (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)actor.getWorldLocation())) != null) {
            int size = npcComposition == null ? 1 : npcComposition.getSize();
            LocalPoint centerLp = new LocalPoint(lp.getX() + 128 * (size - 1) / 2, lp.getY() + 128 * (size - 1) / 2);
            Polygon tilePoly = Perspective.getCanvasTileAreaPoly((Client)this.client, (LocalPoint)centerLp, (int)size);
            this.renderPoly(graphics, borderColor, fillColor, tilePoly);
        }
        if (highlightedNpc.isSwTile()) {
            int size = npcComposition == null ? 1 : npcComposition.getSize();
            lp2 = actor.getLocalLocation();
            int x = lp2.getX() - (size - 1) * 128 / 2;
            int y = lp2.getY() - (size - 1) * 128 / 2;
            Polygon southWestTilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)new LocalPoint(x, y));
            this.renderPoly(graphics, borderColor, fillColor, southWestTilePoly);
        }
        if (highlightedNpc.isSwTrueTile() && (lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)actor.getWorldLocation())) != null) {
            Polygon tilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
            this.renderPoly(graphics, borderColor, fillColor, tilePoly);
        }
        if (highlightedNpc.isOutline()) {
            if (player == null) {
                this.modelOutlineRenderer.drawOutline(highlightedNpc.getNpc(), (int)this.config.borderWidth(), borderColor, this.config.outlineFeather());
            } else {
                this.modelOutlineRenderer.drawOutline(player, (int)this.config.borderWidth(), borderColor, this.config.outlineFeather());
            }
        }
        if (highlightedNpc.isName() && actor.getName() != null && (textLocation = actor.getCanvasTextLocation(graphics, npcName = Text.removeTags((String)actor.getName()), actor.getLogicalHeight() + 40)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)npcName, (Color)borderColor);
        }
    }

    private void renderPoly(Graphics2D graphics, Color borderColor, Color fillColor, Shape polygon) {
        if (polygon != null) {
            graphics.setColor(borderColor);
            graphics.setStroke(new BasicStroke((float)this.config.borderWidth()));
            graphics.draw(polygon);
            graphics.setColor(fillColor);
            graphics.fill(polygon);
        }
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    static {
        ((DecimalFormat)TIME_LEFT_FORMATTER).applyPattern("#0.0");
    }
}

