/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.rainbowrave.MemorizedNpc;
import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.MenuAction;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.plugins.npchighlight.NpcIndicatorsConfig;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowRaveNpcIndicatorsPlugin {
    private static final Logger log = LoggerFactory.getLogger(RainbowRaveNpcIndicatorsPlugin.class);
    private static final int MAX_ACTOR_VIEW_RANGE = 15;
    private static final String TAG = "Tag";
    private static final String UNTAG = "Un-tag";
    private static final String TAG_ALL = "Tag-All";
    private static final String UNTAG_ALL = "Un-tag-All";
    private static final String STYLE_HULL = "hull";
    private static final String STYLE_TILE = "tile";
    private static final String STYLE_TRUE_TILE = "truetile";
    private static final String STYLE_SW_TILE = "swtile";
    private static final String STYLE_SW_TRUE_TILE = "swtruetile";
    private static final String STYLE_OUTLINE = "outline";
    @Inject
    private Client client;
    @Inject
    private NpcIndicatorsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NpcUtil npcUtil;
    @Inject
    private ConfigManager configManager;
    private final Map<NPC, HighlightedNpc> highlightedNpcs = new HashMap<NPC, HighlightedNpc>();
    private final Map<Integer, MemorizedNpc> deadNpcsToDisplay = new HashMap<Integer, MemorizedNpc>();
    private Instant lastTickUpdate;
    private final Map<Integer, MemorizedNpc> memorizedNpcs = new HashMap<Integer, MemorizedNpc>();
    private List<String> highlights = new ArrayList<String>();
    private final Set<Integer> npcTags = new HashSet<Integer>();
    private final List<NPC> spawnedNpcsThisTick = new ArrayList<NPC>();
    private final List<NPC> despawnedNpcsThisTick = new ArrayList<NPC>();
    private final Set<WorldPoint> teleportGraphicsObjectSpawnedThisTick = new HashSet<WorldPoint>();
    private WorldPoint lastPlayerLocation;
    private boolean skipNextSpawnCheck = false;
    private final List<Function<NPC, HighlightedNpc>> higlightPredicates = new ArrayList<Function<NPC, HighlightedNpc>>();

    protected void startUp() {
        this.clientThread.invoke(() -> {
            this.skipNextSpawnCheck = true;
            this.rebuild();
        });
    }

    protected void shutDown() {
        this.clientThread.invoke(() -> {
            this.deadNpcsToDisplay.clear();
            this.memorizedNpcs.clear();
            this.spawnedNpcsThisTick.clear();
            this.despawnedNpcsThisTick.clear();
            this.teleportGraphicsObjectSpawnedThisTick.clear();
            this.npcTags.clear();
            this.highlightedNpcs.clear();
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.highlightedNpcs.clear();
            this.deadNpcsToDisplay.clear();
            this.memorizedNpcs.forEach((id, npc) -> npc.setDiedOnTick(-1));
            this.lastPlayerLocation = null;
            this.skipNextSpawnCheck = true;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("npcindicators")) {
            return;
        }
        this.clientThread.invoke(this::rebuild);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked click) {
        if (click.getMenuAction() != MenuAction.RUNELITE || !click.getMenuOption().equals(TAG) && !click.getMenuOption().equals(UNTAG) && !click.getMenuOption().equals(TAG_ALL) && !click.getMenuOption().equals(UNTAG_ALL)) {
            return;
        }
        int id = click.getId();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        if (npc == null || npc.getName() == null) {
            return;
        }
        if (click.getMenuOption().equals(TAG) || click.getMenuOption().equals(UNTAG)) {
            boolean removed = this.npcTags.remove(id);
            if (removed) {
                if (!this.highlightMatchesNPCName(npc.getName())) {
                    this.highlightedNpcs.remove(npc);
                    this.memorizedNpcs.remove(npc.getIndex());
                }
            } else {
                if (!this.client.isInInstancedRegion()) {
                    this.memorizeNpc(npc);
                    this.npcTags.add(id);
                }
                this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (this.npcTags.contains(npc.getIndex())) {
            this.memorizeNpc(npc);
            this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
            this.spawnedNpcsThisTick.add(npc);
            return;
        }
        if (this.highlightMatchesNPCName(npcName)) {
            this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
            if (!this.client.isInInstancedRegion()) {
                this.memorizeNpc(npc);
                this.spawnedNpcsThisTick.add(npc);
            }
            return;
        }
        for (Function<NPC, HighlightedNpc> predicate : this.higlightPredicates) {
            HighlightedNpc highlightedNpc = predicate.apply(npc);
            if (highlightedNpc == null) continue;
            this.highlightedNpcs.put(npc, highlightedNpc);
            if (!this.client.isInInstancedRegion()) {
                this.memorizeNpc(npc);
                this.spawnedNpcsThisTick.add(npc);
            }
            return;
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (this.memorizedNpcs.containsKey(npc.getIndex())) {
            this.despawnedNpcsThisTick.add(npc);
        }
        this.highlightedNpcs.remove(npc);
    }

    @Subscribe
    public void onNpcChanged(NpcChanged event) {
        NPC npc = event.getNpc();
        String npcName = npc.getName();
        this.highlightedNpcs.remove(npc);
        if (npcName == null) {
            return;
        }
        if (this.npcTags.contains(npc.getIndex()) || this.highlightMatchesNPCName(npcName)) {
            this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
            return;
        }
        for (Function<NPC, HighlightedNpc> predicate : this.higlightPredicates) {
            HighlightedNpc highlightedNpc = predicate.apply(npc);
            if (highlightedNpc == null) continue;
            this.highlightedNpcs.put(npc, highlightedNpc);
            return;
        }
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated event) {
        GraphicsObject go = event.getGraphicsObject();
        if (go.getId() == 86) {
            this.teleportGraphicsObjectSpawnedThisTick.add(WorldPoint.fromLocal((Client)this.client, (LocalPoint)go.getLocation()));
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.removeOldHighlightedRespawns();
        this.validateSpawnedNpcs();
        this.lastTickUpdate = Instant.now();
        this.lastPlayerLocation = this.client.getLocalPlayer().getWorldLocation();
    }

    private static boolean isInViewRange(WorldPoint wp1, WorldPoint wp2) {
        int distance = wp1.distanceTo(wp2);
        return distance < 15;
    }

    private static WorldPoint getWorldLocationBehind(NPC npc) {
        int orientation = npc.getOrientation() / 256;
        int dx = 0;
        int dy = 0;
        switch (orientation) {
            case 0: {
                dy = -1;
                break;
            }
            case 1: {
                dx = -1;
                dy = -1;
                break;
            }
            case 2: {
                dx = -1;
                break;
            }
            case 3: {
                dx = -1;
                dy = 1;
                break;
            }
            case 4: {
                dy = 1;
                break;
            }
            case 5: {
                dx = 1;
                dy = 1;
                break;
            }
            case 6: {
                dx = 1;
                break;
            }
            case 7: {
                dx = 1;
                dy = -1;
            }
        }
        WorldPoint currWP = npc.getWorldLocation();
        return new WorldPoint(currWP.getX() - dx, currWP.getY() - dy, currWP.getPlane());
    }

    private void memorizeNpc(NPC npc) {
        int npcIndex = npc.getIndex();
        this.memorizedNpcs.putIfAbsent(npcIndex, new MemorizedNpc(npc));
    }

    private void removeOldHighlightedRespawns() {
        this.deadNpcsToDisplay.values().removeIf(x -> x.getDiedOnTick() + x.getRespawnTime() <= this.client.getTickCount() + 1);
    }

    @VisibleForTesting
    List<String> getHighlights() {
        String configNpcs = this.config.getNpcToHighlight();
        if (configNpcs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNpcs);
    }

    public void rebuild() {
        this.highlights = this.getHighlights();
        this.highlightedNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        block0: for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (npcName == null) continue;
            if (this.npcTags.contains(npc.getIndex())) {
                this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
                continue;
            }
            if (this.highlightMatchesNPCName(npcName)) {
                if (!this.client.isInInstancedRegion()) {
                    this.memorizeNpc(npc);
                }
                this.highlightedNpcs.put(npc, this.highlightedNpc(npc));
                continue;
            }
            for (Function<NPC, HighlightedNpc> predicate : this.higlightPredicates) {
                HighlightedNpc highlightedNpc = predicate.apply(npc);
                if (highlightedNpc == null) continue;
                if (!this.client.isInInstancedRegion()) {
                    this.memorizeNpc(npc);
                }
                this.highlightedNpcs.put(npc, highlightedNpc);
                continue block0;
            }
            this.memorizedNpcs.remove(npc.getIndex());
        }
    }

    private boolean highlightMatchesNPCName(String npcName) {
        for (String highlight : this.highlights) {
            if (!WildcardMatcher.matches((String)highlight, (String)npcName)) continue;
            return true;
        }
        return false;
    }

    private void validateSpawnedNpcs() {
        if (this.skipNextSpawnCheck) {
            this.skipNextSpawnCheck = false;
        } else {
            MemorizedNpc mn;
            for (NPC npc : this.despawnedNpcsThisTick) {
                if (!this.teleportGraphicsObjectSpawnedThisTick.isEmpty() && this.teleportGraphicsObjectSpawnedThisTick.contains(npc.getWorldLocation()) || !RainbowRaveNpcIndicatorsPlugin.isInViewRange(this.client.getLocalPlayer().getWorldLocation(), npc.getWorldLocation()) || (mn = this.memorizedNpcs.get(npc.getIndex())) == null) continue;
                mn.setDiedOnTick(this.client.getTickCount() + 1);
                if (mn.getPossibleRespawnLocations().isEmpty()) continue;
                log.debug("Starting {} tick countdown for {}", (Object)mn.getRespawnTime(), (Object)mn.getNpcName());
                this.deadNpcsToDisplay.put(mn.getNpcIndex(), mn);
            }
            for (NPC npc : this.spawnedNpcsThisTick) {
                if (!this.teleportGraphicsObjectSpawnedThisTick.isEmpty() && (this.teleportGraphicsObjectSpawnedThisTick.contains(npc.getWorldLocation()) || this.teleportGraphicsObjectSpawnedThisTick.contains(RainbowRaveNpcIndicatorsPlugin.getWorldLocationBehind(npc))) || this.lastPlayerLocation == null || !RainbowRaveNpcIndicatorsPlugin.isInViewRange(this.lastPlayerLocation, npc.getWorldLocation())) continue;
                mn = this.memorizedNpcs.get(npc.getIndex());
                if (mn.getDiedOnTick() != -1) {
                    int respawnTime = this.client.getTickCount() + 1 - mn.getDiedOnTick();
                    if (mn.getRespawnTime() == -1 || respawnTime < mn.getRespawnTime()) {
                        mn.setRespawnTime(respawnTime);
                    }
                    mn.setDiedOnTick(-1);
                }
                WorldPoint npcLocation = npc.getWorldLocation();
                WorldPoint possibleOtherNpcLocation = RainbowRaveNpcIndicatorsPlugin.getWorldLocationBehind(npc);
                mn.getPossibleRespawnLocations().removeIf(x -> !x.equals((Object)npcLocation) && !x.equals((Object)possibleOtherNpcLocation));
                if (!mn.getPossibleRespawnLocations().isEmpty()) continue;
                mn.getPossibleRespawnLocations().add(npcLocation);
                mn.getPossibleRespawnLocations().add(possibleOtherNpcLocation);
            }
        }
        this.spawnedNpcsThisTick.clear();
        this.despawnedNpcsThisTick.clear();
        this.teleportGraphicsObjectSpawnedThisTick.clear();
    }

    public HighlightedNpc highlightedPlayer() {
        return HighlightedNpc.builder().highlightColor(this.config.highlightColor()).fillColor(this.config.fillColor()).hull(this.config.highlightHull()).tile(this.config.highlightTile()).trueTile(this.config.highlightTrueTile()).swTile(this.config.highlightSouthWestTile()).swTrueTile(this.config.highlightSouthWestTrueTile()).outline(this.config.highlightOutline()).name(this.config.drawNames()).nameOnMinimap(this.config.drawMinimapNames()).borderWidth((float)this.config.borderWidth()).outlineFeather(this.config.outlineFeather()).render(this::render).build();
    }

    public HighlightedNpc highlightedNpc(NPC npc) {
        boolean outline;
        boolean swTrueTile;
        boolean swTile;
        boolean trueTile;
        boolean tile;
        boolean hull;
        int npcId = npc.getId();
        String style = this.getNpcTagStyle(npcId);
        if (style != null) {
            hull = STYLE_HULL.equals(style);
            tile = STYLE_TILE.equals(style);
            trueTile = STYLE_TRUE_TILE.equals(style);
            swTile = STYLE_SW_TILE.equals(style);
            swTrueTile = STYLE_SW_TRUE_TILE.equals(style);
            outline = STYLE_OUTLINE.equals(style);
        } else {
            hull = this.config.highlightHull();
            tile = this.config.highlightTile();
            trueTile = this.config.highlightTrueTile();
            swTile = this.config.highlightSouthWestTile();
            swTrueTile = this.config.highlightSouthWestTrueTile();
            outline = this.config.highlightOutline();
        }
        return HighlightedNpc.builder().npc(npc).highlightColor((Color)MoreObjects.firstNonNull((Object)this.getNpcHighlightColor(npcId), (Object)this.config.highlightColor())).fillColor(this.config.fillColor()).hull(hull).tile(tile).trueTile(trueTile).swTile(swTile).swTrueTile(swTrueTile).outline(outline).name(this.config.drawNames()).nameOnMinimap(this.config.drawMinimapNames()).borderWidth((float)this.config.borderWidth()).outlineFeather(this.config.outlineFeather()).render(this::render).build();
    }

    private boolean render(NPC n) {
        if (this.npcUtil.isDying(n) && this.config.ignoreDeadNpcs()) {
            return false;
        }
        NPCComposition c = n.getTransformedComposition();
        return c == null || !c.isFollower() || !this.config.ignorePets();
    }

    private Color getNpcHighlightColor(int npcId) {
        return (Color)this.configManager.getConfiguration("npcindicators", "highlightcolor_" + npcId, Color.class);
    }

    private String getNpcTagStyle(int npcId) {
        return this.configManager.getConfiguration("npcindicators", "tagstyle_" + npcId);
    }

    public void registerHighlighter(Function<NPC, HighlightedNpc> p) {
        this.higlightPredicates.add(p);
    }

    public void unregisterHighlighter(Function<NPC, HighlightedNpc> p) {
        this.higlightPredicates.remove(p);
    }

    Map<NPC, HighlightedNpc> getHighlightedNpcs() {
        return this.highlightedNpcs;
    }

    Map<Integer, MemorizedNpc> getDeadNpcsToDisplay() {
        return this.deadNpcsToDisplay;
    }

    Instant getLastTickUpdate() {
        return this.lastTickUpdate;
    }

    public static final class HighlightedNpc {
        private final NPC npc;
        @NonNull
        private final Color highlightColor;
        private final Color fillColor;
        private final boolean hull;
        private final boolean tile;
        private final boolean trueTile;
        private final boolean swTile;
        private final boolean swTrueTile;
        private final boolean outline;
        private final boolean name;
        private final boolean nameOnMinimap;
        private final float borderWidth;
        private final int outlineFeather;
        private final Predicate<NPC> render;

        private static Color $default$fillColor() {
            return new Color(0, 0, 0, 50);
        }

        private static float $default$borderWidth() {
            return 2.0f;
        }

        HighlightedNpc(NPC npc, @NonNull Color highlightColor, Color fillColor, boolean hull, boolean tile, boolean trueTile, boolean swTile, boolean swTrueTile, boolean outline, boolean name, boolean nameOnMinimap, float borderWidth, int outlineFeather, Predicate<NPC> render) {
            if (highlightColor == null) {
                throw new NullPointerException("highlightColor is marked non-null but is null");
            }
            this.npc = npc;
            this.highlightColor = highlightColor;
            this.fillColor = fillColor;
            this.hull = hull;
            this.tile = tile;
            this.trueTile = trueTile;
            this.swTile = swTile;
            this.swTrueTile = swTrueTile;
            this.outline = outline;
            this.name = name;
            this.nameOnMinimap = nameOnMinimap;
            this.borderWidth = borderWidth;
            this.outlineFeather = outlineFeather;
            this.render = render;
        }

        public static HighlightedNpcBuilder builder() {
            return new HighlightedNpcBuilder();
        }

        public NPC getNpc() {
            return this.npc;
        }

        @NonNull
        public Color getHighlightColor() {
            return this.highlightColor;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public boolean isHull() {
            return this.hull;
        }

        public boolean isTile() {
            return this.tile;
        }

        public boolean isTrueTile() {
            return this.trueTile;
        }

        public boolean isSwTile() {
            return this.swTile;
        }

        public boolean isSwTrueTile() {
            return this.swTrueTile;
        }

        public boolean isOutline() {
            return this.outline;
        }

        public boolean isName() {
            return this.name;
        }

        public boolean isNameOnMinimap() {
            return this.nameOnMinimap;
        }

        public float getBorderWidth() {
            return this.borderWidth;
        }

        public int getOutlineFeather() {
            return this.outlineFeather;
        }

        public Predicate<NPC> getRender() {
            return this.render;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HighlightedNpc)) {
                return false;
            }
            HighlightedNpc other = (HighlightedNpc)o;
            if (this.isHull() != other.isHull()) {
                return false;
            }
            if (this.isTile() != other.isTile()) {
                return false;
            }
            if (this.isTrueTile() != other.isTrueTile()) {
                return false;
            }
            if (this.isSwTile() != other.isSwTile()) {
                return false;
            }
            if (this.isSwTrueTile() != other.isSwTrueTile()) {
                return false;
            }
            if (this.isOutline() != other.isOutline()) {
                return false;
            }
            if (this.isName() != other.isName()) {
                return false;
            }
            if (this.isNameOnMinimap() != other.isNameOnMinimap()) {
                return false;
            }
            if (Float.compare(this.getBorderWidth(), other.getBorderWidth()) != 0) {
                return false;
            }
            if (this.getOutlineFeather() != other.getOutlineFeather()) {
                return false;
            }
            NPC this$npc = this.getNpc();
            NPC other$npc = other.getNpc();
            if (this$npc == null ? other$npc != null : !this$npc.equals(other$npc)) {
                return false;
            }
            Color this$highlightColor = this.getHighlightColor();
            Color other$highlightColor = other.getHighlightColor();
            if (this$highlightColor == null ? other$highlightColor != null : !((Object)this$highlightColor).equals(other$highlightColor)) {
                return false;
            }
            Color this$fillColor = this.getFillColor();
            Color other$fillColor = other.getFillColor();
            if (this$fillColor == null ? other$fillColor != null : !((Object)this$fillColor).equals(other$fillColor)) {
                return false;
            }
            Predicate<NPC> this$render = this.getRender();
            Predicate<NPC> other$render = other.getRender();
            return !(this$render == null ? other$render != null : !this$render.equals(other$render));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHull() ? 79 : 97);
            result = result * 59 + (this.isTile() ? 79 : 97);
            result = result * 59 + (this.isTrueTile() ? 79 : 97);
            result = result * 59 + (this.isSwTile() ? 79 : 97);
            result = result * 59 + (this.isSwTrueTile() ? 79 : 97);
            result = result * 59 + (this.isOutline() ? 79 : 97);
            result = result * 59 + (this.isName() ? 79 : 97);
            result = result * 59 + (this.isNameOnMinimap() ? 79 : 97);
            result = result * 59 + Float.floatToIntBits(this.getBorderWidth());
            result = result * 59 + this.getOutlineFeather();
            NPC $npc = this.getNpc();
            result = result * 59 + ($npc == null ? 43 : $npc.hashCode());
            Color $highlightColor = this.getHighlightColor();
            result = result * 59 + ($highlightColor == null ? 43 : ((Object)$highlightColor).hashCode());
            Color $fillColor = this.getFillColor();
            result = result * 59 + ($fillColor == null ? 43 : ((Object)$fillColor).hashCode());
            Predicate<NPC> $render = this.getRender();
            result = result * 59 + ($render == null ? 43 : $render.hashCode());
            return result;
        }

        public String toString() {
            return "RainbowRaveNpcIndicatorsPlugin.HighlightedNpc(npc=" + this.getNpc() + ", highlightColor=" + this.getHighlightColor() + ", fillColor=" + this.getFillColor() + ", hull=" + this.isHull() + ", tile=" + this.isTile() + ", trueTile=" + this.isTrueTile() + ", swTile=" + this.isSwTile() + ", swTrueTile=" + this.isSwTrueTile() + ", outline=" + this.isOutline() + ", name=" + this.isName() + ", nameOnMinimap=" + this.isNameOnMinimap() + ", borderWidth=" + this.getBorderWidth() + ", outlineFeather=" + this.getOutlineFeather() + ", render=" + this.getRender() + ")";
        }

        public static class HighlightedNpcBuilder {
            private NPC npc;
            private Color highlightColor;
            private boolean fillColor$set;
            private Color fillColor$value;
            private boolean hull;
            private boolean tile;
            private boolean trueTile;
            private boolean swTile;
            private boolean swTrueTile;
            private boolean outline;
            private boolean name;
            private boolean nameOnMinimap;
            private boolean borderWidth$set;
            private float borderWidth$value;
            private int outlineFeather;
            private Predicate<NPC> render;

            HighlightedNpcBuilder() {
            }

            public HighlightedNpcBuilder npc(NPC npc) {
                this.npc = npc;
                return this;
            }

            public HighlightedNpcBuilder highlightColor(@NonNull Color highlightColor) {
                if (highlightColor == null) {
                    throw new NullPointerException("highlightColor is marked non-null but is null");
                }
                this.highlightColor = highlightColor;
                return this;
            }

            public HighlightedNpcBuilder fillColor(Color fillColor) {
                this.fillColor$value = fillColor;
                this.fillColor$set = true;
                return this;
            }

            public HighlightedNpcBuilder hull(boolean hull) {
                this.hull = hull;
                return this;
            }

            public HighlightedNpcBuilder tile(boolean tile) {
                this.tile = tile;
                return this;
            }

            public HighlightedNpcBuilder trueTile(boolean trueTile) {
                this.trueTile = trueTile;
                return this;
            }

            public HighlightedNpcBuilder swTile(boolean swTile) {
                this.swTile = swTile;
                return this;
            }

            public HighlightedNpcBuilder swTrueTile(boolean swTrueTile) {
                this.swTrueTile = swTrueTile;
                return this;
            }

            public HighlightedNpcBuilder outline(boolean outline) {
                this.outline = outline;
                return this;
            }

            public HighlightedNpcBuilder name(boolean name) {
                this.name = name;
                return this;
            }

            public HighlightedNpcBuilder nameOnMinimap(boolean nameOnMinimap) {
                this.nameOnMinimap = nameOnMinimap;
                return this;
            }

            public HighlightedNpcBuilder borderWidth(float borderWidth) {
                this.borderWidth$value = borderWidth;
                this.borderWidth$set = true;
                return this;
            }

            public HighlightedNpcBuilder outlineFeather(int outlineFeather) {
                this.outlineFeather = outlineFeather;
                return this;
            }

            public HighlightedNpcBuilder render(Predicate<NPC> render) {
                this.render = render;
                return this;
            }

            public HighlightedNpc build() {
                Color fillColor$value = this.fillColor$value;
                if (!this.fillColor$set) {
                    fillColor$value = HighlightedNpc.$default$fillColor();
                }
                float borderWidth$value = this.borderWidth$value;
                if (!this.borderWidth$set) {
                    borderWidth$value = HighlightedNpc.$default$borderWidth();
                }
                return new HighlightedNpc(this.npc, this.highlightColor, fillColor$value, this.hull, this.tile, this.trueTile, this.swTile, this.swTrueTile, this.outline, this.name, this.nameOnMinimap, borderWidth$value, this.outlineFeather, this.render);
            }

            public String toString() {
                return "RainbowRaveNpcIndicatorsPlugin.HighlightedNpc.HighlightedNpcBuilder(npc=" + this.npc + ", highlightColor=" + this.highlightColor + ", fillColor$value=" + this.fillColor$value + ", hull=" + this.hull + ", tile=" + this.tile + ", trueTile=" + this.trueTile + ", swTile=" + this.swTile + ", swTrueTile=" + this.swTrueTile + ", outline=" + this.outline + ", name=" + this.name + ", nameOnMinimap=" + this.nameOnMinimap + ", borderWidth$value=" + this.borderWidth$value + ", outlineFeather=" + this.outlineFeather + ", render=" + this.render + ")";
            }
        }
    }
}

