/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.Curve;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.api.events.ClientTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowRaveMouseTrailPlugin {
    private static final Logger log = LoggerFactory.getLogger(RainbowRaveMouseTrailPlugin.class);
    private final Deque<Curve> curve = new ArrayDeque<Curve>();
    private Point temp = null;
    @Inject
    private MouseManager mouseManager;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        public MouseEvent mouseMoved(MouseEvent event) {
            RainbowRaveMouseTrailPlugin.this.updateMousePositions(new Point(event.getX(), event.getY()));
            return event;
        }

        public MouseEvent mouseDragged(MouseEvent event) {
            RainbowRaveMouseTrailPlugin.this.updateMousePositions(new Point(event.getX(), event.getY()));
            return event;
        }
    };

    protected void startUp() {
        this.setMouseListenerEnabled(true);
    }

    protected void shutDown() {
        this.curve.clear();
        this.setMouseListenerEnabled(false);
    }

    public void setMouseListenerEnabled(boolean enabled) {
        if (enabled) {
            this.mouseManager.registerMouseListener((MouseListener)this.mouseAdapter);
        } else {
            this.mouseManager.unregisterMouseListener((MouseListener)this.mouseAdapter);
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        this.popTrail();
        this.popTrail();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("rainbow_rave") && configChanged.getKey().equals("whichMouseTrailStyle") && configChanged.getNewValue() != null) {
            this.setMouseListenerEnabled(!configChanged.getNewValue().equals("NONE"));
        }
    }

    public void updateMousePositions(Point point) {
        if (this.curve.size() < 50) {
            if (this.temp != null) {
                Curve current = new Curve(this.temp, point);
                this.curve.add(current);
            }
            this.temp = point;
        }
    }

    public Deque<Curve> getTrail() {
        return this.curve;
    }

    public void popTrail() {
        if (this.curve.size() > 0) {
            this.curve.pop();
        }
    }
}

