/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.Curve;
import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRaveMouseTrailPlugin;
import com.rainbowrave.RainbowRavePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

class RainbowRaveMouseTrailOverlay
extends Overlay {
    private final RainbowRavePlugin rainbowRavePlugin;
    private final RainbowRaveMouseTrailPlugin plugin;
    private final RainbowRaveConfig rainbowRaveConfig;

    public RainbowRaveMouseTrailOverlay(RainbowRavePlugin rainbowRavePlugin, RainbowRaveMouseTrailPlugin plugin, RainbowRaveConfig rainbowRaveConfig) {
        this.plugin = plugin;
        this.rainbowRavePlugin = rainbowRavePlugin;
        this.rainbowRaveConfig = rainbowRaveConfig;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    private Color getRainbowColor(int trailSize, int position) {
        float currentPercent = (float)position / (float)trailSize;
        float hue = currentPercent * (float)trailSize;
        return this.rainbowRaveConfig.theme().getColor(hue / 100.0f);
    }

    private Color getColor(int size, int position) {
        if (this.rainbowRaveConfig.whichMouseTrailStyle() == RainbowRaveConfig.MouseTrailStyle.SYNCED) {
            return this.rainbowRavePlugin.getColor(0);
        }
        return this.getRainbowColor(size, position);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.rainbowRaveConfig.whichMouseTrailStyle() == RainbowRaveConfig.MouseTrailStyle.NONE) {
            return null;
        }
        boolean isPartyMode = this.rainbowRaveConfig.whichMouseTrailStyle() == RainbowRaveConfig.MouseTrailStyle.PARTYMODE;
        ArrayList<Curve> trail = new ArrayList<Curve>(this.plugin.getTrail());
        Point midBefore = null;
        Point midAfter = null;
        graphics.setStroke(new BasicStroke(2.0f, 0, 1));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.BLUE);
        for (int i = 0; i < trail.size(); ++i) {
            List<Point> points = ((Curve)trail.get(i)).getCurve();
            for (int j = 0; j < points.size(); ++j) {
                Point before = null;
                Point after = null;
                Point previous = null;
                Point current = null;
                if (i != 0 && j == 0) {
                    List<Point> previousPoints = ((Curve)trail.get(i - 1)).getCurve();
                    before = previousPoints.get(previousPoints.size() - 2);
                    after = points.get(j + 1);
                    previous = previousPoints.get(previousPoints.size() - 1);
                    current = points.get(j);
                } else if (j > 1) {
                    before = points.get(j - 2);
                    previous = points.get(j - 1);
                    current = points.get(j);
                    if (i < trail.size() - 1 && j == points.size() - 1) {
                        after = ((Curve)trail.get(i + 1)).getCurve().get(1);
                    }
                }
                if (j == 4) {
                    if (midBefore == null) {
                        midBefore = points.get(j);
                    }
                } else if (j == 2 && midBefore != null) {
                    midAfter = points.get(j);
                }
                int position = i * 5 + j;
                int size = trail.size() * 5;
                Color color = this.getColor(isPartyMode ? size : size / 3, isPartyMode ? position : position / 3);
                graphics.setColor(color);
                if (previous != null && current != null) {
                    graphics.drawLine(previous.getX(), previous.getY(), current.getX(), current.getY());
                }
                if (before != null && after != null) {
                    graphics.drawLine(before.getX(), before.getY(), after.getX(), after.getY());
                }
                if (midBefore == null || midAfter == null) continue;
                graphics.drawLine(midBefore.getX(), midBefore.getY(), midAfter.getX(), midAfter.getY());
                midBefore = midAfter;
                midAfter = null;
            }
        }
        return null;
    }
}

