/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRavePlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.inventorytags.InventoryTagsConfig;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class RainbowRaveInventoryTagsOverlay
extends WidgetItemOverlay {
    private final ItemManager itemManager;
    private final RainbowRavePlugin rainbowRavePlugin;
    private final InventoryTagsConfig config;
    private final RainbowRaveConfig rainbowRaveConfig;
    private ConfigManager configManager;

    public RainbowRaveInventoryTagsOverlay(ItemManager itemManager, RainbowRavePlugin rainbowRavePlugin, InventoryTagsConfig config, RainbowRaveConfig rainbowRaveConfig, ConfigManager configManager) {
        this.itemManager = itemManager;
        this.rainbowRavePlugin = rainbowRavePlugin;
        this.config = config;
        this.rainbowRaveConfig = rainbowRaveConfig;
        this.configManager = configManager;
        this.showOnEquipment();
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        Color color;
        if (this.rainbowRaveConfig.whichItemsToInventoryTag() == RainbowRaveConfig.ItemsToTag.NONE) {
            return;
        }
        String tag = this.configManager.getConfiguration("inventorytags", "item_" + itemId);
        if ((tag != null && !tag.isEmpty() || this.rainbowRaveConfig.whichItemsToInventoryTag() == RainbowRaveConfig.ItemsToTag.ALL) && (color = this.rainbowRavePlugin.getColor(itemId)) != null) {
            Rectangle bounds = widgetItem.getCanvasBounds();
            if (this.config.showTagOutline()) {
                BufferedImage outline = this.itemManager.getItemOutline(itemId, widgetItem.getQuantity(), color);
                graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
            }
            if (this.config.showTagFill()) {
                Image image = this.getFillImage(color, widgetItem.getId(), widgetItem.getQuantity());
                graphics.drawImage(image, (int)bounds.getX(), (int)bounds.getY(), null);
            }
            if (this.config.showTagUnderline()) {
                int heightOffSet = (int)bounds.getY() + (int)bounds.getHeight() + 2;
                graphics.setColor(color);
                graphics.drawLine((int)bounds.getX(), heightOffSet, (int)bounds.getX() + (int)bounds.getWidth(), heightOffSet);
            }
        }
    }

    private Image getFillImage(Color color, int itemId, int qty) {
        Color fillColor = ColorUtil.colorWithAlpha((Color)color, (int)this.config.fillOpacity());
        return ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(itemId, qty, false), (Color)fillColor);
    }
}

