/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.rainbowrave.ColorTileMarker;
import com.rainbowrave.GroundMarkerPoint;
import com.rainbowrave.RainbowRaveConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.groundmarkers.GroundMarkerConfig;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RainbowRaveGroundMarkerPlugin {
    private static final Logger log = LoggerFactory.getLogger(RainbowRaveGroundMarkerPlugin.class);
    private static final String CONFIG_GROUP = "groundMarker";
    private static final String WALK_HERE = "Walk here";
    private static final String REGION_PREFIX = "region_";
    private static final String BRUSH_CONFIG_GROUP = "brushMarkers";
    private final List<ColorTileMarker> points = new ArrayList<ColorTileMarker>();
    @Inject
    private Client client;
    @Inject
    private GroundMarkerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private RainbowRaveConfig rainbowRaveConfig;
    @Inject
    private EventBus eventBus;
    @Inject
    private Gson gson;

    Collection<GroundMarkerPoint> getPoints(int regionId) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)this.gson.fromJson(json, new TypeToken<List<GroundMarkerPoint>>(){}.getType());
    }

    void loadPoints() {
        this.loadPoints(null, false);
    }

    void loadPoints(GroundMarkerPoint extraPoint, boolean added) {
        this.points.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            log.debug("Loading points for region {}", (Object)regionId);
            ArrayList<GroundMarkerPoint> regionPoints = new ArrayList<GroundMarkerPoint>(this.getPoints(regionId));
            if (extraPoint != null && !added) {
                regionPoints.remove(extraPoint);
            }
            Collection<ColorTileMarker> colorTileMarkers = this.translateToColorTileMarker(regionPoints);
            this.points.addAll(colorTileMarkers);
            if (!this.rainbowRaveConfig.useBrushMarkerTiles()) continue;
            Collection<GroundMarkerPoint> brushRegionPoints = this.getBrushPoints(regionId);
            Collection<ColorTileMarker> brushColorTileMarkers = this.translateToColorTileMarker(brushRegionPoints);
            this.points.addAll(brushColorTileMarkers);
        }
        if (extraPoint != null && added) {
            Collection<ColorTileMarker> colorTileMarkers = this.translateToColorTileMarker(Collections.singletonList(extraPoint));
            this.points.addAll(colorTileMarkers);
        }
    }

    private Collection<ColorTileMarker> translateToColorTileMarker(Collection<GroundMarkerPoint> points) {
        if (points.isEmpty()) {
            return Collections.emptyList();
        }
        return points.stream().map(point -> new ColorTileMarker(WorldPoint.fromRegion((int)point.getRegionId(), (int)point.getRegionX(), (int)point.getRegionY(), (int)point.getZ()), point.getColor(), point.getLabel())).flatMap(colorTile -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)colorTile.getWorldPoint());
            return localWorldPoints.stream().map(wp -> new ColorTileMarker((WorldPoint)wp, colorTile.getColor(), colorTile.getLabel()));
        }).collect(Collectors.toList());
    }

    public void startUp() {
        this.loadPoints();
    }

    public void shutDown() {
        this.points.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.loadPoints();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction().getId() != MenuAction.RUNELITE.getId()) {
            return;
        }
        Tile target = this.client.getSelectedSceneTile();
        if (target == null || !event.getMenuTarget().equals("Tile")) {
            return;
        }
        String option = event.getMenuOption();
        if (option.equals("Mark") || option.equals("Unmark")) {
            this.markTile(target.getLocalLocation());
        } else if (option.equals("Label")) {
            this.labelTile(target);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("rainbow_rave") && event.getKey().equals("useBrushMarkerTiles")) {
            this.loadPoints();
        }
        if (event.getGroup().equals(BRUSH_CONFIG_GROUP) && event.getKey().startsWith(REGION_PREFIX)) {
            this.loadPoints();
        }
    }

    private void markTile(LocalPoint localPoint) {
        if (localPoint == null) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        int regionId = worldPoint.getRegionID();
        GroundMarkerPoint point = new GroundMarkerPoint(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane(), this.config.markerColor(), null);
        log.debug("Updating point: {} - {}", (Object)point, (Object)worldPoint);
        ArrayList<GroundMarkerPoint> groundMarkerPoints = new ArrayList<GroundMarkerPoint>(this.getPoints(regionId));
        if (groundMarkerPoints.contains(point)) {
            this.loadPoints(point, false);
        } else {
            this.loadPoints(point, true);
        }
    }

    private void labelTile(Tile tile) {
        LocalPoint localPoint = tile.getLocalLocation();
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
        int regionId = worldPoint.getRegionID();
        GroundMarkerPoint searchPoint = new GroundMarkerPoint(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane(), null, null);
        Collection<GroundMarkerPoint> points = this.getPoints(regionId);
        GroundMarkerPoint existing = points.stream().filter(p -> p.equals(searchPoint)).findFirst().orElse(null);
        if (existing == null) {
            return;
        }
        this.chatboxPanelManager.openTextInput("Tile label").value(Optional.ofNullable(existing.getLabel()).orElse("")).onDone(input -> {
            input = Strings.emptyToNull((String)input);
            GroundMarkerPoint newPoint = new GroundMarkerPoint(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane(), existing.getColor(), (String)input);
            points.remove(searchPoint);
            points.add(newPoint);
            this.loadPoints();
        }).build();
    }

    private Collection<GroundMarkerPoint> getBrushPoints(int regionId) {
        String json = this.configManager.getConfiguration(BRUSH_CONFIG_GROUP, REGION_PREFIX + regionId);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)RuneLiteAPI.GSON.fromJson(json, new TypeToken<List<GroundMarkerPoint>>(){}.getType());
    }

    List<ColorTileMarker> getPoints() {
        return this.points;
    }
}

