/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.common.base.Strings;
import com.rainbowrave.ColorTileMarker;
import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRaveGroundMarkerPlugin;
import com.rainbowrave.RainbowRavePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.groundmarkers.GroundMarkerConfig;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class RainbowRaveGroundMarkerOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    private final Client client;
    private final GroundMarkerConfig config;
    private final RainbowRaveGroundMarkerPlugin plugin;
    private final RainbowRaveConfig rainbowRaveConfig;
    private final RainbowRavePlugin rainbowRavePlugin;
    private Random random = new Random();

    public RainbowRaveGroundMarkerOverlay(Client client, GroundMarkerConfig config, RainbowRaveGroundMarkerPlugin plugin, RainbowRavePlugin rainbowRavePlugin, RainbowRaveConfig rainbowRaveConfig) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.rainbowRavePlugin = rainbowRavePlugin;
        this.rainbowRaveConfig = rainbowRaveConfig;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.rainbowRaveConfig.rainbowTileMarkers()) {
            return null;
        }
        List<ColorTileMarker> points = this.plugin.getPoints();
        if (points.isEmpty()) {
            return null;
        }
        BasicStroke stroke = new BasicStroke((float)this.config.borderWidth());
        try {
            for (ColorTileMarker point : points) {
                int hashCode;
                WorldPoint worldPoint = point.getWorldPoint();
                if (worldPoint.getPlane() != this.client.getPlane()) continue;
                switch (this.rainbowRaveConfig.groundMarkerColorMode()) {
                    case WAVES: {
                        hashCode = (point.getWorldPoint().getX() + point.getWorldPoint().getY()) * 5;
                        break;
                    }
                    case COLOR_SYNC: {
                        if (point.getColor() != null) {
                            this.random.setSeed(point.getColor().getRGB());
                            hashCode = this.random.nextInt(1000);
                            break;
                        }
                    }
                    default: {
                        this.random.setSeed(((long)point.getWorldPoint().getX() << 16) + (long)point.getWorldPoint().getY());
                        hashCode = this.random.nextInt(1000);
                    }
                }
                Color tileColor = this.rainbowRaveConfig.syncColor() ? this.rainbowRavePlugin.getColor(0) : this.rainbowRaveConfig.theme().getColor(((float)hashCode + (float)this.client.getGameCycle() * (6000.0f / (float)this.rainbowRaveConfig.colorSpeed())) % 300.0f / 300.0f);
                this.drawTile(graphics, worldPoint, tileColor, point.getLabel(), stroke, this.rainbowRaveConfig.fillTiles());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color color, @Nullable String label, Stroke borderStroke, boolean fill) {
        Point canvasTextLocation;
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly != null) {
            if (fill) {
                graphics.setColor(color);
                graphics.fillPolygon(poly);
            }
            graphics.setColor(color);
            Stroke originalStroke = graphics.getStroke();
            graphics.setStroke(borderStroke);
            graphics.draw(poly);
            graphics.setStroke(originalStroke);
        }
        if (!Strings.isNullOrEmpty((String)label) && (canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (String)label, (int)0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasTextLocation, (String)label, (Color)color);
        }
    }
}

