/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.rainbowrave.GroundItem;
import com.rainbowrave.LootType;
import com.rainbowrave.Lootbeam;
import com.rainbowrave.NamedQuantity;
import com.rainbowrave.RainbowRaveConfig;
import com.rainbowrave.RainbowRaveGroundItemInputListener;
import com.rainbowrave.RainbowRavePlugin;
import com.rainbowrave.WildcardMatchLoader;
import java.awt.Color;
import java.awt.Rectangle;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.ItemQuantityChanged;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.events.PlayerLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.grounditems.GroundItemsConfig;
import net.runelite.client.plugins.grounditems.config.HighlightTier;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;

public class RainbowRaveGroundItemsPlugin {
    public static final String GROUND_ITEMS_CONFIG_GROUP = "grounditems";
    public static final String SHOW_LOOTBEAM_TIER_CONFIG_KEY = "showLootbeamTier";
    public static final String SHOW_LOOTBEAM_FOR_HIGHLIGHTED_CONFIG_KEY = "showLootbeamForHighlighted";
    private static final int COINS = 995;
    private Map.Entry<Rectangle, GroundItem> textBoxBounds;
    private Map.Entry<Rectangle, GroundItem> hiddenBoxBounds;
    private Map.Entry<Rectangle, GroundItem> highlightBoxBounds;
    private boolean hotKeyPressed;
    private boolean hideAll;
    private List<String> hiddenItemList = new CopyOnWriteArrayList<String>();
    private List<String> highlightedItemsList = new CopyOnWriteArrayList<String>();
    @Inject
    public RainbowRaveGroundItemInputListener inputListener;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GroundItemsConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private RainbowRaveConfig rainbowRaveConfig;
    @Inject
    private RainbowRavePlugin rainbowRavePlugin;
    @Inject
    private ConfigManager configManager;
    private final Table<WorldPoint, Integer, GroundItem> collectedGroundItems = HashBasedTable.create();
    private List<PriceHighlight> priceChecks = ImmutableList.of();
    private LoadingCache<NamedQuantity, Boolean> highlightedItems;
    private LoadingCache<NamedQuantity, Boolean> hiddenItems;
    private final Queue<Integer> droppedItemQueue = EvictingQueue.create((int)16);
    private int lastUsedItem;
    final Map<WorldPoint, Lootbeam> lootbeams = new HashMap<WorldPoint, Lootbeam>();
    private boolean ignoreConfigChange = false;

    protected void startUp() {
        this.groundItemsLootBeamChange(false, false, true);
        this.mouseManager.registerMouseListener((MouseListener)this.inputListener);
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        this.executor.execute(this::reset);
        this.lastUsedItem = -1;
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown e) {
        if (this.rainbowRaveConfig.recolorLootBeams()) {
            this.restoreGroundItemLootBeams();
        }
    }

    protected void shutDown() {
        if (this.rainbowRaveConfig.recolorLootBeams()) {
            this.restoreGroundItemLootBeams();
        }
        this.mouseManager.unregisterMouseListener((MouseListener)this.inputListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
        this.highlightedItems.invalidateAll();
        this.highlightedItems = null;
        this.hiddenItems.invalidateAll();
        this.hiddenItems = null;
        this.hiddenItemList = null;
        this.highlightedItemsList = null;
        this.collectedGroundItems.clear();
        this.clientThread.invokeLater(this::removeAllLootbeams);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.ignoreConfigChange) {
            return;
        }
        if (event.getGroup().equals(GROUND_ITEMS_CONFIG_GROUP)) {
            if (event.getKey().equals(SHOW_LOOTBEAM_TIER_CONFIG_KEY)) {
                this.groundItemsLootBeamChange(true, false, false);
            } else if (event.getKey().equals(SHOW_LOOTBEAM_FOR_HIGHLIGHTED_CONFIG_KEY)) {
                this.groundItemsLootBeamChange(false, true, false);
            } else {
                this.executor.execute(this::reset);
            }
        } else if (event.getGroup().equals("rainbow_rave") && event.getKey().equals("recolorLootBeams")) {
            if (this.rainbowRaveConfig.recolorLootBeams()) {
                this.groundItemsLootBeamChange(false, false, true);
            } else {
                this.restoreGroundItemLootBeams();
            }
        }
    }

    private void groundItemsLootBeamChange(boolean tierChanged, boolean highlightedChanged, boolean turningOnRecolorLootBeams) {
        if (this.rainbowRaveConfig.recolorLootBeams()) {
            if (!turningOnRecolorLootBeams && SwingUtilities.isEventDispatchThread()) {
                this.clientThread.invoke(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Rainbow Rave: Please change loot beam settings through the rainbow rave plugin's settings, as rainbow rave needs to disable regular loot beams in order to recolor them.", "", false));
            }
            this.ignoreConfigChange = true;
            if (tierChanged || turningOnRecolorLootBeams) {
                HighlightTier highlightTier = this.config.showLootbeamTier();
                this.rainbowRaveConfig.setGroundItemsLootbeamTier(highlightTier);
                this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, SHOW_LOOTBEAM_TIER_CONFIG_KEY, (Object)HighlightTier.OFF);
            }
            if (highlightedChanged || turningOnRecolorLootBeams) {
                boolean showLootbeamForHighlighted = this.config.showLootbeamForHighlighted();
                this.rainbowRaveConfig.setGroundItemsHighlightedItemsLootbeam(showLootbeamForHighlighted);
                this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, SHOW_LOOTBEAM_FOR_HIGHLIGHTED_CONFIG_KEY, (Object)false);
            }
            this.ignoreConfigChange = false;
            this.executor.execute(this::reset);
        }
    }

    private void restoreGroundItemLootBeams() {
        HighlightTier tier = this.rainbowRaveConfig.getGroundItemsLootbeamTier();
        Boolean showLootbeamForHighlighted = this.rainbowRaveConfig.getGroundItemsHighlightedItemsLootbeam();
        this.ignoreConfigChange = true;
        this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, SHOW_LOOTBEAM_TIER_CONFIG_KEY, (Object)tier);
        this.configManager.setConfiguration(GROUND_ITEMS_CONFIG_GROUP, SHOW_LOOTBEAM_FOR_HIGHLIGHTED_CONFIG_KEY, (Object)showLootbeamForHighlighted);
        this.ignoreConfigChange = false;
        this.executor.execute(this::reset);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.collectedGroundItems.clear();
            this.lootbeams.clear();
        }
    }

    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        Tile tile = itemSpawned.getTile();
        GroundItem groundItem = this.buildGroundItem(tile, item);
        GroundItem existing = (GroundItem)this.collectedGroundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (existing != null) {
            existing.setQuantity(existing.getQuantity() + groundItem.getQuantity());
        } else {
            this.collectedGroundItems.put((Object)tile.getWorldLocation(), (Object)item.getId(), (Object)groundItem);
        }
        this.handleLootbeam(tile.getWorldLocation());
    }

    @Subscribe
    public void onItemDespawned(ItemDespawned itemDespawned) {
        TileItem item = itemDespawned.getItem();
        Tile tile = itemDespawned.getTile();
        GroundItem groundItem = (GroundItem)this.collectedGroundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (groundItem == null) {
            return;
        }
        if (groundItem.getQuantity() <= item.getQuantity()) {
            this.collectedGroundItems.remove((Object)tile.getWorldLocation(), (Object)item.getId());
        } else {
            groundItem.setQuantity(groundItem.getQuantity() - item.getQuantity());
            groundItem.setSpawnTime(null);
        }
        this.handleLootbeam(tile.getWorldLocation());
    }

    @Subscribe
    public void onItemQuantityChanged(ItemQuantityChanged itemQuantityChanged) {
        TileItem item = itemQuantityChanged.getItem();
        Tile tile = itemQuantityChanged.getTile();
        int oldQuantity = itemQuantityChanged.getOldQuantity();
        int newQuantity = itemQuantityChanged.getNewQuantity();
        int diff = newQuantity - oldQuantity;
        GroundItem groundItem = (GroundItem)this.collectedGroundItems.get((Object)tile.getWorldLocation(), (Object)item.getId());
        if (groundItem != null) {
            groundItem.setQuantity(groundItem.getQuantity() + diff);
        }
        this.handleLootbeam(tile.getWorldLocation());
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        Collection items = npcLootReceived.getItems();
        this.lootReceived(items, LootType.PVM);
    }

    @Subscribe
    public void onPlayerLootReceived(PlayerLootReceived playerLootReceived) {
        Collection items = playerLootReceived.getItems();
        this.lootReceived(items, LootType.PVP);
    }

    private void lootReceived(Collection<ItemStack> items, LootType lootType) {
        for (ItemStack itemStack : items) {
            WorldPoint location = WorldPoint.fromLocal((Client)this.client, (LocalPoint)itemStack.getLocation());
            GroundItem groundItem = (GroundItem)this.collectedGroundItems.get((Object)location, (Object)itemStack.getId());
            if (groundItem == null) continue;
            groundItem.setLootType(lootType);
        }
        items.stream().map(ItemStack::getLocation).map(l -> WorldPoint.fromLocal((Client)this.client, (LocalPoint)l)).distinct().forEach(this::handleLootbeam);
    }

    private GroundItem buildGroundItem(Tile tile, TileItem item) {
        int itemId = item.getId();
        ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
        int realItemId = itemComposition.getNote() != -1 ? itemComposition.getLinkedNoteId() : itemId;
        int alchPrice = itemComposition.getHaPrice();
        boolean dropped = tile.getWorldLocation().equals((Object)this.client.getLocalPlayer().getWorldLocation()) && this.droppedItemQueue.remove(itemId);
        boolean table = itemId == this.lastUsedItem && tile.getItemLayer().getHeight() > 0;
        GroundItem groundItem = GroundItem.builder().id(itemId).location(tile.getWorldLocation()).itemId(realItemId).quantity(item.getQuantity()).name(itemComposition.getName()).haPrice(alchPrice).height(tile.getItemLayer().getHeight()).tradeable(itemComposition.isTradeable()).lootType(dropped ? LootType.DROPPED : (table ? LootType.TABLE : LootType.UNKNOWN)).spawnTime(Instant.now()).stackable(itemComposition.isStackable()).build();
        if (realItemId == 995) {
            groundItem.setHaPrice(1);
            groundItem.setGePrice(1);
        } else {
            groundItem.setGePrice(this.itemManager.getItemPrice(realItemId));
        }
        return groundItem;
    }

    private void reset() {
        this.hiddenItemList = Text.fromCSV((String)this.config.getHiddenItems());
        this.highlightedItemsList = Text.fromCSV((String)this.config.getHighlightItems());
        this.highlightedItems = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new WildcardMatchLoader(this.highlightedItemsList));
        this.hiddenItems = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new WildcardMatchLoader(this.hiddenItemList));
        ImmutableList.Builder priceCheckBuilder = ImmutableList.builder();
        if (this.config.insaneValuePrice() > 0) {
            priceCheckBuilder.add((Object)new PriceHighlight(this.config.insaneValuePrice(), this.config.insaneValueColor()));
        }
        if (this.config.highValuePrice() > 0) {
            priceCheckBuilder.add((Object)new PriceHighlight(this.config.highValuePrice(), this.config.highValueColor()));
        }
        if (this.config.mediumValuePrice() > 0) {
            priceCheckBuilder.add((Object)new PriceHighlight(this.config.mediumValuePrice(), this.config.mediumValueColor()));
        }
        if (this.config.lowValuePrice() > 0) {
            priceCheckBuilder.add((Object)new PriceHighlight(this.config.lowValuePrice(), this.config.lowValueColor()));
        }
        this.priceChecks = priceCheckBuilder.build();
        this.clientThread.invokeLater(this::handleLootbeams);
    }

    Optional<Color> getHighlighted(NamedQuantity item, int gePrice, int haPrice) {
        if (Boolean.TRUE.equals(this.highlightedItems.getUnchecked((Object)item))) {
            return this.rainbowRaveConfig.colorHighlightedGroundItems() ? Optional.of(this.rainbowRavePlugin.getColor(item.getName().hashCode())) : Optional.empty();
        }
        if (Boolean.TRUE.equals(this.hiddenItems.getUnchecked((Object)item))) {
            return null;
        }
        int price = this.getValueByMode(gePrice, haPrice);
        if (price > this.config.insaneValuePrice()) {
            return this.colorForTier(RainbowRaveConfig.GroundItemsToColor.INSANE, item);
        }
        if (price > this.config.highValuePrice()) {
            return this.colorForTier(RainbowRaveConfig.GroundItemsToColor.HIGH, item);
        }
        if (price > this.config.mediumValuePrice()) {
            return this.colorForTier(RainbowRaveConfig.GroundItemsToColor.MEDIUM, item);
        }
        if (price > this.config.lowValuePrice()) {
            return this.colorForTier(RainbowRaveConfig.GroundItemsToColor.LOW, item);
        }
        return null;
    }

    private Optional<Color> colorForTier(RainbowRaveConfig.GroundItemsToColor tier, NamedQuantity item) {
        return this.rainbowRaveConfig.whichGroundItemsToColor().compareTo(tier) >= 0 ? Optional.of(this.rainbowRavePlugin.getColor(item.getName().hashCode())) : Optional.empty();
    }

    Optional<Color> getHidden(NamedQuantity item, int gePrice, int haPrice, boolean isTradeable) {
        boolean underHa;
        boolean isExplicitHidden = Boolean.TRUE.equals(this.hiddenItems.getUnchecked((Object)item));
        boolean isExplicitHighlight = Boolean.TRUE.equals(this.highlightedItems.getUnchecked((Object)item));
        boolean canBeHidden = gePrice > 0 || isTradeable || !this.config.dontHideUntradeables();
        boolean underGe = gePrice < this.config.getHideUnderValue();
        boolean bl = underHa = haPrice < this.config.getHideUnderValue();
        return isExplicitHidden || !isExplicitHighlight && canBeHidden && underGe && underHa ? (this.rainbowRaveConfig.whichGroundItemsToColor().compareTo(RainbowRaveConfig.GroundItemsToColor.HIDDEN) >= 0 ? Optional.of(this.rainbowRavePlugin.getColor(item.getName().hashCode())) : Optional.empty()) : null;
    }

    Optional<Color> getItemColor(Optional<Color> highlighted, Optional<Color> hidden, NamedQuantity item) {
        if (highlighted != null) {
            return highlighted;
        }
        if (hidden != null) {
            return hidden;
        }
        return this.rainbowRaveConfig.whichGroundItemsToColor().compareTo(RainbowRaveConfig.GroundItemsToColor.REGULAR) >= 0 ? Optional.of(this.rainbowRavePlugin.getColor(item.getName().hashCode())) : Optional.empty();
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.setHotKeyPressed(false);
        }
    }

    private int getValueByMode(int gePrice, int haPrice) {
        switch (this.config.valueCalculationMode()) {
            case GE: {
                return gePrice;
            }
            case HA: {
                return haPrice;
            }
        }
        return Math.max(gePrice, haPrice);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        if (menuOptionClicked.isItemOp() && menuOptionClicked.getMenuOption().equals("Drop")) {
            int itemId = menuOptionClicked.getItemId();
            this.droppedItemQueue.add(itemId);
        } else if (menuOptionClicked.getMenuAction() == MenuAction.WIDGET_TARGET_ON_GAME_OBJECT && this.client.getSelectedWidget().getId() == WidgetInfo.INVENTORY.getId()) {
            this.lastUsedItem = this.client.getSelectedWidget().getItemId();
        }
    }

    private void handleLootbeam(WorldPoint worldPoint) {
        if (!this.rainbowRaveConfig.recolorLootBeams() || !this.rainbowRaveConfig.getGroundItemsHighlightedItemsLootbeam() && this.rainbowRaveConfig.getGroundItemsLootbeamTier() == HighlightTier.OFF) {
            this.removeLootbeam(worldPoint);
            return;
        }
        int price = -1;
        Collection groundItems = this.collectedGroundItems.row((Object)worldPoint).values();
        for (GroundItem groundItem : groundItems) {
            if (this.config.onlyShowLoot() && !groundItem.isMine()) continue;
            NamedQuantity item = new NamedQuantity(groundItem);
            if (this.rainbowRaveConfig.getGroundItemsHighlightedItemsLootbeam() && Boolean.TRUE.equals(this.highlightedItems.getUnchecked((Object)item))) {
                this.addLootbeam(worldPoint, this.config.highlightedColor(), null);
                return;
            }
            if (Boolean.TRUE.equals(this.hiddenItems.getUnchecked((Object)item))) continue;
            int itemPrice = this.getValueByMode(groundItem.getGePrice(), groundItem.getHaPrice());
            price = Math.max(itemPrice, price);
        }
        if (this.rainbowRaveConfig.getGroundItemsLootbeamTier() != HighlightTier.OFF) {
            for (PriceHighlight highlight : this.priceChecks) {
                if (price <= highlight.getPrice() || price <= this.rainbowRaveConfig.getGroundItemsLootbeamTier().getValueFromTier(this.config)) continue;
                this.addLootbeam(worldPoint, highlight.color, this.rainbowRaveConfig.getGroundItemsLootbeamTier());
                return;
            }
        }
        this.removeLootbeam(worldPoint);
    }

    private void handleLootbeams() {
        for (WorldPoint worldPoint : this.collectedGroundItems.rowKeySet()) {
            this.handleLootbeam(worldPoint);
        }
    }

    private void removeAllLootbeams() {
        for (Lootbeam lootbeam : this.lootbeams.values()) {
            lootbeam.remove();
        }
        this.lootbeams.clear();
    }

    private void addLootbeam(WorldPoint worldPoint, Color color, HighlightTier tier) {
        Lootbeam lootbeam = this.lootbeams.get(worldPoint);
        if (lootbeam == null) {
            lootbeam = new Lootbeam(this.client, this.clientThread, worldPoint, color, this.config.lootbeamStyle().name(), tier);
            this.lootbeams.put(worldPoint, lootbeam);
        } else {
            lootbeam.setColor(color);
            lootbeam.setStyle(this.config.lootbeamStyle().name());
        }
    }

    private void removeLootbeam(WorldPoint worldPoint) {
        Lootbeam lootbeam = this.lootbeams.remove(worldPoint);
        if (lootbeam != null) {
            lootbeam.remove();
        }
    }

    Map.Entry<Rectangle, GroundItem> getTextBoxBounds() {
        return this.textBoxBounds;
    }

    void setTextBoxBounds(Map.Entry<Rectangle, GroundItem> textBoxBounds) {
        this.textBoxBounds = textBoxBounds;
    }

    Map.Entry<Rectangle, GroundItem> getHiddenBoxBounds() {
        return this.hiddenBoxBounds;
    }

    void setHiddenBoxBounds(Map.Entry<Rectangle, GroundItem> hiddenBoxBounds) {
        this.hiddenBoxBounds = hiddenBoxBounds;
    }

    Map.Entry<Rectangle, GroundItem> getHighlightBoxBounds() {
        return this.highlightBoxBounds;
    }

    void setHighlightBoxBounds(Map.Entry<Rectangle, GroundItem> highlightBoxBounds) {
        this.highlightBoxBounds = highlightBoxBounds;
    }

    boolean isHotKeyPressed() {
        return this.hotKeyPressed;
    }

    void setHotKeyPressed(boolean hotKeyPressed) {
        this.hotKeyPressed = hotKeyPressed;
    }

    boolean isHideAll() {
        return this.hideAll;
    }

    void setHideAll(boolean hideAll) {
        this.hideAll = hideAll;
    }

    public Table<WorldPoint, Integer, GroundItem> getCollectedGroundItems() {
        return this.collectedGroundItems;
    }

    static final class PriceHighlight {
        private final int price;
        private final Color color;

        public PriceHighlight(int price, Color color) {
            this.price = price;
            this.color = color;
        }

        public int getPrice() {
            return this.price;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PriceHighlight)) {
                return false;
            }
            PriceHighlight other = (PriceHighlight)o;
            if (this.getPrice() != other.getPrice()) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPrice();
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            return result;
        }

        public String toString() {
            return "RainbowRaveGroundItemsPlugin.PriceHighlight(price=" + this.getPrice() + ", color=" + this.getColor() + ")";
        }
    }
}

