/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import com.rainbowrave.Theme;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.plugins.grounditems.config.HighlightTier;

@ConfigGroup(value="rainbow_rave")
public interface RainbowRaveConfig
extends Config {
    public static final String LOOT_BEAMS_TIER_CONFIG_KEY = "groundItemsLootbeamTier";
    public static final String LOOT_BEAMS_HIGHLIGHT_CONFIG_KEY = "groundItemsHighlightedItemsLootbeam";
    public static final String OLD_TILE_COLOR_WAVES_KEY = "smoothWaves";
    public static final String GROUND_MARKER_COLOR_MODE_KEY = "groundMarkerColorMode";
    public static final String RECOLOR_LOOT_BEAMS_KEY = "recolorLootBeams";
    @ConfigSection(name="Tile Indicators", description="Tile Indicators", position=150)
    public static final String tileIndicatorsSection = "tileIndicatorsSection";

    @ConfigItem(keyName="theme", name="Theme", description="The color theme used for highlighting things.", position=0)
    default public Theme theme() {
        return Theme.RAINBOW;
    }

    @ConfigItem(keyName="colorSpeed", name="Color speed (ms)", description="How fast the colors change (ms per full cycle)", position=0)
    default public int colorSpeed() {
        return 6000;
    }

    @ConfigItem(keyName="syncColor", name="Sync colors", description="Make all highlighted things be the same color as each other.", position=1)
    default public boolean syncColor() {
        return false;
    }

    @ConfigItem(keyName="highlightSelf", name="Highlight self", description="Highlight your own player character. Uses Npc Indicator's settings.", position=2)
    default public boolean highlightSelf() {
        return false;
    }

    @ConfigItem(keyName="highlightOthers", name="Highlight others", description="Highlight other players' characters. Uses Npc Indicator's settings.", position=3)
    default public boolean highlightOthers() {
        return false;
    }

    @ConfigItem(keyName="whichNpcsToHighlight", name="Npc highlight", description="Which npcs to highlight", position=4)
    default public NpcsToHighlight whichNpcsToHighlight() {
        return NpcsToHighlight.SAME;
    }

    @ConfigItem(keyName="rainbowTileMarkers", name="Rainbow tile markers", description="Make tile markers rainbow", position=5)
    default public boolean rainbowTileMarkers() {
        return true;
    }

    @ConfigItem(name="Tile Color Mode", description="\"waves\" makes tile color smooth between adjacent tiles, and \"color sync\" makes tiles with the same color in ground markers share the same color.", keyName="groundMarkerColorMode", position=6)
    default public GroundMarkerColorMode groundMarkerColorMode() {
        return GroundMarkerColorMode.RANDOM;
    }

    @ConfigItem(name="Fill tiles", description="Fills the tile with an opaque square.", keyName="fillTiles", position=7)
    default public boolean fillTiles() {
        return false;
    }

    @ConfigItem(name="Brush Marker Tiles", description="Applies rainbow to tile markers from the \"Brush Markers\" plugin hub plugin. This plugin can be used to mark lots of tiles at once.", keyName="useBrushMarkerTiles", position=8)
    default public boolean useBrushMarkerTiles() {
        return false;
    }

    @ConfigItem(name="Object highlight", description="Which objects to highlight.", keyName="whichObjectsToHighlight", position=9)
    default public ObjectsToHighlight whichObjectsToHighlight() {
        return ObjectsToHighlight.SAME;
    }

    @ConfigItem(name="Inventory tags", description="Which items to tag.", keyName="whichItemsToInventoryTag", position=10)
    default public ItemsToTag whichItemsToInventoryTag() {
        return ItemsToTag.SAME;
    }

    @ConfigItem(name="Highlight Ground Items", description="Applies rainbow to highlighted items.", keyName="colorHighlightedGroundItems", position=11)
    default public boolean colorHighlightedGroundItems() {
        return true;
    }

    @ConfigItem(name="Ground Items", description="Items in this tier and above are colored.", keyName="whichGroundItemsToColor", position=12)
    default public GroundItemsToColor whichGroundItemsToColor() {
        return GroundItemsToColor.REGULAR;
    }

    @ConfigItem(name="Scythe swings", description="Recolor scythe swings. Swing trails may not return to normal after disabling.", keyName="recolorScytheSwings", position=13)
    default public boolean recolorScytheSwings() {
        return false;
    }

    @ConfigItem(keyName="recolorLootBeams", name="Loot beams", description="Recolor loot beams.", position=14)
    default public boolean recolorLootBeams() {
        return true;
    }

    @ConfigItem(keyName="whichMouseTrailStyle", name="Mouse Trail Style", description="Which trail style to use.", position=16)
    default public MouseTrailStyle whichMouseTrailStyle() {
        return MouseTrailStyle.NONE;
    }

    @ConfigItem(keyName="groundItemsLootbeamTier", name="Lootbeam tier", description="The lowest tier of which lootbeams should be shown for. You should modify this setting instead of the identical setting in Ground items, if you are using rainbow rave to recolor loot beams.", position=101)
    default public HighlightTier getGroundItemsLootbeamTier() {
        return HighlightTier.OFF;
    }

    @ConfigItem(keyName="groundItemsLootbeamTier", name="", description="", hidden=true)
    default public void setGroundItemsLootbeamTier(HighlightTier tier) {
    }

    @ConfigItem(keyName="groundItemsHighlightedItemsLootbeam", name="Highlighted item lootbeams", description="Show lootbeams for highlighted items. You should modify this setting instead of the identical setting in Ground items, if you are using rainbow rave to recolor loot beams.", position=100)
    default public boolean getGroundItemsHighlightedItemsLootbeam() {
        return false;
    }

    @ConfigItem(keyName="groundItemsHighlightedItemsLootbeam", name="", description="", hidden=true)
    default public void setGroundItemsHighlightedItemsLootbeam(boolean lootbeamsForHighlightedItems) {
    }

    @ConfigItem(keyName="recolorDukeLights", name="Duke rave", description="Recolor the lights at duke. Duke lights may not return to normal after disabling.", position=110)
    default public boolean dukeRave() {
        return false;
    }

    @ConfigItem(keyName="recolorTileIndicators", name="Tile indicators", description="Recolor the tiles from the tile indicators plugin.", section="tileIndicatorsSection", position=150)
    default public boolean recolorTileIndicators() {
        return false;
    }

    @ConfigItem(keyName="recolorTileIndicatorFill", name="Also recolor fill", description="Recolor the fill color of tile indicators as well", section="tileIndicatorsSection", position=151)
    default public boolean recolorTileIndicatorFill() {
        return false;
    }

    @ConfigItem(keyName="preferCornerTileIndicatorsConfig", name="Prefer \"Corner tile indicators\"", description="Prefers to use the config from my \"Corner tile indicators\" plugin, if it is installed, including true tile fadeout and corner-only highlight.", section="tileIndicatorsSection", position=152)
    default public boolean preferCornerTileIndicatorsConfig() {
        return false;
    }

    public static enum MouseTrailStyle {
        NONE,
        ENABLED,
        SYNCED,
        PARTYMODE;

    }

    public static enum GroundMarkerColorMode {
        WAVES,
        RANDOM,
        COLOR_SYNC;

    }

    public static enum GroundItemsToColor {
        NONE(HighlightTier.INSANE.ordinal() + 1),
        INSANE(HighlightTier.INSANE.ordinal()),
        HIGH(HighlightTier.HIGH.ordinal()),
        MEDIUM(HighlightTier.MEDIUM.ordinal()),
        LOW(HighlightTier.LOW.ordinal()),
        REGULAR(HighlightTier.LOW.ordinal() - 1),
        HIDDEN(HighlightTier.LOW.ordinal() - 2);

        public final int highlightTierRelativeOrdinal;

        private GroundItemsToColor(int highlightTierRelativeOrdinal) {
            this.highlightTierRelativeOrdinal = highlightTierRelativeOrdinal;
        }
    }

    public static enum ItemsToTag {
        NONE,
        SAME,
        ALL;

    }

    public static enum ObjectsToHighlight {
        NONE,
        SAME,
        ALL;

    }

    public static enum NpcsToHighlight {
        NONE,
        SAME,
        ALL;

    }
}

