/*
 * Decompiled with CFR 0.152.
 */
package com.rainbowrave;

import java.awt.Color;

public class PerceptualGradient {
    private static final double GAMMA = 0.43;
    private final float[] normalizedStartColor;
    private final float[] normalizedEndColor;
    private final float startColorBrightness;
    private final float endColorBrightness;

    PerceptualGradient(Color startColor, Color endColor) {
        this.normalizedStartColor = this.normalize(startColor);
        this.normalizedEndColor = this.normalize(endColor);
        this.startColorBrightness = (float)Math.pow(this.sum(this.normalizedStartColor), 0.43);
        this.endColorBrightness = (float)Math.pow(this.sum(this.normalizedEndColor), 0.43);
    }

    public Color getColorMix(float frac) {
        int i;
        float intensity = (float)Math.pow(this.lerp(this.startColorBrightness, this.endColorBrightness, frac), 2.3255813953488373);
        float total = 0.0f;
        float[] components = new float[3];
        for (i = 0; i < components.length; ++i) {
            components[i] = this.lerp(this.normalizedStartColor[i], this.normalizedEndColor[i], frac);
            total += components[i];
        }
        if (total != 0.0f) {
            for (i = 0; i < components.length; ++i) {
                components[i] = components[i] * intensity / total;
            }
        }
        for (i = 0; i < components.length; ++i) {
            float x = components[i];
            components[i] = (double)x <= 0.0031308 ? (float)(12.92 * (double)x) : (float)(1.055 * Math.pow(x, 0.4166666666666667) - 0.055);
        }
        return new Color(components[0], components[1], components[2]);
    }

    public float sum(float[] array) {
        float sum = 0.0f;
        for (float v : array) {
            sum += v;
        }
        return sum;
    }

    private float[] normalize(Color color) {
        float[] components = new float[]{color.getRed(), color.getGreen(), color.getBlue()};
        for (int i = 0; i < components.length; ++i) {
            float x = components[i];
            double y = (double)(x = (float)((double)x / 255.0)) <= 0.04045 ? (double)x / 12.92 : Math.pow(((double)x + 0.055) / 1.055, 2.4);
            components[i] = (float)y;
        }
        return components;
    }

    private float lerp(float color1, float color2, float frac) {
        return color1 * (1.0f - frac) + color2 * frac;
    }
}

