/*
 * Decompiled with CFR 0.152.
 */
package com.mlmupperlevelmarkers;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.mlmupperlevelmarkers.MLMUpperLevelMarkersConfig;
import com.mlmupperlevelmarkers.MLMUpperLevelMarkersOverlay;
import com.mlmupperlevelmarkers.OreVeinState;
import com.mlmupperlevelmarkers.StateTimePair;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Perspective;
import net.runelite.api.WallObject;
import net.runelite.api.coords.Angle;
import net.runelite.api.coords.Direction;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="MLM Upper Level Markers", description="Adds markers to veins that have been mined in upper MLM", tags={"motherlode", "mine", "marker", "mlm", "mining"})
public class MLMUpperLevelMarkersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MLMUpperLevelMarkersPlugin.class);
    private static final int UPPER_FLOOR_HEIGHT = -490;
    private static final Set<Integer> MOTHERLODE_MAP_REGIONS = ImmutableSet.of((Object)14679, (Object)14680, (Object)14681, (Object)14935, (Object)14936, (Object)14937, (Object[])new Integer[]{15191, 15192, 15193});
    private static final Set<Integer> MINE_SPOTS = ImmutableSet.of((Object)26661, (Object)26662, (Object)26663, (Object)26664);
    private static final Set<Integer> DEPLETED_SPOTS = ImmutableSet.of((Object)26665, (Object)26666, (Object)26667, (Object)26668);
    private static final Set<Integer> MINING_ANIMATION_IDS = ImmutableSet.of((Object)6753, (Object)6754, (Object)6755, (Object)3866, (Object)6757, (Object)6756, (Object[])new Integer[]{6752, 8312, 6758, 335, 8344, 8886, 4481, 7282, 8345, 8786});
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MLMUpperLevelMarkersConfig config;
    @Inject
    private MLMUpperLevelMarkersOverlay overlay;
    private boolean inMLM;
    private final Map<WorldPoint, StateTimePair> oreVeinStateMap = new ConcurrentHashMap<WorldPoint, StateTimePair>();
    private final Map<Actor, Integer> actorAnimCountMap = new HashMap<Actor, Integer>();
    private final Map<Actor, WorldPoint> actorLastAnimWPMap = new HashMap<Actor, WorldPoint>();

    @Provides
    MLMUpperLevelMarkersConfig provideConfig(ConfigManager configManager) {
        return (MLMUpperLevelMarkersConfig)configManager.getConfig(MLMUpperLevelMarkersConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.inMLM = this.checkInMLM();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.oreVeinStateMap.clear();
        this.actorAnimCountMap.clear();
        this.actorLastAnimWPMap.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOADING: {
                this.oreVeinStateMap.clear();
                this.actorAnimCountMap.clear();
                this.actorLastAnimWPMap.clear();
                this.inMLM = this.checkInMLM();
                break;
            }
            case LOGIN_SCREEN: {
                this.inMLM = false;
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("mlmupperlevelmarkers") && event.getKey().equals("higherRenderPriority") && this.overlay != null) {
            this.overlayManager.remove((Overlay)this.overlay);
            this.overlay.setPriority(this.config.higherRenderPriority());
            this.overlayManager.add((Overlay)this.overlay);
        }
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned event) {
        Actor actor = event.getActor();
        this.actorAnimCountMap.remove(actor);
        this.actorLastAnimWPMap.remove(actor);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        WallObject obj;
        if (!this.inMLM) {
            return;
        }
        Actor actor = animationChanged.getActor();
        if (!MINING_ANIMATION_IDS.contains(actor.getAnimation())) {
            return;
        }
        WorldPoint actorWP = actor.getWorldLocation();
        int animCount = this.actorAnimCountMap.getOrDefault(actor, 0) + 1;
        if (this.actorLastAnimWPMap.containsKey(actor) && !this.actorLastAnimWPMap.get(actor).equals((Object)actorWP)) {
            animCount = 1;
        }
        this.actorAnimCountMap.put(actor, animCount);
        this.actorLastAnimWPMap.put(actor, actorWP);
        if (animCount < 2) {
            return;
        }
        WorldPoint target = MLMUpperLevelMarkersPlugin.getWorldLocationInFront(actor);
        LocalPoint localTarget = LocalPoint.fromWorld((Client)this.client, (WorldPoint)target);
        if (localTarget != null && this.isUpstairs(localTarget) && (obj = this.client.getScene().getTiles()[0][localTarget.getSceneX()][localTarget.getSceneY()].getWallObject()) != null && MINE_SPOTS.contains(obj.getId())) {
            StateTimePair prevValue;
            Instant now = Instant.now();
            if (this.oreVeinStateMap.containsKey(target)) {
                prevValue = this.oreVeinStateMap.get(target);
                int respawnSeconds = this.config.getRespawnTimeout();
                if (respawnSeconds >= 0 && Duration.between(prevValue.getTime(), now).compareTo(Duration.ofSeconds(respawnSeconds)) >= 0) {
                    prevValue.setState(OreVeinState.Untouched);
                    prevValue.setTime(now);
                }
            } else {
                prevValue = StateTimePair.builder().state(OreVeinState.Untouched).time(now).build();
            }
            if (prevValue.getState() != OreVeinState.MinedBySelf) {
                OreVeinState newState;
                OreVeinState oreVeinState = newState = actor == this.client.getLocalPlayer() ? OreVeinState.MinedBySelf : OreVeinState.MinedByOther;
                if (newState != prevValue.getState()) {
                    prevValue.setState(newState);
                    this.oreVeinStateMap.putIfAbsent(target, prevValue);
                }
            }
        }
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned event) {
        if (!this.inMLM) {
            return;
        }
        WallObject obj = event.getWallObject();
        if (DEPLETED_SPOTS.contains(obj.getId()) && this.isUpstairs(obj.getLocalLocation())) {
            this.oreVeinStateMap.remove(obj.getWorldLocation());
        }
    }

    private boolean checkInMLM() {
        GameState gameState = this.client.getGameState();
        if (gameState != GameState.LOGGED_IN && gameState != GameState.LOADING) {
            return false;
        }
        for (int region : this.client.getMapRegions()) {
            if (MOTHERLODE_MAP_REGIONS.contains(region)) continue;
            return false;
        }
        return true;
    }

    boolean isUpstairs(LocalPoint localPoint) {
        return Perspective.getTileHeight((Client)this.client, (LocalPoint)localPoint, (int)0) < -490;
    }

    private static WorldPoint getWorldLocationInFront(Actor actor) {
        Direction orientation = new Angle(actor.getOrientation()).getNearestDirection();
        int dx = 0;
        int dy = 0;
        switch (orientation) {
            case SOUTH: {
                dy = -1;
                break;
            }
            case WEST: {
                dx = -1;
                break;
            }
            case NORTH: {
                dy = 1;
                break;
            }
            case EAST: {
                dx = 1;
            }
        }
        WorldPoint currWP = actor.getWorldLocation();
        return new WorldPoint(currWP.getX() + dx, currWP.getY() + dy, currWP.getPlane());
    }

    boolean isInMLM() {
        return this.inMLM;
    }

    Map<WorldPoint, StateTimePair> getOreVeinStateMap() {
        return this.oreVeinStateMap;
    }
}

