/*
 * Decompiled with CFR 0.152.
 */
package com.mlmupperlevelmarkers;

import com.mlmupperlevelmarkers.MLMUpperLevelMarkersConfig;
import com.mlmupperlevelmarkers.MLMUpperLevelMarkersPlugin;
import com.mlmupperlevelmarkers.MarkerTimerMode;
import com.mlmupperlevelmarkers.OreVeinState;
import com.mlmupperlevelmarkers.StateTimePair;
import com.mlmupperlevelmarkers.TileMarkerType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.components.TextComponent;

class MLMUpperLevelMarkersOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private final Client client;
    private final MLMUpperLevelMarkersPlugin plugin;
    private final MLMUpperLevelMarkersConfig config;
    private final TextComponent textComponent = new TextComponent();

    @Inject
    MLMUpperLevelMarkersOverlay(Client client, MLMUpperLevelMarkersPlugin plugin, MLMUpperLevelMarkersConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(config.higherRenderPriority());
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public void setPriority(boolean higher) {
        this.setPriority(higher ? OverlayPriority.MED : OverlayPriority.LOW);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInMLM()) {
            return null;
        }
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return null;
        }
        LocalPoint playerLocalPoint = localPlayer.getLocalLocation();
        if (this.config.showOnlyWhenUpstairs() && !this.plugin.isUpstairs(playerLocalPoint)) {
            return null;
        }
        Duration firstTimeout = Duration.ofSeconds(this.config.getFirstTimeout());
        Duration secondTimeout = Duration.ofSeconds(this.config.getSecondTimeout());
        Duration respawnTimeout = Duration.ofSeconds(this.config.getRespawnTimeout());
        MarkerTimerMode timerMode = this.config.getMarkerTimerMode();
        int offset = this.config.getMarkerTimerOffset();
        TileMarkerType markerType = this.config.tileMarkerType();
        Instant now = Instant.now();
        DecimalFormat timerDecimalFormat = new DecimalFormat(this.config.showMarkerTimerDecimal() ? "0.0" : "0");
        timerDecimalFormat.setRoundingMode(RoundingMode.CEILING);
        for (Map.Entry<WorldPoint, StateTimePair> entry : this.plugin.getOreVeinStateMap().entrySet()) {
            String label;
            Point canvasTextLocation;
            Polygon poly;
            Color color;
            OreVeinState state = entry.getValue().getState();
            Instant time = entry.getValue().getTime();
            Duration sinceTime = Duration.between(time, now);
            LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)entry.getKey());
            if (localPoint == null || respawnTimeout.getSeconds() >= 0L && sinceTime.compareTo(respawnTimeout) >= 0) continue;
            switch (state) {
                case MinedBySelf: {
                    color = this.config.getSelfMarkerColor();
                    break;
                }
                case MinedByOther: {
                    color = this.config.showOtherMarkers() ? this.config.getOtherMarkerColor() : null;
                    break;
                }
                default: {
                    color = null;
                }
            }
            if (color == null || playerLocalPoint.distanceTo(localPoint) > 2350 || (poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint)) == null) continue;
            long t1 = firstTimeout.getSeconds();
            long t2 = secondTimeout.getSeconds();
            if (t1 >= 0L && sinceTime.compareTo(firstTimeout) >= 0) {
                color = color.darker();
            }
            if (t2 >= 0L && sinceTime.compareTo(secondTimeout) >= 0) {
                color = color.darker();
            }
            t1 = Math.max(t1, 0L);
            t2 = Math.max(t2, 0L);
            long maxt = Math.max(t1, t2);
            double timeLeftMax = (float)Duration.between(now, time.plusSeconds(maxt)).toMillis() / 1000.0f;
            switch (markerType) {
                case CONTOUR_TIMER: {
                    long target;
                    double timeLeft;
                    if (timeLeftMax <= 0.0) {
                        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
                        break;
                    }
                    long mint = Math.min(t1, t2);
                    double timeLeftMin = (float)Duration.between(now, time.plusSeconds(mint)).toMillis() / 1000.0f;
                    if (timeLeftMin > 0.0) {
                        timeLeft = timeLeftMin;
                        target = mint;
                    } else {
                        timeLeft = timeLeftMax;
                        target = maxt - mint;
                    }
                    MLMUpperLevelMarkersOverlay.renderTileWithMovingColor(graphics, poly, color, color.darker(), timeLeft / (double)target);
                    break;
                }
                case NORMAL: {
                    OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
                }
            }
            Double secs = null;
            switch (timerMode) {
                case Timeout: {
                    if (!(timeLeftMax > 0.0)) break;
                    secs = timeLeftMax;
                    break;
                }
                case PersistentTimeout: {
                    secs = Math.max(0.0, timeLeftMax);
                    break;
                }
                case Counter: {
                    secs = (double)sinceTime.toMillis() / 1000.0;
                }
            }
            if (secs == null || (canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)localPoint, (String)(label = timerDecimalFormat.format(secs)), (int)offset)) == null) continue;
            this.textComponent.setText(label);
            this.textComponent.setColor(color);
            this.textComponent.setOutline(this.config.showMarkerTimerOutline());
            this.textComponent.setPosition(new java.awt.Point(canvasTextLocation.getX(), canvasTextLocation.getY()));
            this.textComponent.render(graphics);
        }
        return null;
    }

    public static void renderTileWithMovingColor(Graphics2D graphics, Polygon poly, Color color, Color color2, double interpolate) {
        if (interpolate <= 0.0) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color2);
            return;
        }
        if (interpolate >= 1.0) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color);
            return;
        }
        int numPoints = poly.npoints;
        int interpolatedLine = (int)((double)numPoints * interpolate);
        double actualInterpolate = (double)numPoints * interpolate - (double)interpolatedLine;
        Path2D.Double p1 = new Path2D.Double();
        Path2D.Double p2 = new Path2D.Double();
        ((Path2D)p1).moveTo(poly.xpoints[0], poly.ypoints[0]);
        Path2D.Double curP = p1;
        for (int i = 0; i < numPoints; ++i) {
            int j = (i + 1) % numPoints;
            int x2 = poly.xpoints[j];
            int y2 = poly.ypoints[j];
            if (i == interpolatedLine) {
                int x1 = poly.xpoints[i];
                int y1 = poly.ypoints[i];
                double interX = MLMUpperLevelMarkersOverlay.lerp(x1, x2, actualInterpolate);
                double interY = MLMUpperLevelMarkersOverlay.lerp(y1, y2, actualInterpolate);
                ((Path2D)curP).lineTo(interX, interY);
                curP = p2;
                ((Path2D)curP).moveTo(interX, interY);
            }
            ((Path2D)curP).lineTo(x2, y2);
        }
        Object prevStrokeControl = graphics.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Stroke originalStroke = graphics.getStroke();
        graphics.setStroke(new BasicStroke(2.0f, 0, 2));
        graphics.setColor(color);
        graphics.draw(p1);
        graphics.setColor(color2);
        graphics.draw(p2);
        graphics.setColor(new Color(0, 0, 0, 50));
        graphics.fill(poly);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, prevStrokeControl);
        graphics.setStroke(originalStroke);
    }

    private static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }
}

