/*
 * Decompiled with CFR 0.152.
 */
package com.mlmupperlevelmarkers;

import com.mlmupperlevelmarkers.MarkerTimerMode;
import com.mlmupperlevelmarkers.TileMarkerType;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="mlmupperlevelmarkers")
public interface MLMUpperLevelMarkersConfig
extends Config {
    public static final String CONFIG_GROUP_NAME = "mlmupperlevelmarkers";
    public static final String HIGHER_RENDER_PRIORITY_KEY_NAME = "higherRenderPriority";

    @Alpha
    @ConfigItem(keyName="selfMarkerColor", name="Self Marker Color", description="Color of markers on veins you've mined.", position=1)
    default public Color getSelfMarkerColor() {
        return Color.GREEN;
    }

    @Alpha
    @ConfigItem(keyName="otherMarkerColor", name="Other Marker Color", description="Color of markers on veins other players have mined.", position=2)
    default public Color getOtherMarkerColor() {
        return Color.YELLOW;
    }

    @ConfigItem(keyName="tileMarkerType", name="Tile Marker Type", description="Choose a Tile Marker type.<br>Hidden: Hides the tile markers, useful to reduce clutter if using marker timers.<br>Normal: Shows regular tile markers.<br>Contour Timer: Makes the contour of the tile markers behave as a pie-chart of sorts with the timeouts.", position=3)
    default public TileMarkerType tileMarkerType() {
        return TileMarkerType.NORMAL;
    }

    @ConfigItem(keyName="showOtherMarkers", name="Show Other Players' Markers", description="Add markers to veins other players have mined.", position=4)
    default public boolean showOtherMarkers() {
        return true;
    }

    @ConfigItem(keyName="showOnlyWhenUpstairs", name="Show Only When Upstairs", description="Only show markers if you are upstairs.", position=5)
    default public boolean showOnlyWhenUpstairs() {
        return true;
    }

    @ConfigItem(keyName="firstTimeout", name="First Timeout", description="Darkens the marker after a vein has been first mined for this long (-1 to disable).", position=6)
    @Units(value="s")
    @Range(min=-1)
    default public int getFirstTimeout() {
        return 15;
    }

    @ConfigItem(keyName="secondTimeout", name="Second Timeout", description="Darkens the marker again after a vein has been first mined for this long (-1 to disable).", position=7)
    @Units(value="s")
    @Range(min=-1)
    default public int getSecondTimeout() {
        return 27;
    }

    @ConfigItem(keyName="respawnTimeout", name="Respawn Timeout", description="Deletes the marker for a vein when it's been this long after first being mined (-1 to disable).", position=8)
    @Units(value="s")
    @Range(min=-1)
    default public int getRespawnTimeout() {
        return 120;
    }

    @ConfigItem(keyName="markerTimerMode", name="Marker Timer Mode", description="Shows a timer on the marked tiles.<br>Hidden: No timer is shown.<br>Timeout: Counts down from the max of the two timeout values.<br>Timeout (p): Same as Timeout, but persists when it reaches 0.<br>Counter: Counts up from when a vein is first mined.", position=9)
    default public MarkerTimerMode getMarkerTimerMode() {
        return MarkerTimerMode.Off;
    }

    @ConfigItem(keyName="showMarkerTimerDecimal", name="Show Marker Timer Decimal", description="Shows the tenth of seconds decimal on the marker timers.", position=10)
    default public boolean showMarkerTimerDecimal() {
        return true;
    }

    @ConfigItem(keyName="markerTimerOutline", name="Show Marker Timer Outline", description="Show an outline around the text of the marker timers.", position=11)
    default public boolean showMarkerTimerOutline() {
        return true;
    }

    @ConfigItem(keyName="markerTimerOffset", name="Marker Timer Offset", description="Adjust the height offset of the marker timers.", position=12)
    @Range(min=-500, max=500)
    default public int getMarkerTimerOffset() {
        return 0;
    }

    @ConfigItem(keyName="higherRenderPriority", name="Render Above Motherlode Icons", description="Gives a higher rendering priority to the markers and timers,<br>allowing them to appear above the Motherlode plugin mining icons.", position=13)
    default public boolean higherRenderPriority() {
        return false;
    }
}

