/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.BossNameConfig;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Boss Name Replacer", description="Replaces Boss names with funny things", tags={"Boss name", "Name", "Its Will"}, enabledByDefault=true)
public class BossNamePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BossNamePlugin.class);
    @Inject
    private Client client;
    @Inject
    private BossNameConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private final Random r = new Random();
    private final List<String> spawnPhrases = Arrays.asList("It's grumblin time!", "No pet?", "Prepare to be grumbled!", "You are no match for The Grumbler!", "Grumbler SMASH!", "Who dares awaken The Grumbler!", "I\u2019m not fat. I\u2019m cultivating mass");
    private final List<String> killPhrases = Arrays.asList("Ive been grumbled!", "Im gunna grumble!", "F", "Ive been out grumbled", "My grumble sense is tingling", "The Grumbler has been bested!", "Back to the grumble cave i go...", "Not my grumble goop!");

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessageNode().getType() == ChatMessageType.GAMEMESSAGE) {
            if (event.getMessage().contains("Phantom Muspah")) {
                event.getMessageNode().setValue(event.getMessage().replace("Phantom Muspah", "Grumbler"));
            }
            if (event.getMessage().contains("Muphin") && this.config.renamePet()) {
                event.getMessageNode().setValue(event.getMessage().replace("Muphin", "Lil' Grumble"));
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuEntry().getTarget().contains("The Grumbler") && event.getMenuEntry().getType() == MenuAction.EXAMINE_NPC) {
            event.consume();
            String grumblerLore = "Let me tell you something. I haven\u2019t even begun to grumble. And when I do grumble, you\u2019ll know. Because I\u2019m gonna grumble so hard that my grumble goo is gunna go everywhere!";
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(grumblerLore).build());
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getMenuEntry().getTarget().contains("Phantom Muspah")) {
            event.getMenuEntry().setTarget(event.getTarget().replace("Phantom Muspah", "The Grumbler"));
        }
        if (event.getMenuEntry().getTarget().contains("Muphin") && this.config.renamePet()) {
            event.getMenuEntry().setTarget(event.getMenuEntry().getTarget().replace("Muphin", "Lil' Grumble"));
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        Widget bossName = this.client.getWidget(303, 9);
        Widget colName = this.client.getWidget(621, 12);
        Widget colNameBig = this.client.getWidget(621, 19);
        Widget colNameSmall = this.client.getWidget(621, 19);
        Widget scoreBoardName = this.client.getWidget(817, 6);
        if (bossName != null && bossName.getText().contains("Phantom Muspah")) {
            bossName.setText(bossName.getText().replace("Phantom Muspah", "The Grumbler"));
        }
        if (colName != null) {
            colName = colName.getChild(27);
            colName.setText(colName.getText().replace("Phantom Muspah", "The Grumbler"));
        }
        if (colNameBig != null && colNameSmall != null) {
            colNameBig = colNameBig.getChild(0);
            colNameBig.setText(colNameBig.getText().replace("Phantom Muspah", "The Grumbler"));
            colNameSmall = colNameSmall.getChild(2);
            colNameSmall.setText(colNameSmall.getText().replace("Phantom Muspah", "The Grumbler"));
        }
        if (scoreBoardName != null) {
            scoreBoardName.setText(scoreBoardName.getText().replace("Phantom Muspah", "The Grumbler"));
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor().getName() == null) {
            return;
        }
        if (event.getActor().getName().equals("Phantom Muspah") && event.getActor().getHealthRatio() == 0 && this.config.catchPhrases() && event.getActor().getOverheadCycle() == 0) {
            int rand = this.r.nextInt(this.killPhrases.size());
            event.getActor().setOverheadText(this.killPhrases.get(rand));
            event.getActor().setOverheadCycle(80);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (event.getNpc().getName() == null) {
            return;
        }
        if (event.getNpc().getName().equals("Phantom Muspah") && this.config.catchPhrases()) {
            int rand = this.r.nextInt(this.spawnPhrases.size());
            event.getNpc().setOverheadCycle(100);
            event.getNpc().setOverheadText(this.spawnPhrases.get(rand));
        }
    }

    @Provides
    BossNameConfig provideConfig(ConfigManager configManager) {
        return (BossNameConfig)configManager.getConfig(BossNameConfig.class);
    }

    protected void startUp() throws Exception {
        log.info("BossNameReplacer Started");
    }

    protected void shutDown() throws Exception {
        log.info("BossNameReplacer Stopped");
    }
}

