/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax;

import com.farminghelper.speaax.FarmingHelperConfig;
import com.farminghelper.speaax.ItemRequirement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.runelite.api.coords.WorldPoint;

public class Location {
    private String name;
    private Boolean farmLimps;
    private List<Teleport> teleportOptions;
    private FarmingHelperConfig config;
    private final Function<FarmingHelperConfig, FarmingHelperConfig.OptionEnumTeleport> selectedTeleportFunction;

    public String getName() {
        return this.name;
    }

    public Boolean getFarmLimps() {
        return this.farmLimps;
    }

    public Location(Function<FarmingHelperConfig, FarmingHelperConfig.OptionEnumTeleport> selectedTeleportFunction, FarmingHelperConfig config, String name, Boolean farmLimps) {
        this.config = config;
        this.selectedTeleportFunction = selectedTeleportFunction;
        this.name = name;
        this.farmLimps = farmLimps;
        this.teleportOptions = new ArrayList<Teleport>();
    }

    public void addTeleportOption(Teleport teleport) {
        this.teleportOptions.add(teleport);
    }

    public Teleport getSelectedTeleport() {
        String selectedEnumOption = this.selectedTeleportFunction.apply(this.config).name();
        for (Teleport teleport : this.teleportOptions) {
            if (!teleport.getEnumOption().equalsIgnoreCase(selectedEnumOption)) continue;
            return teleport;
        }
        return this.teleportOptions.isEmpty() ? null : this.teleportOptions.get(0);
    }

    public class Teleport {
        private TeleportCategory category;
        private String description;
        private Color color;
        private int id;
        private int interfaceGroupId;
        private int interfaceChildId;
        private int regionId;
        private String enumOption;
        private String rightClickOption;
        private List<ItemRequirement> itemRequirements;
        private WorldPoint point;

        public Teleport(String enumOption, TeleportCategory category, String description, int id, String rightClickOption, int interfaceGroupId, int interfaceChildId, int regionId, WorldPoint point, List<ItemRequirement> itemRequirements) {
            this.enumOption = enumOption;
            this.category = category;
            this.description = description;
            this.id = id;
            this.rightClickOption = rightClickOption;
            this.interfaceGroupId = interfaceGroupId;
            this.interfaceChildId = interfaceChildId;
            this.regionId = regionId;
            this.point = point;
            this.itemRequirements = itemRequirements;
        }

        public Map<Integer, Integer> getItemRequirements() {
            HashMap<Integer, Integer> requirements = new HashMap<Integer, Integer>();
            for (ItemRequirement itemRequirement : this.itemRequirements) {
                requirements.put(itemRequirement.getItemId(), itemRequirement.getQuantity());
            }
            return requirements;
        }

        public WorldPoint getPoint() {
            return this.point;
        }

        public void addItemRequirement(int itemId, int quantity) {
            ItemRequirement itemRequirement = new ItemRequirement(itemId, quantity);
            this.itemRequirements.add(itemRequirement);
        }

        public void addAllItemRequirements(List<ItemRequirement> itemRequirements) {
            this.itemRequirements.addAll(itemRequirements);
        }

        public void updateTeleportItemId(int newItemId) {
            this.id = newItemId;
        }

        public TeleportCategory getCategory() {
            return this.category;
        }

        public int getRegionId() {
            return this.regionId;
        }

        public String getEnumOption() {
            return this.enumOption;
        }

        public String getDescription() {
            return this.description;
        }

        public String getRightClickOption() {
            return this.rightClickOption;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getInterfaceGroupId() {
            return this.interfaceGroupId;
        }

        public void setInterfaceGroupId(int interfaceGroupId) {
            this.interfaceGroupId = interfaceGroupId;
        }

        public int getInterfaceChildId() {
            return this.interfaceChildId;
        }

        public void setInterfaceChildId(int interfaceChildId) {
            this.interfaceChildId = interfaceChildId;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static enum TeleportCategory {
        ITEM,
        PORTAL_NEXUS,
        JEWELLERY_BOX,
        MOUNTED_XERICS,
        SPELLBOOK;

    }
}

