/*
 * Decompiled with CFR 0.152.
 */
package com.farminghelper.speaax.ItemsAndLocations;

import com.farminghelper.speaax.FarmingHelperConfig;
import com.farminghelper.speaax.FarmingHelperPlugin;
import com.farminghelper.speaax.ItemRequirement;
import com.farminghelper.speaax.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;

public class TreeRunItemAndLocation {
    private FarmingHelperConfig config;
    private Client client;
    private FarmingHelperPlugin plugin;
    public Location faladorTreeLocation;
    public Location farmingGuildTreeLocation;
    public Location gnomeStrongholdTreeLocation;
    public Location lumbridgeTreeLocation;
    public Location taverleyTreeLocation;
    public Location varrockTreeLocation;
    public List<Location> locations = new ArrayList<Location>();

    public TreeRunItemAndLocation() {
    }

    public TreeRunItemAndLocation(FarmingHelperConfig config, Client client, FarmingHelperPlugin plugin) {
        this.config = config;
        this.client = client;
        this.plugin = plugin;
    }

    public Map<Integer, Integer> getTreeItems() {
        return this.getAllItemRequirements(this.locations);
    }

    public List<ItemRequirement> getHouseTeleportItemRequirements() {
        FarmingHelperConfig.OptionEnumHouseTele selectedOption = this.config.enumConfigHouseTele();
        ArrayList<ItemRequirement> itemRequirements = new ArrayList<ItemRequirement>();
        switch (selectedOption) {
            case Law_air_earth_runes: {
                itemRequirements.add(new ItemRequirement(556, 1));
                itemRequirements.add(new ItemRequirement(557, 1));
                itemRequirements.add(new ItemRequirement(563, 1));
                break;
            }
            case Teleport_To_House: {
                itemRequirements.add(new ItemRequirement(8013, 1));
                break;
            }
            case Construction_cape: {
                itemRequirements.add(new ItemRequirement(9789, 1));
                break;
            }
            case Construction_cape_t: {
                itemRequirements.add(new ItemRequirement(9790, 1));
                break;
            }
            case Max_cape: {
                itemRequirements.add(new ItemRequirement(13280, 1));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + selectedOption);
            }
        }
        return itemRequirements;
    }

    public Map<Integer, Integer> getAllItemRequirements(List<Location> locations) {
        HashMap<Integer, Integer> allRequirements = new HashMap<Integer, Integer>();
        this.setupTreeLocations();
        for (Location location : locations) {
            if (!this.plugin.getTreeLocationEnabled(location.getName())) continue;
            allRequirements.merge(5370, 1, Integer::sum);
            allRequirements.merge(995, 200, Integer::sum);
            Location.Teleport teleport = location.getSelectedTeleport();
            Map<Integer, Integer> locationRequirements = teleport.getItemRequirements();
            for (Map.Entry<Integer, Integer> entry : locationRequirements.entrySet()) {
                int itemId = entry.getKey();
                int quantity = entry.getValue();
                if (itemId == 9789 || itemId == 9790 || itemId == 13280) {
                    allRequirements.merge(itemId, quantity, (oldValue, newValue) -> Math.min(1, oldValue + newValue));
                    continue;
                }
                allRequirements.merge(itemId, quantity, Integer::sum);
            }
        }
        allRequirements.merge(952, 1, Integer::sum);
        allRequirements.merge(22997, 1, Integer::sum);
        allRequirements.merge(7409, 1, Integer::sum);
        if (this.config.generalRake()) {
            allRequirements.merge(5341, 1, Integer::sum);
        }
        return allRequirements;
    }

    public void setupTreeLocations() {
        this.locations.clear();
        this.faladorTreeLocation = new Location(FarmingHelperConfig::enumTreeFaladorTeleport, this.config, "Falador", false);
        List<ItemRequirement> faladorTreeTeleportItems = Arrays.asList(new ItemRequirement(556, 3), new ItemRequirement(563, 1), new ItemRequirement(555, 1));
        WorldPoint faladorTreePatchPoint = new WorldPoint(3000, 3373, 0);
        Location location = this.faladorTreeLocation;
        Objects.requireNonNull(location);
        Location.Teleport faladorTreeTeleport = location.new Location.Teleport("Falador_teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Falador with Spellbook and run to Falador park.", 0, "null", 218, 27, 11828, faladorTreePatchPoint, faladorTreeTeleportItems);
        this.faladorTreeLocation.addTeleportOption(faladorTreeTeleport);
        this.locations.add(this.faladorTreeLocation);
        this.farmingGuildTreeLocation = new Location(FarmingHelperConfig::enumTreeFarmingGuildTeleport, this.config, "Farming Guild", false);
        List<ItemRequirement> farmingGuildTreeTeleportItems = this.getHouseTeleportItemRequirements();
        WorldPoint farmingGuildTreePatchPoint = new WorldPoint(1232, 3736, 0);
        Location location2 = this.farmingGuildTreeLocation;
        Objects.requireNonNull(location2);
        Location.Teleport farmingGuildTreeTeleport = location2.new Location.Teleport("Jewellery_box", Location.TeleportCategory.JEWELLERY_BOX, "Teleport to Farming Guild with Jewellery box.", 0, "null", 0, 0, 4922, farmingGuildTreePatchPoint, farmingGuildTreeTeleportItems);
        this.farmingGuildTreeLocation.addTeleportOption(farmingGuildTreeTeleport);
        this.locations.add(this.farmingGuildTreeLocation);
        this.gnomeStrongholdTreeLocation = new Location(FarmingHelperConfig::enumTreeGnomeStrongoldTeleport, this.config, "Gnome Stronghold", false);
        List<ItemRequirement> gnomeStrongholdTreeTeleportItems = Arrays.asList(new ItemRequirement(19564, 1));
        WorldPoint gnomeStrongholdTreePatchPoint = new WorldPoint(2436, 3415, 0);
        Location location3 = this.gnomeStrongholdTreeLocation;
        Objects.requireNonNull(location3);
        Location.Teleport gnomeStrongholdTreeTeleport = location3.new Location.Teleport("Royal_seed_pod", Location.TeleportCategory.ITEM, "Teleport to Gnome Stronghold with Royal seed pod.", 19564, "null", 0, 0, 9782, gnomeStrongholdTreePatchPoint, gnomeStrongholdTreeTeleportItems);
        this.gnomeStrongholdTreeLocation.addTeleportOption(gnomeStrongholdTreeTeleport);
        this.locations.add(this.gnomeStrongholdTreeLocation);
        this.lumbridgeTreeLocation = new Location(FarmingHelperConfig::enumTreeLumbridgeTeleport, this.config, "Lumbridge", false);
        List<ItemRequirement> lumbridgeTreeTeleportItems = Arrays.asList(new ItemRequirement(556, 3), new ItemRequirement(563, 1), new ItemRequirement(557, 1));
        WorldPoint lumbridgeTreePatchPoint = new WorldPoint(3193, 3231, 0);
        Location location4 = this.lumbridgeTreeLocation;
        Objects.requireNonNull(location4);
        Location.Teleport lumbridgeTreeTeleport = location4.new Location.Teleport("Lumbridge_teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Lumbridge with spellbook.", 0, "null", 218, 24, 12850, lumbridgeTreePatchPoint, lumbridgeTreeTeleportItems);
        this.lumbridgeTreeLocation.addTeleportOption(lumbridgeTreeTeleport);
        this.locations.add(this.lumbridgeTreeLocation);
        this.taverleyTreeLocation = new Location(FarmingHelperConfig::enumTreeTaverleyTeleport, this.config, "Taverley", false);
        List<ItemRequirement> taverleyTreeTeleportItems = Arrays.asList(new ItemRequirement(556, 3), new ItemRequirement(563, 1), new ItemRequirement(555, 1));
        WorldPoint taverlyPatchPoint = new WorldPoint(2936, 3438, 0);
        Location location5 = this.taverleyTreeLocation;
        Objects.requireNonNull(location5);
        Location.Teleport taverleyTreeTeleport = location5.new Location.Teleport("Falador_teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Falador with spellbook and run to Taverly.", 0, "null", 218, 27, 11828, taverlyPatchPoint, taverleyTreeTeleportItems);
        this.taverleyTreeLocation.addTeleportOption(taverleyTreeTeleport);
        this.locations.add(this.taverleyTreeLocation);
        this.varrockTreeLocation = new Location(FarmingHelperConfig::enumTreeVarrockTeleport, this.config, "Varrock", false);
        List<ItemRequirement> varrockTreeTeleportItems = Arrays.asList(new ItemRequirement(556, 3), new ItemRequirement(563, 1), new ItemRequirement(554, 1));
        WorldPoint varrockTreePatchPoint = new WorldPoint(3229, 3459, 0);
        Location location6 = this.varrockTreeLocation;
        Objects.requireNonNull(location6);
        Location.Teleport varrockTreeTeleport = location6.new Location.Teleport("Varrock_teleport", Location.TeleportCategory.SPELLBOOK, "Teleport to Varrock with spellbook.", 0, "null", 218, 21, 12853, varrockTreePatchPoint, varrockTreeTeleportItems);
        this.varrockTreeLocation.addTeleportOption(varrockTreeTeleport);
        this.locations.add(this.varrockTreeLocation);
    }
}

